/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.reflect.AgentPulse;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class AgentPulseForm
extends Form<AgentPulse> {
    AgentPulseForm() {
    }

    public Class<?> type() {
        return AgentPulse.class;
    }

    public Item mold(AgentPulse pulse) {
        if (pulse != null) {
            Record record = Record.create((int)5);
            if (pulse.agentCount > 0L) {
                record.slot("agentCount", pulse.agentCount);
            }
            if (pulse.execRate > 0L) {
                record.slot("execRate", pulse.execRate);
            }
            if (pulse.execTime > 0L) {
                record.slot("execTime", pulse.execTime);
            }
            if (pulse.timerEventRate > 0) {
                record.slot("timerEventRate", pulse.timerEventRate);
            }
            if (pulse.timerEventCount > 0L) {
                record.slot("timerEventCount", pulse.timerEventCount);
            }
            return record;
        }
        return Item.extant();
    }

    public AgentPulse cast(Item item) {
        Value value = item.toValue();
        long agentCount = value.get("agentCount").longValue(0L);
        long execRate = value.get("execRate").longValue(0L);
        long execTime = value.get("execTime").longValue(0L);
        int timerEventRate = value.get("timerEventRate").intValue(0);
        long timerEventCount = value.get("timerEventCount").longValue(0L);
        return new AgentPulse(agentCount, execRate, execTime, timerEventRate, timerEventCount);
    }
}

