/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.reflect.AgentPulse;
import swim.runtime.reflect.EdgePulse;
import swim.runtime.reflect.WarpDownlinkPulse;
import swim.runtime.reflect.WarpUplinkPulse;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class EdgePulseForm
extends Form<EdgePulse> {
    EdgePulseForm() {
    }

    public Class<?> type() {
        return EdgePulse.class;
    }

    public Item mold(EdgePulse pulse) {
        if (pulse != null) {
            Record record = Record.create((int)7);
            if (pulse.meshCount > 0) {
                record.slot("meshCount", pulse.meshCount);
            }
            if (pulse.partCount > 0) {
                record.slot("partCount", pulse.partCount);
            }
            if (pulse.hostCount > 0) {
                record.slot("hostCount", pulse.hostCount);
            }
            if (pulse.nodeCount > 0L) {
                record.slot("nodeCount", pulse.nodeCount);
            }
            if (pulse.agents.isDefined()) {
                record.slot("agents", pulse.agents.toValue());
            }
            if (pulse.downlinks.isDefined()) {
                record.slot("downlinks", pulse.downlinks.toValue());
            }
            if (pulse.uplinks.isDefined()) {
                record.slot("uplinks", pulse.uplinks.toValue());
            }
            return record;
        }
        return Item.extant();
    }

    public EdgePulse cast(Item item) {
        Value value = item.toValue();
        int edgeCount = value.get("edgeCount").intValue(0);
        int partCount = value.get("partCount").intValue(0);
        int hostCount = value.get("hostCount").intValue(0);
        long nodeCount = value.get("nodeCount").longValue(0L);
        AgentPulse agents = (AgentPulse)value.get("agents").coerce(AgentPulse.form());
        WarpDownlinkPulse downlinks = (WarpDownlinkPulse)value.get("downlinks").coerce(WarpDownlinkPulse.form());
        WarpUplinkPulse uplinks = (WarpUplinkPulse)value.get("uplinks").coerce(WarpUplinkPulse.form());
        return new EdgePulse(edgeCount, partCount, hostCount, nodeCount, agents, downlinks, uplinks);
    }
}

