/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.HostBinding;
import swim.runtime.reflect.HostInfoForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;

public class HostInfo {
    private static Form<HostInfo> form;
    protected final Uri hostUri;
    protected final boolean connected;
    protected final boolean remote;
    protected final boolean secure;
    protected final boolean primary;
    protected final boolean replica;
    protected final boolean master;
    protected final boolean slave;
    protected final long nodeCount;

    public HostInfo(Uri hostUri, boolean connected, boolean remote, boolean secure, boolean primary, boolean replica, boolean master, boolean slave, long nodeCount) {
        this.hostUri = hostUri;
        this.connected = connected;
        this.remote = remote;
        this.secure = secure;
        this.primary = primary;
        this.replica = replica;
        this.master = master;
        this.slave = slave;
        this.nodeCount = nodeCount;
    }

    public static HostInfo from(HostBinding hostBinding) {
        return new HostInfo(hostBinding.hostUri(), hostBinding.isConnected(), hostBinding.isRemote(), hostBinding.isSecure(), hostBinding.isPrimary(), hostBinding.isReplica(), hostBinding.isMaster(), hostBinding.isSlave(), hostBinding.nodes().size());
    }

    @Kind
    public static Form<HostInfo> form() {
        if (form == null) {
            form = new HostInfoForm();
        }
        return form;
    }

    public final Uri hostUri() {
        return this.hostUri;
    }

    public final boolean connected() {
        return this.connected;
    }

    public final boolean remote() {
        return this.remote;
    }

    public final boolean secure() {
        return this.secure;
    }

    public final boolean primary() {
        return this.primary;
    }

    public final boolean replica() {
        return this.replica;
    }

    public final boolean master() {
        return this.master;
    }

    public final boolean slave() {
        return this.slave;
    }

    public final long nodeCount() {
        return this.nodeCount;
    }

    public Value toValue() {
        return HostInfo.form().mold((Object)this).toValue();
    }
}

