/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.reflect.HostInfo;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

final class HostInfoForm
extends Form<HostInfo> {
    HostInfoForm() {
    }

    public Class<?> type() {
        return HostInfo.class;
    }

    public Item mold(HostInfo info) {
        if (info != null) {
            Record record = Record.create((int)9);
            record.slot("hostUri", info.hostUri.toString());
            record.slot("connected", info.connected);
            if (info.remote) {
                record.slot("remote", info.remote);
            }
            if (info.secure) {
                record.slot("secure", info.secure);
            }
            if (info.primary) {
                record.slot("primary", info.primary);
            }
            if (info.replica) {
                record.slot("replica", info.replica);
            }
            if (info.master) {
                record.slot("master", info.master);
            }
            if (info.slave) {
                record.slot("slave", info.slave);
            }
            if (info.nodeCount != 0L) {
                record.slot("nodeCount", info.nodeCount);
            }
            return record;
        }
        return Item.extant();
    }

    public HostInfo cast(Item item) {
        Value value = item.toValue();
        Uri hostUri = (Uri)Uri.form().cast((Item)value.get("hostUri"));
        if (hostUri != null) {
            boolean connected = value.get("connected").booleanValue(false);
            boolean remote = value.get("remote").booleanValue(false);
            boolean secure = value.get("secure").booleanValue(false);
            boolean primary = value.get("primary").booleanValue(false);
            boolean replica = value.get("replica").booleanValue(false);
            boolean master = value.get("master").booleanValue(false);
            boolean slave = value.get("slave").booleanValue(false);
            long nodeCount = value.get("nodeCount").longValue(0L);
            return new HostInfo(hostUri, connected, remote, secure, primary, replica, master, slave, nodeCount);
        }
        return null;
    }
}

