/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.reflect.AgentPulse;
import swim.runtime.reflect.HostPulse;
import swim.runtime.reflect.WarpDownlinkPulse;
import swim.runtime.reflect.WarpUplinkPulse;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class HostPulseForm
extends Form<HostPulse> {
    HostPulseForm() {
    }

    public Class<?> type() {
        return HostPulse.class;
    }

    public Item mold(HostPulse pulse) {
        if (pulse != null) {
            Record record = Record.create((int)4);
            if (pulse.nodeCount > 0L) {
                record.slot("nodeCount", pulse.nodeCount);
            }
            if (pulse.agents.isDefined()) {
                record.slot("agents", pulse.agents.toValue());
            }
            if (pulse.downlinks.isDefined()) {
                record.slot("downlinks", pulse.downlinks.toValue());
            }
            if (pulse.uplinks.isDefined()) {
                record.slot("uplinks", pulse.uplinks.toValue());
            }
            return record;
        }
        return Item.extant();
    }

    public HostPulse cast(Item item) {
        Value value = item.toValue();
        long nodeCount = value.get("nodeCount").longValue(0L);
        AgentPulse agents = (AgentPulse)value.get("agents").coerce(AgentPulse.form());
        WarpDownlinkPulse downlinks = (WarpDownlinkPulse)value.get("downlinks").coerce(WarpDownlinkPulse.form());
        WarpUplinkPulse uplinks = (WarpUplinkPulse)value.get("uplinks").coerce(WarpUplinkPulse.form());
        return new HostPulse(nodeCount, agents, downlinks, uplinks);
    }
}

