/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.reflect.LogEntryForm;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Kind;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

public class LogEntry {
    public static final Uri TRACE_LOG_URI = Uri.parse((String)"traceLog");
    public static final Uri DEBUG_LOG_URI = Uri.parse((String)"debugLog");
    public static final Uri INFO_LOG_URI = Uri.parse((String)"infoLog");
    public static final Uri WARN_LOG_URI = Uri.parse((String)"warnLog");
    public static final Uri ERROR_LOG_URI = Uri.parse((String)"errorLog");
    public static final Uri FAIL_LOG_URI = Uri.parse((String)"failLog");
    private static Form<LogEntry> form;
    protected final String tag;
    protected final long time;
    protected final Uri nodeUri;
    protected final Uri laneUri;
    protected final Value message;

    public LogEntry(String tag, long time, Uri nodeUri, Uri laneUri, Value message) {
        this.tag = tag;
        this.time = time;
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
        this.message = message;
    }

    public static LogEntry message(String tag, Uri nodeUri, Uri laneUri, Object message) {
        long time = System.currentTimeMillis();
        return new LogEntry(tag, time, nodeUri, laneUri, Value.fromObject((Object)message));
    }

    public static LogEntry trace(Uri nodeUri, Uri laneUri, Object message) {
        return LogEntry.message("trace", nodeUri, laneUri, message);
    }

    public static LogEntry trace(Uri nodeUri, Object message) {
        return LogEntry.message("trace", nodeUri, Uri.empty(), message);
    }

    public static LogEntry trace(Object message) {
        return LogEntry.message("trace", Uri.empty(), Uri.empty(), message);
    }

    public static LogEntry debug(Uri nodeUri, Uri laneUri, Object message) {
        return LogEntry.message("debug", nodeUri, laneUri, message);
    }

    public static LogEntry debug(Uri nodeUri, Object message) {
        return LogEntry.message("debug", nodeUri, Uri.empty(), message);
    }

    public static LogEntry debug(Object message) {
        return LogEntry.message("debug", Uri.empty(), Uri.empty(), message);
    }

    public static LogEntry info(Uri nodeUri, Uri laneUri, Object message) {
        return LogEntry.message("info", nodeUri, laneUri, message);
    }

    public static LogEntry info(Uri nodeUri, Object message) {
        return LogEntry.message("info", nodeUri, Uri.empty(), message);
    }

    public static LogEntry info(Object message) {
        return LogEntry.message("info", Uri.empty(), Uri.empty(), message);
    }

    public static LogEntry warn(Uri nodeUri, Uri laneUri, Object message) {
        return LogEntry.message("warn", nodeUri, laneUri, message);
    }

    public static LogEntry warn(Uri nodeUri, Object message) {
        return LogEntry.message("warn", nodeUri, Uri.empty(), message);
    }

    public static LogEntry warn(Object message) {
        return LogEntry.message("warn", Uri.empty(), Uri.empty(), message);
    }

    public static LogEntry error(Uri nodeUri, Uri laneUri, Object message) {
        return LogEntry.message("error", nodeUri, laneUri, message);
    }

    public static LogEntry error(Uri nodeUri, Object message) {
        return LogEntry.message("error", nodeUri, Uri.empty(), message);
    }

    public static LogEntry error(Object message) {
        return LogEntry.message("error", Uri.empty(), Uri.empty(), message);
    }

    public static LogEntry fail(Uri nodeUri, Uri laneUri, Object message) {
        return LogEntry.message("fail", nodeUri, laneUri, message instanceof Throwable ? LogEntry.moldException((Throwable)message) : message);
    }

    public static LogEntry fail(Uri nodeUri, Object message) {
        return LogEntry.message("fail", nodeUri, Uri.empty(), message instanceof Throwable ? LogEntry.moldException((Throwable)message) : message);
    }

    public static LogEntry fail(Object message) {
        return LogEntry.message("fail", Uri.empty(), Uri.empty(), message instanceof Throwable ? LogEntry.moldException((Throwable)message) : message);
    }

    @Kind
    public static Form<LogEntry> form() {
        if (form == null) {
            form = new LogEntryForm();
        }
        return form;
    }

    static Value moldException(Throwable cause) {
        StackTraceElement[] frames = cause.getStackTrace();
        int frameCount = frames.length;
        Record record = Record.create((int)(1 + frameCount)).attr("exception", cause.getMessage());
        for (int i = 0; i < frameCount; ++i) {
            record.item((Item)LogEntry.moldStackFrame(frames[i]));
        }
        return record;
    }

    static Value moldStackFrame(StackTraceElement frame) {
        Record header = Record.create((int)4).slot("class", frame.getClassName()).slot("method", frame.getMethodName());
        if (frame.isNativeMethod()) {
            header.slot("native", true);
        }
        if (frame.getFileName() != null) {
            header.slot("file", frame.getFileName());
        }
        if (frame.getLineNumber() >= 0) {
            header.slot("line", frame.getLineNumber());
        }
        return Record.create((int)1).attr("at", (Value)header);
    }

    public final String tag() {
        return this.tag;
    }

    public final long time() {
        return this.time;
    }

    public final Uri nodeUri() {
        return this.nodeUri;
    }

    public final Uri laneUri() {
        return this.laneUri;
    }

    public Value toValue() {
        return LogEntry.form().mold((Object)this).toValue();
    }
}

