/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.MeshBinding;
import swim.runtime.PartBinding;
import swim.runtime.reflect.MeshInfoForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;

public class MeshInfo {
    private static Form<MeshInfo> form;
    protected final Uri meshUri;
    protected final Value gatewayPartKey;
    protected final Value ourselfPartKey;
    protected final int partCount;

    public MeshInfo(Uri meshUri, Value gatewayPartKey, Value ourselfPartKey, int partCount) {
        this.meshUri = meshUri;
        this.gatewayPartKey = gatewayPartKey;
        this.ourselfPartKey = ourselfPartKey;
        this.partCount = partCount;
    }

    public static MeshInfo from(MeshBinding meshBinding) {
        PartBinding gateway = meshBinding.gateway();
        PartBinding ourself = meshBinding.ourself();
        return new MeshInfo(meshBinding.meshUri(), gateway != null ? gateway.partKey() : Value.absent(), ourself != null ? ourself.partKey() : Value.absent(), meshBinding.parts().size());
    }

    @Kind
    public static Form<MeshInfo> form() {
        if (form == null) {
            form = new MeshInfoForm();
        }
        return form;
    }

    public final Uri meshUri() {
        return this.meshUri;
    }

    public final Value gatewayPartKey() {
        return this.gatewayPartKey;
    }

    public final Value ourselfPartKey() {
        return this.ourselfPartKey;
    }

    public Value toValue() {
        return MeshInfo.form().mold((Object)this).toValue();
    }
}

