/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.reflect.MeshInfo;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

final class MeshInfoForm
extends Form<MeshInfo> {
    MeshInfoForm() {
    }

    public Class<?> type() {
        return MeshInfo.class;
    }

    public Item mold(MeshInfo info) {
        if (info != null) {
            Record record = Record.create((int)4);
            record.slot("meshUri", info.meshUri.toString());
            if (info.gatewayPartKey.isDefined()) {
                record.slot("gatewayPartKey", info.gatewayPartKey);
            }
            if (info.ourselfPartKey.isDefined()) {
                record.slot("ourselfPartKey", info.ourselfPartKey);
            }
            if (info.partCount != 0) {
                record.slot("partCount", info.partCount);
            }
            return record;
        }
        return Item.extant();
    }

    public MeshInfo cast(Item item) {
        Value value = item.toValue();
        Uri meshUri = (Uri)Uri.form().cast((Item)value.get("meshUri"));
        if (meshUri != null) {
            Value gatewayPartKey = value.get("gatewayPartKey");
            Value ourselfPartKey = value.get("ourselfPartKey");
            int partCount = value.get("partCount").intValue(0);
            return new MeshInfo(meshUri, gatewayPartKey, ourselfPartKey, partCount);
        }
        return null;
    }
}

