/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.reflect.AgentPulse;
import swim.runtime.reflect.MeshPulse;
import swim.runtime.reflect.WarpDownlinkPulse;
import swim.runtime.reflect.WarpUplinkPulse;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class MeshPulseForm
extends Form<MeshPulse> {
    MeshPulseForm() {
    }

    public Class<?> type() {
        return MeshPulse.class;
    }

    public Item mold(MeshPulse pulse) {
        if (pulse != null) {
            Record record = Record.create((int)6);
            if (pulse.partCount > 0) {
                record.slot("partCount", pulse.partCount);
            }
            if (pulse.hostCount > 0) {
                record.slot("hostCount", pulse.hostCount);
            }
            if (pulse.nodeCount > 0L) {
                record.slot("nodeCount", pulse.nodeCount);
            }
            if (pulse.agents.isDefined()) {
                record.slot("agents", pulse.agents.toValue());
            }
            if (pulse.downlinks.isDefined()) {
                record.slot("downlinks", pulse.downlinks.toValue());
            }
            if (pulse.uplinks.isDefined()) {
                record.slot("uplinks", pulse.uplinks.toValue());
            }
            return record;
        }
        return Item.extant();
    }

    public MeshPulse cast(Item item) {
        Value value = item.toValue();
        int partCount = value.get("partCount").intValue(0);
        int hostCount = value.get("hostCount").intValue(0);
        long nodeCount = value.get("nodeCount").longValue(0L);
        AgentPulse agents = (AgentPulse)value.get("agents").coerce(AgentPulse.form());
        WarpDownlinkPulse downlinks = (WarpDownlinkPulse)value.get("downlinks").coerce(WarpDownlinkPulse.form());
        WarpUplinkPulse uplinks = (WarpUplinkPulse)value.get("uplinks").coerce(WarpUplinkPulse.form());
        return new MeshPulse(partCount, hostCount, nodeCount, agents, downlinks, uplinks);
    }
}

