/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.HostBinding;
import swim.runtime.PartBinding;
import swim.runtime.PartPredicate;
import swim.runtime.reflect.PartInfoForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;

public class PartInfo {
    private static Form<PartInfo> form;
    protected final Value partKey;
    protected final PartPredicate predicate;
    protected final Uri masterHostUri;
    protected final int hostCount;

    public PartInfo(Value partKey, PartPredicate predicate, Uri masterHostUri, int hostCount) {
        this.partKey = partKey;
        this.predicate = predicate;
        this.masterHostUri = masterHostUri;
        this.hostCount = hostCount;
    }

    public static PartInfo from(PartBinding partBinding) {
        HostBinding master = partBinding.master();
        return new PartInfo(partBinding.partKey(), partBinding.predicate(), master != null ? master.hostUri() : Uri.empty(), partBinding.hosts().size());
    }

    @Kind
    public static Form<PartInfo> form() {
        if (form == null) {
            form = new PartInfoForm();
        }
        return form;
    }

    public final Value partKey() {
        return this.partKey;
    }

    public final PartPredicate predicate() {
        return this.predicate;
    }

    public final Uri masterHostUri() {
        return this.masterHostUri;
    }

    protected final int hostCount() {
        return this.hostCount;
    }

    public Value toValue() {
        return PartInfo.form().mold((Object)this).toValue();
    }
}

