/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.reflect.WarpDownlinkPulse;
import swim.runtime.reflect.WarpLanePulse;
import swim.runtime.reflect.WarpUplinkPulse;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class WarpLanePulseForm
extends Form<WarpLanePulse> {
    WarpLanePulseForm() {
    }

    public Class<?> type() {
        return WarpLanePulse.class;
    }

    public Item mold(WarpLanePulse pulse) {
        if (pulse != null) {
            Record record = Record.create((int)3);
            if (pulse.laneCount > 0L) {
                record.slot("laneCount", pulse.laneCount);
            }
            if (pulse.downlinkPulse.isDefined()) {
                record.slot("downlink", pulse.downlinkPulse.toValue());
            }
            if (pulse.uplinkPulse.isDefined()) {
                record.slot("uplink", pulse.uplinkPulse.toValue());
            }
            return record;
        }
        return Item.extant();
    }

    public WarpLanePulse cast(Item item) {
        Value value = item.toValue();
        long laneCount = value.get("laneCount").longValue(0L);
        WarpDownlinkPulse downlinkPulse = (WarpDownlinkPulse)value.get("downlink").coerce(WarpDownlinkPulse.form());
        WarpUplinkPulse uplinkPulse = (WarpUplinkPulse)value.get("uplink").coerce(WarpUplinkPulse.form());
        return new WarpLanePulse(laneCount, downlinkPulse, uplinkPulse);
    }
}

