/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.Lane;
import swim.api.lane.DemandLane;
import swim.api.lane.DemandMapLane;
import swim.api.lane.SupplyLane;
import swim.api.policy.Policy;
import swim.concurrent.Conts;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HostAddress;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.HostException;
import swim.runtime.LaneBinding;
import swim.runtime.LinkBinding;
import swim.runtime.Metric;
import swim.runtime.NodeAddress;
import swim.runtime.NodeBinding;
import swim.runtime.NodeContext;
import swim.runtime.PartBinding;
import swim.runtime.Push;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.UplinkError;
import swim.runtime.agent.AgentNode;
import swim.runtime.profile.HostProfile;
import swim.runtime.profile.NodeProfile;
import swim.runtime.profile.WarpDownlinkProfile;
import swim.runtime.reflect.AgentPulse;
import swim.runtime.reflect.HostPulse;
import swim.runtime.reflect.LogEntry;
import swim.runtime.reflect.NodeInfo;
import swim.runtime.reflect.WarpDownlinkPulse;
import swim.runtime.reflect.WarpUplinkPulse;
import swim.runtime.router.HostTableNode;
import swim.runtime.router.HostTableNodesController;
import swim.runtime.router.HostTablePulseController;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.uri.UriPath;
import swim.uri.UriPathBuilder;

public class HostTable
extends AbstractTierBinding
implements HostBinding {
    protected HostContext hostContext;
    volatile UriMapper<NodeBinding> nodes = UriMapper.empty();
    volatile int flags;
    volatile int nodeOpenDelta;
    volatile long nodeOpenCount;
    volatile int nodeCloseDelta;
    volatile long nodeCloseCount;
    volatile int agentOpenDelta;
    volatile long agentOpenCount;
    volatile int agentCloseDelta;
    volatile long agentCloseCount;
    volatile long agentExecDelta;
    volatile long agentExecRate;
    volatile long agentExecTime;
    volatile int timerEventDelta;
    volatile int timerEventRate;
    volatile long timerEventCount;
    volatile int downlinkOpenDelta;
    volatile long downlinkOpenCount;
    volatile int downlinkCloseDelta;
    volatile long downlinkCloseCount;
    volatile int downlinkEventDelta;
    volatile int downlinkEventRate;
    volatile long downlinkEventCount;
    volatile int downlinkCommandDelta;
    volatile int downlinkCommandRate;
    volatile long downlinkCommandCount;
    volatile int uplinkOpenDelta;
    volatile long uplinkOpenCount;
    volatile int uplinkCloseDelta;
    volatile long uplinkCloseCount;
    volatile int uplinkEventDelta;
    volatile int uplinkEventRate;
    volatile long uplinkEventCount;
    volatile int uplinkCommandDelta;
    volatile int uplinkCommandRate;
    volatile long uplinkCommandCount;
    volatile long lastReportTime;
    HostPulse pulse;
    AgentNode metaNode;
    DemandMapLane<Uri, NodeInfo> metaNodes;
    DemandLane<HostPulse> metaPulse;
    SupplyLane<LogEntry> metaTraceLog;
    SupplyLane<LogEntry> metaDebugLog;
    SupplyLane<LogEntry> metaInfoLog;
    SupplyLane<LogEntry> metaWarnLog;
    SupplyLane<LogEntry> metaErrorLog;
    SupplyLane<LogEntry> metaFailLog;
    static final int PRIMARY = 1;
    static final int REPLICA = 2;
    static final int MASTER = 4;
    static final int SLAVE = 8;
    static final Uri NODES_URI = Uri.parse((String)"nodes");
    static final AtomicReferenceFieldUpdater<HostTable, UriMapper<NodeBinding>> NODES = AtomicReferenceFieldUpdater.newUpdater(HostTable.class, UriMapper.class, "nodes");
    static final AtomicIntegerFieldUpdater<HostTable> FLAGS = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "flags");
    static final AtomicIntegerFieldUpdater<HostTable> NODE_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "nodeOpenDelta");
    static final AtomicLongFieldUpdater<HostTable> NODE_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "nodeOpenCount");
    static final AtomicIntegerFieldUpdater<HostTable> NODE_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "nodeCloseDelta");
    static final AtomicLongFieldUpdater<HostTable> NODE_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "nodeCloseCount");
    static final AtomicIntegerFieldUpdater<HostTable> AGENT_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "agentOpenDelta");
    static final AtomicLongFieldUpdater<HostTable> AGENT_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "agentOpenCount");
    static final AtomicIntegerFieldUpdater<HostTable> AGENT_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "agentCloseDelta");
    static final AtomicLongFieldUpdater<HostTable> AGENT_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "agentCloseCount");
    static final AtomicLongFieldUpdater<HostTable> AGENT_EXEC_DELTA = AtomicLongFieldUpdater.newUpdater(HostTable.class, "agentExecDelta");
    static final AtomicLongFieldUpdater<HostTable> AGENT_EXEC_RATE = AtomicLongFieldUpdater.newUpdater(HostTable.class, "agentExecRate");
    static final AtomicLongFieldUpdater<HostTable> AGENT_EXEC_TIME = AtomicLongFieldUpdater.newUpdater(HostTable.class, "agentExecTime");
    static final AtomicIntegerFieldUpdater<HostTable> TIMER_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "timerEventDelta");
    static final AtomicIntegerFieldUpdater<HostTable> TIMER_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "timerEventRate");
    static final AtomicLongFieldUpdater<HostTable> TIMER_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "timerEventCount");
    static final AtomicIntegerFieldUpdater<HostTable> DOWNLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "downlinkOpenDelta");
    static final AtomicLongFieldUpdater<HostTable> DOWNLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "downlinkOpenCount");
    static final AtomicIntegerFieldUpdater<HostTable> DOWNLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "downlinkCloseDelta");
    static final AtomicLongFieldUpdater<HostTable> DOWNLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "downlinkCloseCount");
    static final AtomicIntegerFieldUpdater<HostTable> DOWNLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "downlinkEventDelta");
    static final AtomicIntegerFieldUpdater<HostTable> DOWNLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "downlinkEventRate");
    static final AtomicLongFieldUpdater<HostTable> DOWNLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "downlinkEventCount");
    static final AtomicIntegerFieldUpdater<HostTable> DOWNLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "downlinkCommandDelta");
    static final AtomicIntegerFieldUpdater<HostTable> DOWNLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "downlinkCommandRate");
    static final AtomicLongFieldUpdater<HostTable> DOWNLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "downlinkCommandCount");
    static final AtomicIntegerFieldUpdater<HostTable> UPLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "uplinkOpenDelta");
    static final AtomicLongFieldUpdater<HostTable> UPLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "uplinkOpenCount");
    static final AtomicIntegerFieldUpdater<HostTable> UPLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "uplinkCloseDelta");
    static final AtomicLongFieldUpdater<HostTable> UPLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "uplinkCloseCount");
    static final AtomicIntegerFieldUpdater<HostTable> UPLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "uplinkEventDelta");
    static final AtomicIntegerFieldUpdater<HostTable> UPLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "uplinkEventRate");
    static final AtomicLongFieldUpdater<HostTable> UPLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "uplinkEventCount");
    static final AtomicIntegerFieldUpdater<HostTable> UPLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "uplinkCommandDelta");
    static final AtomicIntegerFieldUpdater<HostTable> UPLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "uplinkCommandRate");
    static final AtomicLongFieldUpdater<HostTable> UPLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(HostTable.class, "uplinkCommandCount");
    static final AtomicLongFieldUpdater<HostTable> LAST_REPORT_TIME = AtomicLongFieldUpdater.newUpdater(HostTable.class, "lastReportTime");

    @Override
    public final TierContext tierContext() {
        return this.hostContext;
    }

    @Override
    public final PartBinding part() {
        return this.hostContext.part();
    }

    @Override
    public final HostBinding hostWrapper() {
        return this;
    }

    @Override
    public final HostContext hostContext() {
        return this.hostContext;
    }

    @Override
    public void setHostContext(HostContext hostContext) {
        this.hostContext = hostContext;
    }

    @Override
    public <T> T unwrapHost(Class<T> hostClass) {
        if (hostClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.hostContext.unwrapHost(hostClass);
    }

    @Override
    public <T> T bottomHost(Class<T> hostClass) {
        Object host = this.hostContext.bottomHost(hostClass);
        if (host == null && hostClass.isAssignableFrom(this.getClass())) {
            host = this;
        }
        return host;
    }

    protected NodeContext createNodeContext(NodeAddress nodeAddress, NodeBinding node) {
        return new HostTableNode(this, node, nodeAddress);
    }

    @Override
    public final HostAddress cellAddress() {
        return this.hostContext.cellAddress();
    }

    @Override
    public final String edgeName() {
        return this.hostContext.edgeName();
    }

    @Override
    public final Uri meshUri() {
        return this.hostContext.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.hostContext.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.hostContext.hostUri();
    }

    @Override
    public Policy policy() {
        return this.hostContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.hostContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.hostContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.hostContext.store();
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public boolean isPrimary() {
        return (this.flags & 1) != 0;
    }

    @Override
    public void setPrimary(boolean isPrimary) {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags | 1) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    @Override
    public boolean isReplica() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void setReplica(boolean isReplica) {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags | 2) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    @Override
    public boolean isMaster() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isSlave() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void didBecomeMaster() {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags & 0xFFFFFFF7 | 4) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    @Override
    public void didBecomeSlave() {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags & 0xFFFFFFFB | 8) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
        if (oldFlags != newFlags) {
            this.closeNodes();
        }
    }

    @Override
    public void openMetaHost(HostBinding host, NodeBinding metaHost) {
        if (metaHost instanceof AgentNode) {
            this.metaNode = (AgentNode)metaHost;
            this.openMetaLanes(host, (AgentNode)metaHost);
        }
        this.hostContext.openMetaHost(host, metaHost);
    }

    protected void openMetaLanes(HostBinding host, AgentNode metaHost) {
        this.openReflectLanes(host, metaHost);
        this.openLogLanes(host, metaHost);
    }

    protected void openReflectLanes(HostBinding host, AgentNode metaHost) {
        this.metaNodes = metaHost.demandMapLane().keyForm(Uri.form()).valueForm(NodeInfo.form()).observe((Object)new HostTableNodesController(host));
        metaHost.openLane(NODES_URI, (Lane)this.metaNodes);
        this.metaPulse = this.metaNode.demandLane().valueForm(HostPulse.form()).observe((Object)new HostTablePulseController(this));
        this.metaNode.openLane(HostPulse.PULSE_URI, (Lane)this.metaPulse);
    }

    protected void openLogLanes(HostBinding host, AgentNode metaHost) {
        this.metaTraceLog = metaHost.supplyLane().valueForm(LogEntry.form());
        metaHost.openLane(LogEntry.TRACE_LOG_URI, (Lane)this.metaTraceLog);
        this.metaDebugLog = metaHost.supplyLane().valueForm(LogEntry.form());
        metaHost.openLane(LogEntry.DEBUG_LOG_URI, (Lane)this.metaDebugLog);
        this.metaInfoLog = metaHost.supplyLane().valueForm(LogEntry.form());
        metaHost.openLane(LogEntry.INFO_LOG_URI, (Lane)this.metaInfoLog);
        this.metaWarnLog = metaHost.supplyLane().valueForm(LogEntry.form());
        metaHost.openLane(LogEntry.WARN_LOG_URI, (Lane)this.metaWarnLog);
        this.metaErrorLog = metaHost.supplyLane().valueForm(LogEntry.form());
        metaHost.openLane(LogEntry.ERROR_LOG_URI, (Lane)this.metaErrorLog);
        this.metaFailLog = metaHost.supplyLane().valueForm(LogEntry.form());
        metaHost.openLane(LogEntry.FAIL_LOG_URI, (Lane)this.metaFailLog);
    }

    @Override
    public UriMapper<NodeBinding> nodes() {
        return this.nodes;
    }

    @Override
    public NodeBinding getNode(Uri nodeUri) {
        return (NodeBinding)this.nodes.get(nodeUri);
    }

    @Override
    public NodeBinding openNode(Uri nodeUri) {
        UriMapper newNodes;
        UriMapper oldNodes;
        TierBinding nodeBinding = null;
        do {
            NodeBinding node;
            if ((node = (NodeBinding)(oldNodes = this.nodes).get(nodeUri)) != null) {
                if (nodeBinding != null) {
                    nodeBinding.close();
                }
                newNodes = oldNodes;
                if (node.isStarted()) {
                    nodeBinding = node;
                    break;
                }
                nodeBinding = null;
                break;
            }
            if (nodeBinding == null) {
                NodeAddress nodeAddress = this.cellAddress().nodeUri(nodeUri);
                nodeBinding = this.hostContext.createNode(nodeAddress);
                if (nodeBinding != null) {
                    nodeBinding = this.hostContext.injectNode(nodeAddress, (NodeBinding)nodeBinding);
                    NodeContext nodeContext = this.createNodeContext(nodeAddress, (NodeBinding)nodeBinding);
                    nodeBinding.setNodeContext(nodeContext);
                    nodeBinding = nodeBinding.nodeWrapper();
                    nodeBinding.openLanes((NodeBinding)nodeBinding);
                    nodeBinding.openAgents((NodeBinding)nodeBinding);
                    newNodes = oldNodes.updated(nodeUri, (Object)nodeBinding);
                    continue;
                }
                newNodes = oldNodes;
                break;
            }
            newNodes = oldNodes.updated(nodeUri, (Object)nodeBinding);
        } while (nodeBinding == null || oldNodes != newNodes && !NODES.compareAndSet(this, (UriMapper<NodeBinding>)oldNodes, (UriMapper<NodeBinding>)newNodes));
        if (oldNodes != newNodes) {
            this.activate(nodeBinding);
            this.didOpenNode((NodeBinding)nodeBinding);
        }
        return nodeBinding;
    }

    @Override
    public NodeBinding openNode(Uri nodeUri, NodeBinding node) {
        UriMapper newNodes;
        UriMapper oldNodes;
        NodeBinding nodeBinding = null;
        do {
            if ((oldNodes = this.nodes).containsKey((Object)nodeUri)) {
                nodeBinding = null;
                newNodes = oldNodes;
                break;
            }
            if (nodeBinding != null) continue;
            NodeAddress nodeAddress = this.cellAddress().nodeUri(nodeUri);
            nodeBinding = this.hostContext.injectNode(nodeAddress, node);
            NodeContext nodeContext = this.createNodeContext(nodeAddress, nodeBinding);
            nodeBinding.setNodeContext(nodeContext);
            nodeBinding = nodeBinding.nodeWrapper();
            nodeBinding.openLanes(nodeBinding);
            nodeBinding.openAgents(nodeBinding);
        } while (oldNodes != (newNodes = oldNodes.updated(nodeUri, nodeBinding)) && !NODES.compareAndSet(this, (UriMapper<NodeBinding>)oldNodes, (UriMapper<NodeBinding>)newNodes));
        if (nodeBinding != null) {
            this.activate(nodeBinding);
            this.didOpenNode(nodeBinding);
        }
        return nodeBinding;
    }

    public void closeNode(Uri nodeUri) {
        UriMapper newNodes;
        UriMapper oldNodes;
        NodeBinding nodeBinding = null;
        do {
            NodeBinding node;
            if ((node = (NodeBinding)(oldNodes = this.nodes).get(nodeUri)) == null) {
                nodeBinding = null;
                newNodes = oldNodes;
                break;
            }
            nodeBinding = node;
            newNodes = oldNodes.removed(nodeUri);
        } while (oldNodes != newNodes && !NODES.compareAndSet(this, (UriMapper<NodeBinding>)oldNodes, (UriMapper<NodeBinding>)newNodes));
        if (nodeBinding != null) {
            nodeBinding.didClose();
            this.didCloseNode(nodeBinding);
        }
    }

    public void closeNodes() {
        UriMapper<NodeBinding> oldNodes;
        UriMapper newNodes = UriMapper.empty();
        while ((oldNodes = this.nodes) != newNodes && !NODES.compareAndSet(this, oldNodes, (UriMapper<NodeBinding>)newNodes)) {
        }
        if (!oldNodes.isEmpty()) {
            DemandMapLane<Uri, NodeInfo> metaNodes = this.metaNodes;
            for (NodeBinding nodeBinding : oldNodes.values()) {
                nodeBinding.close();
                nodeBinding.didClose();
                if (metaNodes == null) continue;
                metaNodes.cue((Object)nodeBinding.nodeUri());
            }
            this.flushMetrics();
        }
    }

    protected void didOpenNode(NodeBinding node) {
        DemandMapLane<Uri, NodeInfo> metaNodes = this.metaNodes;
        if (metaNodes != null) {
            Uri nodeUri = node.nodeUri();
            metaNodes.cue((Object)nodeUri);
            this.cueAncestorNodes(nodeUri);
        }
        NODE_OPEN_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void didCloseNode(NodeBinding node) {
        DemandMapLane<Uri, NodeInfo> metaNodes = this.metaNodes;
        if (metaNodes != null) {
            Uri nodeUri = node.nodeUri();
            metaNodes.remove((Object)nodeUri);
            this.cueAncestorNodes(nodeUri);
        }
        NODE_CLOSE_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void cueAncestorNodes(Uri nodeUri) {
        DemandMapLane<Uri, NodeInfo> metaNodes = this.metaNodes;
        if (metaNodes != null) {
            UriPath nodePath = nodeUri.path();
            UriPathBuilder ancestorPathBuilder = UriPath.builder();
            while (!nodePath.isEmpty()) {
                if (nodePath.isAbsolute()) {
                    ancestorPathBuilder.addSlash();
                    nodePath = nodePath.tail();
                    continue;
                }
                ancestorPathBuilder.addSegment(nodePath.head());
                if (!(nodePath = nodePath.tail()).isAbsolute()) continue;
                Uri ancestorUri = nodeUri.path(ancestorPathBuilder.bind());
                metaNodes.cue((Object)ancestorUri);
                ancestorPathBuilder.addSlash();
                nodePath = nodePath.tail();
            }
        }
    }

    @Override
    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        this.hostContext.openMetaNode(node, metaNode);
    }

    @Override
    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        this.hostContext.openMetaLane(lane, metaLane);
    }

    @Override
    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.hostContext.openMetaUplink(uplink, metaUplink);
    }

    @Override
    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.hostContext.openMetaDownlink(downlink, metaDownlink);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        LinkBinding link = this.hostContext.bindDownlink(downlink);
        link.setCellContext(this);
        return link;
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.hostContext.openDownlink(link);
        link.setCellContext(this);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
        this.hostContext.closeDownlink(link);
    }

    @Override
    public void pushDown(Push<?> push) {
        this.hostContext.pushDown(push);
    }

    @Override
    public void openUplink(LinkBinding link) {
        NodeBinding nodeBinding = this.openNode(link.nodeUri());
        if (nodeBinding != null) {
            nodeBinding = nodeBinding.bottomNode(NodeBinding.class);
        }
        if (nodeBinding != null) {
            nodeBinding.openUplink(link);
        } else {
            UplinkError.rejectNodeNotFound(link);
        }
    }

    @Override
    public void pushUp(Push<?> push) {
        Uri nodeUri = push.nodeUri();
        NodeBinding nodeBinding = this.openNode(nodeUri);
        if (nodeBinding != null) {
            nodeBinding = nodeBinding.bottomNode(NodeBinding.class);
        }
        if (nodeBinding != null) {
            nodeBinding.pushUp(push);
        } else {
            push.trap(new HostException("unknown node: " + nodeUri));
        }
    }

    public void trace(Object message) {
        SupplyLane<LogEntry> metaTraceLog = this.metaTraceLog;
        if (metaTraceLog != null) {
            metaTraceLog.push((Object)LogEntry.trace(message));
        }
        this.hostContext.trace(message);
    }

    public void debug(Object message) {
        SupplyLane<LogEntry> metaDebugLog = this.metaDebugLog;
        if (metaDebugLog != null) {
            metaDebugLog.push((Object)LogEntry.debug(message));
        }
        this.hostContext.debug(message);
    }

    public void info(Object message) {
        SupplyLane<LogEntry> metaInfoLog = this.metaInfoLog;
        if (metaInfoLog != null) {
            metaInfoLog.push((Object)LogEntry.info(message));
        }
        this.hostContext.info(message);
    }

    public void warn(Object message) {
        SupplyLane<LogEntry> metaWarnLog = this.metaWarnLog;
        if (metaWarnLog != null) {
            metaWarnLog.push((Object)LogEntry.warn(message));
        }
        this.hostContext.warn(message);
    }

    public void error(Object message) {
        SupplyLane<LogEntry> metaErrorLog = this.metaErrorLog;
        if (metaErrorLog != null) {
            metaErrorLog.push((Object)LogEntry.error(message));
        }
        this.hostContext.error(message);
    }

    public void fail(Object message) {
        SupplyLane<LogEntry> metaFailLog = this.metaFailLog;
        if (metaFailLog != null) {
            metaFailLog.push((Object)LogEntry.fail(message));
        }
        this.hostContext.fail(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
        super.didClose();
        AgentNode metaNode = this.metaNode;
        if (metaNode != null) {
            metaNode.close();
            this.metaNode = null;
            this.metaNodes = null;
            this.metaTraceLog = null;
            this.metaDebugLog = null;
            this.metaInfoLog = null;
            this.metaWarnLog = null;
            this.metaErrorLog = null;
            this.metaFailLog = null;
        }
        this.flushMetrics();
    }

    @Override
    public void didFail(Throwable error) {
        if (Conts.isNonFatal((Throwable)error)) {
            this.fail(error);
        } else {
            error.printStackTrace();
        }
    }

    @Override
    public void reportDown(Metric metric) {
        if (metric instanceof NodeProfile) {
            this.accumulateNodeProfile((NodeProfile)metric);
        } else if (metric instanceof WarpDownlinkProfile) {
            this.accumulateWarpDownlinkProfile((WarpDownlinkProfile)metric);
        } else {
            this.hostContext.reportDown(metric);
        }
    }

    protected void accumulateNodeProfile(NodeProfile profile) {
        AGENT_OPEN_DELTA.addAndGet(this, profile.agentOpenDelta());
        AGENT_CLOSE_DELTA.addAndGet(this, profile.agentCloseDelta());
        AGENT_EXEC_DELTA.addAndGet(this, profile.agentExecDelta());
        AGENT_EXEC_RATE.addAndGet(this, profile.agentExecRate());
        TIMER_EVENT_DELTA.addAndGet(this, profile.timerEventDelta());
        TIMER_EVENT_RATE.addAndGet(this, profile.timerEventRate());
        DOWNLINK_OPEN_DELTA.addAndGet(this, profile.downlinkOpenDelta());
        DOWNLINK_CLOSE_DELTA.addAndGet(this, profile.downlinkCloseDelta());
        DOWNLINK_EVENT_DELTA.addAndGet(this, profile.downlinkEventDelta());
        DOWNLINK_EVENT_RATE.addAndGet(this, profile.downlinkEventRate());
        DOWNLINK_COMMAND_DELTA.addAndGet(this, profile.downlinkCommandDelta());
        DOWNLINK_COMMAND_RATE.addAndGet(this, profile.downlinkCommandRate());
        UPLINK_OPEN_DELTA.addAndGet(this, profile.uplinkOpenDelta());
        UPLINK_CLOSE_DELTA.addAndGet(this, profile.uplinkCloseDelta());
        UPLINK_EVENT_DELTA.addAndGet(this, profile.uplinkEventDelta());
        UPLINK_EVENT_RATE.addAndGet(this, profile.uplinkEventRate());
        UPLINK_COMMAND_DELTA.addAndGet(this, profile.uplinkCommandDelta());
        UPLINK_COMMAND_RATE.addAndGet(this, profile.uplinkCommandRate());
        this.didUpdateMetrics();
    }

    protected void accumulateWarpDownlinkProfile(WarpDownlinkProfile profile) {
        DOWNLINK_OPEN_DELTA.addAndGet(this, profile.openDelta());
        DOWNLINK_CLOSE_DELTA.addAndGet(this, profile.closeDelta());
        DOWNLINK_EVENT_DELTA.addAndGet(this, profile.eventDelta());
        DOWNLINK_EVENT_RATE.addAndGet(this, profile.eventRate());
        DOWNLINK_COMMAND_DELTA.addAndGet(this, profile.commandDelta());
        DOWNLINK_COMMAND_RATE.addAndGet(this, profile.commandRate());
        this.didUpdateMetrics();
    }

    protected void didUpdateMetrics() {
        long oldReportTime;
        long newReportTime;
        long dt;
        while ((dt = (newReportTime = System.currentTimeMillis()) - (oldReportTime = this.lastReportTime)) >= 1000L) {
            if (!LAST_REPORT_TIME.compareAndSet(this, oldReportTime, newReportTime)) continue;
            try {
                this.reportMetrics(dt);
                break;
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break;
                }
                throw error;
            }
        }
    }

    protected void flushMetrics() {
        long newReportTime = System.currentTimeMillis();
        long oldReportTime = LAST_REPORT_TIME.getAndSet(this, newReportTime);
        long dt = newReportTime - oldReportTime;
        try {
            this.reportMetrics(dt);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void reportMetrics(long dt) {
        HostProfile profile = this.collectProfile(dt);
        this.hostContext.reportDown(profile);
    }

    protected HostProfile collectProfile(long dt) {
        int nodeOpenDelta = NODE_OPEN_DELTA.getAndSet(this, 0);
        long nodeOpenCount = NODE_OPEN_COUNT.addAndGet(this, nodeOpenDelta);
        int nodeCloseDelta = NODE_CLOSE_DELTA.getAndSet(this, 0);
        long nodeCloseCount = NODE_CLOSE_COUNT.addAndGet(this, nodeCloseDelta);
        int agentOpenDelta = AGENT_OPEN_DELTA.getAndSet(this, 0);
        long agentOpenCount = AGENT_OPEN_COUNT.addAndGet(this, agentOpenDelta);
        int agentCloseDelta = AGENT_CLOSE_DELTA.getAndSet(this, 0);
        long agentCloseCount = AGENT_CLOSE_COUNT.addAndGet(this, agentCloseDelta);
        long agentExecDelta = AGENT_EXEC_DELTA.getAndSet(this, 0L);
        long agentExecRate = AGENT_EXEC_RATE.getAndSet(this, 0L);
        long agentExecTime = AGENT_EXEC_TIME.addAndGet(this, agentExecDelta);
        int timerEventDelta = TIMER_EVENT_DELTA.getAndSet(this, 0);
        int timerEventRate = TIMER_EVENT_RATE.getAndSet(this, 0);
        long timerEventCount = TIMER_EVENT_COUNT.addAndGet(this, timerEventDelta);
        int downlinkOpenDelta = DOWNLINK_OPEN_DELTA.getAndSet(this, 0);
        long downlinkOpenCount = DOWNLINK_OPEN_COUNT.addAndGet(this, downlinkOpenDelta);
        int downlinkCloseDelta = DOWNLINK_CLOSE_DELTA.getAndSet(this, 0);
        long downlinkCloseCount = DOWNLINK_CLOSE_COUNT.addAndGet(this, downlinkCloseDelta);
        int downlinkEventDelta = DOWNLINK_EVENT_DELTA.getAndSet(this, 0);
        int downlinkEventRate = DOWNLINK_EVENT_RATE.getAndSet(this, 0);
        long downlinkEventCount = DOWNLINK_EVENT_COUNT.addAndGet(this, downlinkEventDelta);
        int downlinkCommandDelta = DOWNLINK_COMMAND_DELTA.getAndSet(this, 0);
        int downlinkCommandRate = DOWNLINK_COMMAND_RATE.getAndSet(this, 0);
        long downlinkCommandCount = DOWNLINK_COMMAND_COUNT.addAndGet(this, downlinkCommandDelta);
        int uplinkOpenDelta = UPLINK_OPEN_DELTA.getAndSet(this, 0);
        long uplinkOpenCount = UPLINK_OPEN_COUNT.addAndGet(this, uplinkOpenDelta);
        int uplinkCloseDelta = UPLINK_CLOSE_DELTA.getAndSet(this, 0);
        long uplinkCloseCount = UPLINK_CLOSE_COUNT.addAndGet(this, uplinkCloseDelta);
        int uplinkEventDelta = UPLINK_EVENT_DELTA.getAndSet(this, 0);
        int uplinkEventRate = UPLINK_EVENT_RATE.getAndSet(this, 0);
        long uplinkEventCount = UPLINK_EVENT_COUNT.addAndGet(this, uplinkEventDelta);
        int uplinkCommandDelta = UPLINK_COMMAND_DELTA.getAndSet(this, 0);
        int uplinkCommandRate = UPLINK_COMMAND_RATE.getAndSet(this, 0);
        long uplinkCommandCount = UPLINK_COMMAND_COUNT.addAndGet(this, uplinkCommandDelta);
        long nodeCount = nodeOpenCount - nodeCloseCount;
        long agentCount = agentOpenCount - agentCloseCount;
        AgentPulse agentPulse = new AgentPulse(agentCount, agentExecRate, agentExecTime, timerEventRate, timerEventCount);
        long downlinkCount = downlinkOpenCount - downlinkCloseCount;
        WarpDownlinkPulse downlinkPulse = new WarpDownlinkPulse(downlinkCount, downlinkEventRate, downlinkEventCount, downlinkCommandRate, downlinkCommandCount);
        long uplinkCount = uplinkOpenCount - uplinkCloseCount;
        WarpUplinkPulse uplinkPulse = new WarpUplinkPulse(uplinkCount, uplinkEventRate, uplinkEventCount, uplinkCommandRate, uplinkCommandCount);
        this.pulse = new HostPulse(nodeCount, agentPulse, downlinkPulse, uplinkPulse);
        DemandLane<HostPulse> metaPulse = this.metaPulse;
        if (metaPulse != null) {
            metaPulse.cue();
        }
        return new HostProfile(this.cellAddress(), nodeOpenDelta, nodeOpenCount, nodeCloseDelta, nodeCloseCount, agentOpenDelta, agentOpenCount, agentCloseDelta, agentCloseCount, agentExecDelta, agentExecRate, agentExecTime, timerEventDelta, timerEventRate, timerEventCount, downlinkOpenDelta, downlinkOpenCount, downlinkCloseDelta, downlinkCloseCount, downlinkEventDelta, downlinkEventRate, downlinkEventCount, downlinkCommandDelta, downlinkCommandRate, downlinkCommandCount, uplinkOpenDelta, uplinkOpenCount, uplinkCloseDelta, uplinkCloseCount, uplinkEventDelta, uplinkEventRate, uplinkEventCount, uplinkCommandDelta, uplinkCommandRate, uplinkCommandCount);
    }
}

