/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Iterator;
import java.util.Map;
import swim.runtime.NodeBinding;
import swim.uri.Uri;

final class HostTableNodesQueryIterator
implements Iterator<Uri> {
    final String query;
    final Iterator<Map.Entry<Uri, NodeBinding>> nodes;
    Uri nextNodeUri;

    HostTableNodesQueryIterator(String query, Iterator<Map.Entry<Uri, NodeBinding>> nodes) {
        this.query = query;
        this.nodes = nodes;
    }

    Uri nextNodeUri() {
        if (this.nextNodeUri == null) {
            while (this.nodes.hasNext()) {
                Map.Entry<Uri, NodeBinding> entry = this.nodes.next();
                Uri nodeUri = entry.getKey();
                if (!nodeUri.toString().contains(this.query)) continue;
                this.nextNodeUri = nodeUri;
                break;
            }
        }
        return this.nextNodeUri;
    }

    @Override
    public boolean hasNext() {
        return this.nextNodeUri() != null;
    }

    @Override
    public Uri next() {
        Uri nextNodeUri = this.nextNodeUri();
        this.nextNodeUri = null;
        return nextNodeUri;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

