/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.Lane;
import swim.api.lane.DemandLane;
import swim.api.lane.DemandMapLane;
import swim.api.lane.SupplyLane;
import swim.api.policy.Policy;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Conts;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.AbstractTierBinding;
import swim.runtime.EdgeBinding;
import swim.runtime.HostBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LinkBinding;
import swim.runtime.MeshAddress;
import swim.runtime.MeshBinding;
import swim.runtime.MeshContext;
import swim.runtime.MeshException;
import swim.runtime.Metric;
import swim.runtime.NodeBinding;
import swim.runtime.PartAddress;
import swim.runtime.PartBinding;
import swim.runtime.PartContext;
import swim.runtime.Push;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.UplinkError;
import swim.runtime.agent.AgentNode;
import swim.runtime.profile.MeshProfile;
import swim.runtime.profile.PartProfile;
import swim.runtime.profile.WarpDownlinkProfile;
import swim.runtime.reflect.AgentPulse;
import swim.runtime.reflect.LogEntry;
import swim.runtime.reflect.MeshPulse;
import swim.runtime.reflect.PartInfo;
import swim.runtime.reflect.WarpDownlinkPulse;
import swim.runtime.reflect.WarpUplinkPulse;
import swim.runtime.router.MeshTablePart;
import swim.runtime.router.MeshTablePartsController;
import swim.runtime.router.MeshTablePulseController;
import swim.store.StoreBinding;
import swim.structure.Extant;
import swim.structure.Form;
import swim.structure.Text;
import swim.structure.Value;
import swim.uri.Uri;

public class MeshTable
extends AbstractTierBinding
implements MeshBinding {
    protected MeshContext meshContext;
    volatile FingerTrieSeq<PartBinding> parts = FingerTrieSeq.empty();
    volatile PartBinding gateway;
    volatile PartBinding ourself;
    volatile int partOpenDelta;
    volatile long partOpenCount;
    volatile int partCloseDelta;
    volatile long partCloseCount;
    volatile int hostOpenDelta;
    volatile long hostOpenCount;
    volatile int hostCloseDelta;
    volatile long hostCloseCount;
    volatile int nodeOpenDelta;
    volatile long nodeOpenCount;
    volatile int nodeCloseDelta;
    volatile long nodeCloseCount;
    volatile int agentOpenDelta;
    volatile long agentOpenCount;
    volatile int agentCloseDelta;
    volatile long agentCloseCount;
    volatile long agentExecDelta;
    volatile long agentExecRate;
    volatile long agentExecTime;
    volatile int timerEventDelta;
    volatile int timerEventRate;
    volatile long timerEventCount;
    volatile int downlinkOpenDelta;
    volatile long downlinkOpenCount;
    volatile int downlinkCloseDelta;
    volatile long downlinkCloseCount;
    volatile int downlinkEventDelta;
    volatile int downlinkEventRate;
    volatile long downlinkEventCount;
    volatile int downlinkCommandDelta;
    volatile int downlinkCommandRate;
    volatile long downlinkCommandCount;
    volatile int uplinkOpenDelta;
    volatile long uplinkOpenCount;
    volatile int uplinkCloseDelta;
    volatile long uplinkCloseCount;
    volatile int uplinkEventDelta;
    volatile int uplinkEventRate;
    volatile long uplinkEventCount;
    volatile int uplinkCommandDelta;
    volatile int uplinkCommandRate;
    volatile long uplinkCommandCount;
    volatile long lastReportTime;
    MeshPulse pulse;
    AgentNode metaNode;
    DemandMapLane<Value, PartInfo> metaParts;
    DemandLane<MeshPulse> metaPulse;
    SupplyLane<LogEntry> metaTraceLog;
    SupplyLane<LogEntry> metaDebugLog;
    SupplyLane<LogEntry> metaInfoLog;
    SupplyLane<LogEntry> metaWarnLog;
    SupplyLane<LogEntry> metaErrorLog;
    SupplyLane<LogEntry> metaFailLog;
    static final Uri PARTS_URI = Uri.parse((String)"parts");
    static final AtomicReferenceFieldUpdater<MeshTable, FingerTrieSeq<PartBinding>> PARTS = AtomicReferenceFieldUpdater.newUpdater(MeshTable.class, FingerTrieSeq.class, "parts");
    static final AtomicIntegerFieldUpdater<MeshTable> PART_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "partOpenDelta");
    static final AtomicLongFieldUpdater<MeshTable> PART_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "partOpenCount");
    static final AtomicIntegerFieldUpdater<MeshTable> PART_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "partCloseDelta");
    static final AtomicLongFieldUpdater<MeshTable> PART_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "partCloseCount");
    static final AtomicIntegerFieldUpdater<MeshTable> HOST_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "hostOpenDelta");
    static final AtomicLongFieldUpdater<MeshTable> HOST_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "hostOpenCount");
    static final AtomicIntegerFieldUpdater<MeshTable> HOST_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "hostCloseDelta");
    static final AtomicLongFieldUpdater<MeshTable> HOST_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "hostCloseCount");
    static final AtomicIntegerFieldUpdater<MeshTable> NODE_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "nodeOpenDelta");
    static final AtomicLongFieldUpdater<MeshTable> NODE_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "nodeOpenCount");
    static final AtomicIntegerFieldUpdater<MeshTable> NODE_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "nodeCloseDelta");
    static final AtomicLongFieldUpdater<MeshTable> NODE_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "nodeCloseCount");
    static final AtomicIntegerFieldUpdater<MeshTable> AGENT_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "agentOpenDelta");
    static final AtomicLongFieldUpdater<MeshTable> AGENT_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "agentOpenCount");
    static final AtomicIntegerFieldUpdater<MeshTable> AGENT_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "agentCloseDelta");
    static final AtomicLongFieldUpdater<MeshTable> AGENT_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "agentCloseCount");
    static final AtomicLongFieldUpdater<MeshTable> AGENT_EXEC_DELTA = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "agentExecDelta");
    static final AtomicLongFieldUpdater<MeshTable> AGENT_EXEC_RATE = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "agentExecRate");
    static final AtomicLongFieldUpdater<MeshTable> AGENT_EXEC_TIME = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "agentExecTime");
    static final AtomicIntegerFieldUpdater<MeshTable> TIMER_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "timerEventDelta");
    static final AtomicIntegerFieldUpdater<MeshTable> TIMER_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "timerEventRate");
    static final AtomicLongFieldUpdater<MeshTable> TIMER_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "timerEventCount");
    static final AtomicIntegerFieldUpdater<MeshTable> DOWNLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "downlinkOpenDelta");
    static final AtomicLongFieldUpdater<MeshTable> DOWNLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "downlinkOpenCount");
    static final AtomicIntegerFieldUpdater<MeshTable> DOWNLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "downlinkCloseDelta");
    static final AtomicLongFieldUpdater<MeshTable> DOWNLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "downlinkCloseCount");
    static final AtomicIntegerFieldUpdater<MeshTable> DOWNLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "downlinkEventDelta");
    static final AtomicIntegerFieldUpdater<MeshTable> DOWNLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "downlinkEventRate");
    static final AtomicLongFieldUpdater<MeshTable> DOWNLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "downlinkEventCount");
    static final AtomicIntegerFieldUpdater<MeshTable> DOWNLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "downlinkCommandDelta");
    static final AtomicIntegerFieldUpdater<MeshTable> DOWNLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "downlinkCommandRate");
    static final AtomicLongFieldUpdater<MeshTable> DOWNLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "downlinkCommandCount");
    static final AtomicIntegerFieldUpdater<MeshTable> UPLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "uplinkOpenDelta");
    static final AtomicLongFieldUpdater<MeshTable> UPLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "uplinkOpenCount");
    static final AtomicIntegerFieldUpdater<MeshTable> UPLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "uplinkCloseDelta");
    static final AtomicLongFieldUpdater<MeshTable> UPLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "uplinkCloseCount");
    static final AtomicIntegerFieldUpdater<MeshTable> UPLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "uplinkEventDelta");
    static final AtomicIntegerFieldUpdater<MeshTable> UPLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "uplinkEventRate");
    static final AtomicLongFieldUpdater<MeshTable> UPLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "uplinkEventCount");
    static final AtomicIntegerFieldUpdater<MeshTable> UPLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "uplinkCommandDelta");
    static final AtomicIntegerFieldUpdater<MeshTable> UPLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(MeshTable.class, "uplinkCommandRate");
    static final AtomicLongFieldUpdater<MeshTable> UPLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "uplinkCommandCount");
    static final AtomicLongFieldUpdater<MeshTable> LAST_REPORT_TIME = AtomicLongFieldUpdater.newUpdater(MeshTable.class, "lastReportTime");

    @Override
    public final TierContext tierContext() {
        return this.meshContext;
    }

    @Override
    public final EdgeBinding edge() {
        return this.meshContext.edge();
    }

    @Override
    public final MeshBinding meshWrapper() {
        return this;
    }

    @Override
    public final MeshContext meshContext() {
        return this.meshContext;
    }

    @Override
    public void setMeshContext(MeshContext meshContext) {
        this.meshContext = meshContext;
    }

    @Override
    public <T> T unwrapMesh(Class<T> meshClass) {
        if (meshClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.meshContext.unwrapMesh(meshClass);
    }

    @Override
    public <T> T bottomMesh(Class<T> meshClass) {
        Object mesh = this.meshContext.bottomMesh(meshClass);
        if (mesh == null && meshClass.isAssignableFrom(this.getClass())) {
            mesh = this;
        }
        return mesh;
    }

    protected PartContext createPartContext(PartAddress partAddress, PartBinding part) {
        return new MeshTablePart(this, part, partAddress);
    }

    @Override
    public final MeshAddress cellAddress() {
        return this.meshContext.cellAddress();
    }

    @Override
    public final String edgeName() {
        return this.meshContext.edgeName();
    }

    @Override
    public final Uri meshUri() {
        return this.meshContext.meshUri();
    }

    @Override
    public Policy policy() {
        return this.meshContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.meshContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.meshContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.meshContext.store();
    }

    @Override
    public void openMetaMesh(MeshBinding mesh, NodeBinding metaMesh) {
        if (metaMesh instanceof AgentNode) {
            this.metaNode = (AgentNode)metaMesh;
            this.openMetaLanes(mesh, (AgentNode)metaMesh);
        }
        this.meshContext.openMetaMesh(mesh, metaMesh);
    }

    protected void openMetaLanes(MeshBinding mesh, AgentNode metaMesh) {
        this.openReflectLanes(mesh, metaMesh);
        this.openLogLanes(mesh, metaMesh);
    }

    protected void openReflectLanes(MeshBinding mesh, AgentNode metaMesh) {
        this.metaParts = metaMesh.demandMapLane().keyForm(Form.forValue()).valueForm(PartInfo.form()).observe((Object)new MeshTablePartsController(mesh));
        metaMesh.openLane(PARTS_URI, (Lane)this.metaParts);
        this.metaPulse = this.metaNode.demandLane().valueForm(MeshPulse.form()).observe((Object)new MeshTablePulseController(this));
        this.metaNode.openLane(MeshPulse.PULSE_URI, (Lane)this.metaPulse);
    }

    protected void openLogLanes(MeshBinding mesh, AgentNode metaMesh) {
        this.metaTraceLog = metaMesh.supplyLane().valueForm(LogEntry.form());
        metaMesh.openLane(LogEntry.TRACE_LOG_URI, (Lane)this.metaTraceLog);
        this.metaDebugLog = metaMesh.supplyLane().valueForm(LogEntry.form());
        metaMesh.openLane(LogEntry.DEBUG_LOG_URI, (Lane)this.metaDebugLog);
        this.metaInfoLog = metaMesh.supplyLane().valueForm(LogEntry.form());
        metaMesh.openLane(LogEntry.INFO_LOG_URI, (Lane)this.metaInfoLog);
        this.metaWarnLog = metaMesh.supplyLane().valueForm(LogEntry.form());
        metaMesh.openLane(LogEntry.WARN_LOG_URI, (Lane)this.metaWarnLog);
        this.metaErrorLog = metaMesh.supplyLane().valueForm(LogEntry.form());
        metaMesh.openLane(LogEntry.ERROR_LOG_URI, (Lane)this.metaErrorLog);
        this.metaFailLog = metaMesh.supplyLane().valueForm(LogEntry.form());
        metaMesh.openLane(LogEntry.FAIL_LOG_URI, (Lane)this.metaFailLog);
    }

    @Override
    public PartBinding gateway() {
        return this.gateway;
    }

    @Override
    public void setGateway(PartBinding gateway) {
        this.gateway = gateway;
    }

    @Override
    public PartBinding ourself() {
        return this.ourself;
    }

    @Override
    public void setOurself(PartBinding ourself) {
        this.ourself = ourself;
    }

    @Override
    public FingerTrieSeq<PartBinding> parts() {
        return this.parts;
    }

    boolean isMetaNode(Uri nodeUri) {
        return !this.meshUri().isDefined() && "swim".equals(nodeUri.schemeName());
    }

    @Override
    public PartBinding getPart(Uri nodeUri) {
        if (this.isMetaNode(nodeUri)) {
            return this.ourself;
        }
        FingerTrieSeq<PartBinding> parts = this.parts;
        int n = parts.size();
        for (int i = 0; i < n; ++i) {
            PartBinding part = (PartBinding)parts.get(i);
            if (!part.predicate().test(nodeUri)) continue;
            return part;
        }
        return this.gateway;
    }

    @Override
    public PartBinding getPart(Value partKey) {
        FingerTrieSeq<PartBinding> parts = this.parts;
        int n = parts.size();
        for (int i = 0; i < n; ++i) {
            PartBinding part = (PartBinding)parts.get(i);
            if (!partKey.equals((Object)part.partKey())) continue;
            return part;
        }
        return null;
    }

    @Override
    public PartBinding openPart(Uri nodeUri) {
        FingerTrieSeq newParts;
        FingerTrieSeq oldParts;
        TierBinding partBinding = null;
        Object partKey = Value.extant();
        do {
            oldParts = this.parts;
            PartBinding part = null;
            if (this.isMetaNode(nodeUri)) {
                part = this.ourself;
            } else {
                int n = oldParts.size();
                for (int i = 0; i < n; ++i) {
                    PartBinding oldPart = (PartBinding)oldParts.get(i);
                    if (!oldPart.predicate().test(nodeUri)) continue;
                    part = oldPart;
                    break;
                }
            }
            if (part != null) {
                if (partBinding != null) {
                    partBinding.close();
                }
                partBinding = part;
                newParts = oldParts;
                break;
            }
            if (partBinding == null) {
                partKey = this.isMetaNode(nodeUri) ? Text.from((String)"swim") : Value.extant();
                PartAddress partAddress = this.cellAddress().partKey((Value)partKey);
                partBinding = this.meshContext.createPart(partAddress);
                if (partBinding != null) {
                    partBinding = this.meshContext.injectPart(partAddress, (PartBinding)partBinding);
                    PartContext partContext = this.createPartContext(partAddress, (PartBinding)partBinding);
                    partBinding.setPartContext(partContext);
                    partBinding = partBinding.partWrapper();
                    newParts = oldParts.appended((Object)partBinding);
                    continue;
                }
                newParts = oldParts;
                break;
            }
            newParts = oldParts.appended((Object)partBinding);
        } while (oldParts != newParts && !PARTS.compareAndSet(this, (FingerTrieSeq<PartBinding>)oldParts, (FingerTrieSeq<PartBinding>)newParts));
        if (oldParts != newParts) {
            if (partKey instanceof Extant) {
                this.gateway = partBinding;
            } else if (this.isMetaNode(nodeUri)) {
                this.ourself = partBinding;
            }
            this.activate(partBinding);
            this.didOpenPart((PartBinding)partBinding);
        }
        return partBinding;
    }

    @Override
    public PartBinding openGateway() {
        FingerTrieSeq newParts;
        FingerTrieSeq oldParts;
        Value partKey = Value.extant();
        TierBinding partBinding = null;
        do {
            oldParts = this.parts;
            PartBinding part = this.gateway;
            if (part != null) {
                if (partBinding != null) {
                    partBinding.close();
                }
                partBinding = part;
                newParts = oldParts;
                break;
            }
            if (partBinding == null) {
                PartAddress partAddress = this.cellAddress().partKey(partKey);
                partBinding = this.meshContext.createPart(partAddress);
                if (partBinding != null) {
                    partBinding = this.meshContext.injectPart(partAddress, (PartBinding)partBinding);
                    PartContext partContext = this.createPartContext(partAddress, (PartBinding)partBinding);
                    partBinding.setPartContext(partContext);
                    partBinding = partBinding.partWrapper();
                    newParts = oldParts.appended((Object)partBinding);
                    continue;
                }
                newParts = oldParts;
                break;
            }
            newParts = oldParts.appended((Object)partBinding);
        } while (oldParts != newParts && !PARTS.compareAndSet(this, (FingerTrieSeq<PartBinding>)oldParts, (FingerTrieSeq<PartBinding>)newParts));
        if (oldParts != newParts) {
            this.gateway = partBinding;
            this.activate(partBinding);
            this.didOpenPart((PartBinding)partBinding);
        }
        return partBinding;
    }

    @Override
    public PartBinding addPart(Value partKey, PartBinding part) {
        FingerTrieSeq newParts;
        FingerTrieSeq<PartBinding> oldParts;
        PartBinding partBinding = null;
        do {
            PartBinding oldPart;
            oldParts = this.parts;
            int n = oldParts.size();
            for (int i = 0; i < n && !partKey.equals((Object)(oldPart = (PartBinding)oldParts.get(i)).partKey()); ++i) {
            }
            if (partBinding != null) continue;
            PartAddress partAddress = this.cellAddress().partKey(partKey);
            partBinding = this.meshContext.injectPart(partAddress, part);
            PartContext partContext = this.createPartContext(partAddress, partBinding);
            partBinding.setPartContext(partContext);
            partBinding = partBinding.partWrapper();
        } while (oldParts != (newParts = oldParts.appended(partBinding)) && !PARTS.compareAndSet(this, oldParts, (FingerTrieSeq<PartBinding>)newParts));
        if (partBinding != null) {
            this.activate(partBinding);
            this.didOpenPart(partBinding);
        }
        return partBinding;
    }

    public void closePart(Value partKey) {
        PartBinding partBinding;
        FingerTrieSeq newParts;
        FingerTrieSeq oldParts;
        block0: do {
            newParts = oldParts = this.parts;
            partBinding = null;
            int n = oldParts.size();
            for (int i = 0; i < n; ++i) {
                PartBinding part = (PartBinding)oldParts.get(i);
                if (!partKey.equals((Object)part.partKey())) continue;
                partBinding = part;
                newParts = oldParts.removed(i);
                continue block0;
            }
        } while (oldParts != newParts && !PARTS.compareAndSet(this, oldParts, newParts));
        if (partBinding != null) {
            if (this.gateway == partBinding) {
                this.gateway = null;
            } else if (this.ourself == partBinding) {
                this.ourself = null;
            }
            partBinding.didClose();
            this.didClosePart(partBinding);
            if (newParts.isEmpty()) {
                this.close();
            }
        }
    }

    protected void didOpenPart(PartBinding part) {
        DemandMapLane<Value, PartInfo> metaParts = this.metaParts;
        if (metaParts != null) {
            metaParts.cue((Object)part.partKey());
        }
        PART_OPEN_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void didClosePart(PartBinding part) {
        DemandMapLane<Value, PartInfo> metaParts = this.metaParts;
        if (metaParts != null) {
            metaParts.remove((Object)part.partKey());
        }
        PART_CLOSE_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    @Override
    public void openMetaPart(PartBinding part, NodeBinding metaPart) {
        this.meshContext.openMetaPart(part, metaPart);
    }

    @Override
    public void openMetaHost(HostBinding host, NodeBinding metaHost) {
        this.meshContext.openMetaHost(host, metaHost);
    }

    @Override
    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        this.meshContext.openMetaNode(node, metaNode);
    }

    @Override
    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        this.meshContext.openMetaLane(lane, metaLane);
    }

    @Override
    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.meshContext.openMetaUplink(uplink, metaUplink);
    }

    @Override
    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.meshContext.openMetaDownlink(downlink, metaDownlink);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        LinkBinding link = this.meshContext.bindDownlink(downlink);
        link.setCellContext(this);
        return link;
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.meshContext.openDownlink(link);
        link.setCellContext(this);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void openUplink(LinkBinding link) {
        PartBinding partBinding = this.openPart(link.nodeUri());
        if (partBinding != null) {
            partBinding = partBinding.bottomPart(PartBinding.class);
        }
        if (partBinding != null) {
            partBinding.openUplink(link);
        } else {
            UplinkError.rejectPartNotFound(link);
        }
    }

    @Override
    public void pushDown(Push<?> push) {
        this.meshContext.pushDown(push);
    }

    @Override
    public void pushUp(Push<?> push) {
        Uri nodeUri = push.nodeUri();
        PartBinding partBinding = this.openPart(nodeUri);
        if (partBinding != null) {
            partBinding = partBinding.bottomPart(PartBinding.class);
        }
        if (partBinding != null) {
            partBinding.pushUp(push);
        } else {
            push.trap(new MeshException("unknown part for node: " + nodeUri));
        }
    }

    public void trace(Object message) {
        SupplyLane<LogEntry> metaTraceLog = this.metaTraceLog;
        if (metaTraceLog != null) {
            metaTraceLog.push((Object)LogEntry.trace(message));
        }
        this.meshContext.trace(message);
    }

    public void debug(Object message) {
        SupplyLane<LogEntry> metaDebugLog = this.metaDebugLog;
        if (metaDebugLog != null) {
            metaDebugLog.push((Object)LogEntry.debug(message));
        }
        this.meshContext.debug(message);
    }

    public void info(Object message) {
        SupplyLane<LogEntry> metaInfoLog = this.metaInfoLog;
        if (metaInfoLog != null) {
            metaInfoLog.push((Object)LogEntry.info(message));
        }
        this.meshContext.info(message);
    }

    public void warn(Object message) {
        SupplyLane<LogEntry> metaWarnLog = this.metaWarnLog;
        if (metaWarnLog != null) {
            metaWarnLog.push((Object)LogEntry.warn(message));
        }
        this.meshContext.warn(message);
    }

    public void error(Object message) {
        SupplyLane<LogEntry> metaErrorLog = this.metaErrorLog;
        if (metaErrorLog != null) {
            metaErrorLog.push((Object)LogEntry.error(message));
        }
        this.meshContext.error(message);
    }

    public void fail(Object message) {
        SupplyLane<LogEntry> metaFailLog = this.metaFailLog;
        if (metaFailLog != null) {
            metaFailLog.push((Object)LogEntry.fail(message));
        }
        this.meshContext.fail(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
        super.didClose();
        AgentNode metaNode = this.metaNode;
        if (metaNode != null) {
            metaNode.close();
            this.metaNode = null;
            this.metaParts = null;
            this.metaTraceLog = null;
            this.metaDebugLog = null;
            this.metaInfoLog = null;
            this.metaWarnLog = null;
            this.metaErrorLog = null;
            this.metaFailLog = null;
        }
        this.flushMetrics();
    }

    @Override
    public void didFail(Throwable error) {
        if (Conts.isNonFatal((Throwable)error)) {
            this.fail(error);
        } else {
            error.printStackTrace();
        }
    }

    @Override
    public void reportDown(Metric metric) {
        if (metric instanceof PartProfile) {
            this.accumulatePartProfile((PartProfile)metric);
        } else if (metric instanceof WarpDownlinkProfile) {
            this.accumulateWarpDownlinkProfile((WarpDownlinkProfile)metric);
        } else {
            this.meshContext.reportDown(metric);
        }
    }

    protected void accumulatePartProfile(PartProfile profile) {
        HOST_OPEN_DELTA.addAndGet(this, profile.hostOpenDelta());
        HOST_CLOSE_DELTA.addAndGet(this, profile.hostCloseDelta());
        NODE_OPEN_DELTA.addAndGet(this, profile.nodeOpenDelta());
        NODE_CLOSE_DELTA.addAndGet(this, profile.nodeCloseDelta());
        AGENT_OPEN_DELTA.addAndGet(this, profile.agentOpenDelta());
        AGENT_CLOSE_DELTA.addAndGet(this, profile.agentCloseDelta());
        AGENT_EXEC_DELTA.addAndGet(this, profile.agentExecDelta());
        AGENT_EXEC_RATE.addAndGet(this, profile.agentExecRate());
        TIMER_EVENT_DELTA.addAndGet(this, profile.timerEventDelta());
        TIMER_EVENT_RATE.addAndGet(this, profile.timerEventRate());
        DOWNLINK_OPEN_DELTA.addAndGet(this, profile.downlinkOpenDelta());
        DOWNLINK_CLOSE_DELTA.addAndGet(this, profile.downlinkCloseDelta());
        DOWNLINK_EVENT_DELTA.addAndGet(this, profile.downlinkEventDelta());
        DOWNLINK_EVENT_RATE.addAndGet(this, profile.downlinkEventRate());
        DOWNLINK_COMMAND_DELTA.addAndGet(this, profile.downlinkCommandDelta());
        DOWNLINK_COMMAND_RATE.addAndGet(this, profile.downlinkCommandRate());
        UPLINK_OPEN_DELTA.addAndGet(this, profile.uplinkOpenDelta());
        UPLINK_CLOSE_DELTA.addAndGet(this, profile.uplinkCloseDelta());
        UPLINK_EVENT_DELTA.addAndGet(this, profile.uplinkEventDelta());
        UPLINK_EVENT_RATE.addAndGet(this, profile.uplinkEventRate());
        UPLINK_COMMAND_DELTA.addAndGet(this, profile.uplinkCommandDelta());
        UPLINK_COMMAND_RATE.addAndGet(this, profile.uplinkCommandRate());
        this.didUpdateMetrics();
    }

    protected void accumulateWarpDownlinkProfile(WarpDownlinkProfile profile) {
        DOWNLINK_OPEN_DELTA.addAndGet(this, profile.openDelta());
        DOWNLINK_CLOSE_DELTA.addAndGet(this, profile.closeDelta());
        DOWNLINK_EVENT_DELTA.addAndGet(this, profile.eventDelta());
        DOWNLINK_EVENT_RATE.addAndGet(this, profile.eventRate());
        DOWNLINK_COMMAND_DELTA.addAndGet(this, profile.commandDelta());
        DOWNLINK_COMMAND_RATE.addAndGet(this, profile.commandRate());
        this.didUpdateMetrics();
    }

    protected void didUpdateMetrics() {
        long oldReportTime;
        long newReportTime;
        long dt;
        while ((dt = (newReportTime = System.currentTimeMillis()) - (oldReportTime = this.lastReportTime)) >= 1000L) {
            if (!LAST_REPORT_TIME.compareAndSet(this, oldReportTime, newReportTime)) continue;
            try {
                this.reportMetrics(dt);
                break;
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break;
                }
                throw error;
            }
        }
    }

    protected void flushMetrics() {
        long newReportTime = System.currentTimeMillis();
        long oldReportTime = LAST_REPORT_TIME.getAndSet(this, newReportTime);
        long dt = newReportTime - oldReportTime;
        try {
            this.reportMetrics(dt);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void reportMetrics(long dt) {
        MeshProfile profile = this.collectProfile(dt);
        this.meshContext.reportDown(profile);
    }

    protected MeshProfile collectProfile(long dt) {
        int partOpenDelta = PART_OPEN_DELTA.getAndSet(this, 0);
        long partOpenCount = PART_OPEN_COUNT.addAndGet(this, partOpenDelta);
        int partCloseDelta = PART_CLOSE_DELTA.getAndSet(this, 0);
        long partCloseCount = PART_CLOSE_COUNT.addAndGet(this, partCloseDelta);
        int hostOpenDelta = HOST_OPEN_DELTA.getAndSet(this, 0);
        long hostOpenCount = HOST_OPEN_COUNT.addAndGet(this, hostOpenDelta);
        int hostCloseDelta = HOST_CLOSE_DELTA.getAndSet(this, 0);
        long hostCloseCount = HOST_CLOSE_COUNT.addAndGet(this, hostCloseDelta);
        int nodeOpenDelta = NODE_OPEN_DELTA.getAndSet(this, 0);
        long nodeOpenCount = NODE_OPEN_COUNT.addAndGet(this, nodeOpenDelta);
        int nodeCloseDelta = NODE_CLOSE_DELTA.getAndSet(this, 0);
        long nodeCloseCount = NODE_CLOSE_COUNT.addAndGet(this, nodeCloseDelta);
        int agentOpenDelta = AGENT_OPEN_DELTA.getAndSet(this, 0);
        long agentOpenCount = AGENT_OPEN_COUNT.addAndGet(this, agentOpenDelta);
        int agentCloseDelta = AGENT_CLOSE_DELTA.getAndSet(this, 0);
        long agentCloseCount = AGENT_CLOSE_COUNT.addAndGet(this, agentCloseDelta);
        long agentExecDelta = AGENT_EXEC_DELTA.getAndSet(this, 0L);
        long agentExecRate = AGENT_EXEC_RATE.getAndSet(this, 0L);
        long agentExecTime = AGENT_EXEC_TIME.addAndGet(this, agentExecDelta);
        int timerEventDelta = TIMER_EVENT_DELTA.getAndSet(this, 0);
        int timerEventRate = TIMER_EVENT_RATE.getAndSet(this, 0);
        long timerEventCount = TIMER_EVENT_COUNT.addAndGet(this, timerEventDelta);
        int downlinkOpenDelta = DOWNLINK_OPEN_DELTA.getAndSet(this, 0);
        long downlinkOpenCount = DOWNLINK_OPEN_COUNT.addAndGet(this, downlinkOpenDelta);
        int downlinkCloseDelta = DOWNLINK_CLOSE_DELTA.getAndSet(this, 0);
        long downlinkCloseCount = DOWNLINK_CLOSE_COUNT.addAndGet(this, downlinkCloseDelta);
        int downlinkEventDelta = DOWNLINK_EVENT_DELTA.getAndSet(this, 0);
        int downlinkEventRate = DOWNLINK_EVENT_RATE.getAndSet(this, 0);
        long downlinkEventCount = DOWNLINK_EVENT_COUNT.addAndGet(this, downlinkEventDelta);
        int downlinkCommandDelta = DOWNLINK_COMMAND_DELTA.getAndSet(this, 0);
        int downlinkCommandRate = DOWNLINK_COMMAND_RATE.getAndSet(this, 0);
        long downlinkCommandCount = DOWNLINK_COMMAND_COUNT.addAndGet(this, downlinkCommandDelta);
        int uplinkOpenDelta = UPLINK_OPEN_DELTA.getAndSet(this, 0);
        long uplinkOpenCount = UPLINK_OPEN_COUNT.addAndGet(this, uplinkOpenDelta);
        int uplinkCloseDelta = UPLINK_CLOSE_DELTA.getAndSet(this, 0);
        long uplinkCloseCount = UPLINK_CLOSE_COUNT.addAndGet(this, uplinkCloseDelta);
        int uplinkEventDelta = UPLINK_EVENT_DELTA.getAndSet(this, 0);
        int uplinkEventRate = UPLINK_EVENT_RATE.getAndSet(this, 0);
        long uplinkEventCount = UPLINK_EVENT_COUNT.addAndGet(this, uplinkEventDelta);
        int uplinkCommandDelta = UPLINK_COMMAND_DELTA.getAndSet(this, 0);
        int uplinkCommandRate = UPLINK_COMMAND_RATE.getAndSet(this, 0);
        long uplinkCommandCount = UPLINK_COMMAND_COUNT.addAndGet(this, uplinkCommandDelta);
        int partCount = (int)(partOpenCount - partCloseCount);
        int hostCount = (int)(hostOpenCount - hostCloseCount);
        long nodeCount = nodeOpenCount - nodeCloseCount;
        long agentCount = agentOpenCount - agentCloseCount;
        AgentPulse agentPulse = new AgentPulse(agentCount, agentExecRate, agentExecTime, timerEventRate, timerEventCount);
        long downlinkCount = downlinkOpenCount - downlinkCloseCount;
        WarpDownlinkPulse downlinkPulse = new WarpDownlinkPulse(downlinkCount, downlinkEventRate, downlinkEventCount, downlinkCommandRate, downlinkCommandCount);
        long uplinkCount = uplinkOpenCount - uplinkCloseCount;
        WarpUplinkPulse uplinkPulse = new WarpUplinkPulse(uplinkCount, uplinkEventRate, uplinkEventCount, uplinkCommandRate, uplinkCommandCount);
        this.pulse = new MeshPulse(partCount, hostCount, nodeCount, agentPulse, downlinkPulse, uplinkPulse);
        DemandLane<MeshPulse> metaPulse = this.metaPulse;
        if (metaPulse != null) {
            metaPulse.cue();
        }
        return new MeshProfile(this.cellAddress(), partOpenDelta, partOpenCount, partCloseDelta, partCloseCount, hostOpenDelta, hostOpenCount, hostCloseDelta, hostCloseCount, nodeOpenDelta, nodeOpenCount, nodeCloseDelta, nodeCloseCount, agentOpenDelta, agentOpenCount, agentCloseDelta, agentCloseCount, agentExecDelta, agentExecRate, agentExecTime, timerEventDelta, timerEventRate, timerEventCount, downlinkOpenDelta, downlinkOpenCount, downlinkCloseDelta, downlinkCloseCount, downlinkEventDelta, downlinkEventRate, downlinkEventCount, downlinkCommandDelta, downlinkCommandRate, downlinkCommandCount, uplinkOpenDelta, uplinkOpenCount, uplinkCloseDelta, uplinkCloseCount, uplinkEventDelta, uplinkEventRate, uplinkEventCount, uplinkCommandDelta, uplinkCommandRate, uplinkCommandCount);
    }
}

