/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.Lane;
import swim.api.lane.DemandLane;
import swim.api.lane.DemandMapLane;
import swim.api.lane.SupplyLane;
import swim.api.policy.Policy;
import swim.collections.HashTrieMap;
import swim.concurrent.Conts;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HostAddress;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.HttpBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LinkBinding;
import swim.runtime.MeshBinding;
import swim.runtime.Metric;
import swim.runtime.NodeBinding;
import swim.runtime.PartAddress;
import swim.runtime.PartBinding;
import swim.runtime.PartContext;
import swim.runtime.PartException;
import swim.runtime.PartPredicate;
import swim.runtime.Push;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.UplinkError;
import swim.runtime.WarpBinding;
import swim.runtime.agent.AgentNode;
import swim.runtime.profile.HostProfile;
import swim.runtime.profile.PartProfile;
import swim.runtime.profile.WarpDownlinkProfile;
import swim.runtime.reflect.AgentPulse;
import swim.runtime.reflect.HostInfo;
import swim.runtime.reflect.LogEntry;
import swim.runtime.reflect.PartPulse;
import swim.runtime.reflect.WarpDownlinkPulse;
import swim.runtime.reflect.WarpUplinkPulse;
import swim.runtime.router.PartTableHost;
import swim.runtime.router.PartTableHostsController;
import swim.runtime.router.PartTableHttpUplink;
import swim.runtime.router.PartTablePulseController;
import swim.runtime.router.PartTableWarpUplink;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class PartTable
extends AbstractTierBinding
implements PartBinding {
    final PartPredicate predicate;
    protected PartContext partContext;
    volatile HashTrieMap<Uri, HostBinding> hosts = HashTrieMap.empty();
    volatile HashTrieMap<Value, LinkBinding> uplinks = HashTrieMap.empty();
    volatile HostBinding master;
    volatile int hostOpenDelta;
    volatile long hostOpenCount;
    volatile int hostCloseDelta;
    volatile long hostCloseCount;
    volatile int nodeOpenDelta;
    volatile long nodeOpenCount;
    volatile int nodeCloseDelta;
    volatile long nodeCloseCount;
    volatile int agentOpenDelta;
    volatile long agentOpenCount;
    volatile int agentCloseDelta;
    volatile long agentCloseCount;
    volatile long agentExecDelta;
    volatile long agentExecRate;
    volatile long agentExecTime;
    volatile int timerEventDelta;
    volatile int timerEventRate;
    volatile long timerEventCount;
    volatile int downlinkOpenDelta;
    volatile long downlinkOpenCount;
    volatile int downlinkCloseDelta;
    volatile long downlinkCloseCount;
    volatile int downlinkEventDelta;
    volatile int downlinkEventRate;
    volatile long downlinkEventCount;
    volatile int downlinkCommandDelta;
    volatile int downlinkCommandRate;
    volatile long downlinkCommandCount;
    volatile int uplinkOpenDelta;
    volatile long uplinkOpenCount;
    volatile int uplinkCloseDelta;
    volatile long uplinkCloseCount;
    volatile int uplinkEventDelta;
    volatile int uplinkEventRate;
    volatile long uplinkEventCount;
    volatile int uplinkCommandDelta;
    volatile int uplinkCommandRate;
    volatile long uplinkCommandCount;
    volatile long lastReportTime;
    PartPulse pulse;
    AgentNode metaNode;
    DemandMapLane<Uri, HostInfo> metaHosts;
    DemandLane<PartPulse> metaPulse;
    SupplyLane<LogEntry> metaTraceLog;
    SupplyLane<LogEntry> metaDebugLog;
    SupplyLane<LogEntry> metaInfoLog;
    SupplyLane<LogEntry> metaWarnLog;
    SupplyLane<LogEntry> metaErrorLog;
    SupplyLane<LogEntry> metaFailLog;
    static final Uri HOSTS_URI = Uri.parse((String)"hosts");
    static final AtomicReferenceFieldUpdater<PartTable, HashTrieMap<Uri, HostBinding>> HOSTS = AtomicReferenceFieldUpdater.newUpdater(PartTable.class, HashTrieMap.class, "hosts");
    static final AtomicReferenceFieldUpdater<PartTable, HashTrieMap<Value, LinkBinding>> UPLINKS = AtomicReferenceFieldUpdater.newUpdater(PartTable.class, HashTrieMap.class, "uplinks");
    static final AtomicIntegerFieldUpdater<PartTable> HOST_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "hostOpenDelta");
    static final AtomicLongFieldUpdater<PartTable> HOST_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "hostOpenCount");
    static final AtomicIntegerFieldUpdater<PartTable> HOST_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "hostCloseDelta");
    static final AtomicLongFieldUpdater<PartTable> HOST_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "hostCloseCount");
    static final AtomicIntegerFieldUpdater<PartTable> NODE_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "nodeOpenDelta");
    static final AtomicLongFieldUpdater<PartTable> NODE_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "nodeOpenCount");
    static final AtomicIntegerFieldUpdater<PartTable> NODE_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "nodeCloseDelta");
    static final AtomicLongFieldUpdater<PartTable> NODE_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "nodeCloseCount");
    static final AtomicIntegerFieldUpdater<PartTable> AGENT_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "agentOpenDelta");
    static final AtomicLongFieldUpdater<PartTable> AGENT_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "agentOpenCount");
    static final AtomicIntegerFieldUpdater<PartTable> AGENT_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "agentCloseDelta");
    static final AtomicLongFieldUpdater<PartTable> AGENT_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "agentCloseCount");
    static final AtomicLongFieldUpdater<PartTable> AGENT_EXEC_DELTA = AtomicLongFieldUpdater.newUpdater(PartTable.class, "agentExecDelta");
    static final AtomicLongFieldUpdater<PartTable> AGENT_EXEC_RATE = AtomicLongFieldUpdater.newUpdater(PartTable.class, "agentExecRate");
    static final AtomicLongFieldUpdater<PartTable> AGENT_EXEC_TIME = AtomicLongFieldUpdater.newUpdater(PartTable.class, "agentExecTime");
    static final AtomicIntegerFieldUpdater<PartTable> TIMER_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "timerEventDelta");
    static final AtomicIntegerFieldUpdater<PartTable> TIMER_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "timerEventRate");
    static final AtomicLongFieldUpdater<PartTable> TIMER_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "timerEventCount");
    static final AtomicIntegerFieldUpdater<PartTable> DOWNLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "downlinkOpenDelta");
    static final AtomicLongFieldUpdater<PartTable> DOWNLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "downlinkOpenCount");
    static final AtomicIntegerFieldUpdater<PartTable> DOWNLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "downlinkCloseDelta");
    static final AtomicLongFieldUpdater<PartTable> DOWNLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "downlinkCloseCount");
    static final AtomicIntegerFieldUpdater<PartTable> DOWNLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "downlinkEventDelta");
    static final AtomicIntegerFieldUpdater<PartTable> DOWNLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "downlinkEventRate");
    static final AtomicLongFieldUpdater<PartTable> DOWNLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "downlinkEventCount");
    static final AtomicIntegerFieldUpdater<PartTable> DOWNLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "downlinkCommandDelta");
    static final AtomicIntegerFieldUpdater<PartTable> DOWNLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "downlinkCommandRate");
    static final AtomicLongFieldUpdater<PartTable> DOWNLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "downlinkCommandCount");
    static final AtomicIntegerFieldUpdater<PartTable> UPLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "uplinkOpenDelta");
    static final AtomicLongFieldUpdater<PartTable> UPLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "uplinkOpenCount");
    static final AtomicIntegerFieldUpdater<PartTable> UPLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "uplinkCloseDelta");
    static final AtomicLongFieldUpdater<PartTable> UPLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "uplinkCloseCount");
    static final AtomicIntegerFieldUpdater<PartTable> UPLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "uplinkEventDelta");
    static final AtomicIntegerFieldUpdater<PartTable> UPLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "uplinkEventRate");
    static final AtomicLongFieldUpdater<PartTable> UPLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "uplinkEventCount");
    static final AtomicIntegerFieldUpdater<PartTable> UPLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "uplinkCommandDelta");
    static final AtomicIntegerFieldUpdater<PartTable> UPLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(PartTable.class, "uplinkCommandRate");
    static final AtomicLongFieldUpdater<PartTable> UPLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(PartTable.class, "uplinkCommandCount");
    static final AtomicLongFieldUpdater<PartTable> LAST_REPORT_TIME = AtomicLongFieldUpdater.newUpdater(PartTable.class, "lastReportTime");

    public PartTable(PartPredicate predicate) {
        this.predicate = predicate;
    }

    public PartTable() {
        this(PartPredicate.any());
    }

    @Override
    public final TierContext tierContext() {
        return this.partContext;
    }

    @Override
    public final MeshBinding mesh() {
        return this.partContext.mesh();
    }

    @Override
    public final PartBinding partWrapper() {
        return this;
    }

    @Override
    public final PartContext partContext() {
        return this.partContext;
    }

    @Override
    public void setPartContext(PartContext partContext) {
        this.partContext = partContext;
    }

    @Override
    public <T> T unwrapPart(Class<T> partClass) {
        if (partClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.partContext.unwrapPart(partClass);
    }

    @Override
    public <T> T bottomPart(Class<T> partClass) {
        Object part = this.partContext.bottomPart(partClass);
        if (part == null && partClass.isAssignableFrom(this.getClass())) {
            part = this;
        }
        return part;
    }

    protected HostContext createHostContext(HostAddress hostAddress, HostBinding host) {
        return new PartTableHost(this, host, hostAddress);
    }

    @Override
    public final PartAddress cellAddress() {
        return this.partContext.cellAddress();
    }

    @Override
    public final String edgeName() {
        return this.partContext.edgeName();
    }

    @Override
    public final Uri meshUri() {
        return this.partContext.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.partContext.partKey();
    }

    @Override
    public Policy policy() {
        return this.partContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.partContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.partContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.partContext.store();
    }

    @Override
    public PartPredicate predicate() {
        return this.predicate;
    }

    @Override
    public void openMetaPart(PartBinding part, NodeBinding metaPart) {
        if (metaPart instanceof AgentNode) {
            this.metaNode = (AgentNode)metaPart;
            this.openMetaLanes(part, (AgentNode)metaPart);
        }
        this.partContext.openMetaPart(part, metaPart);
    }

    protected void openMetaLanes(PartBinding part, AgentNode metaPart) {
        this.openReflectLanes(part, metaPart);
        this.openLogLanes(part, metaPart);
    }

    protected void openReflectLanes(PartBinding part, AgentNode metaPart) {
        this.metaHosts = metaPart.demandMapLane().keyForm(Uri.form()).valueForm(HostInfo.form()).observe((Object)new PartTableHostsController(part));
        metaPart.openLane(HOSTS_URI, (Lane)this.metaHosts);
        this.metaPulse = this.metaNode.demandLane().valueForm(PartPulse.form()).observe((Object)new PartTablePulseController(this));
        this.metaNode.openLane(PartPulse.PULSE_URI, (Lane)this.metaPulse);
    }

    protected void openLogLanes(PartBinding part, AgentNode metaPart) {
        this.metaTraceLog = metaPart.supplyLane().valueForm(LogEntry.form());
        metaPart.openLane(LogEntry.TRACE_LOG_URI, (Lane)this.metaTraceLog);
        this.metaDebugLog = metaPart.supplyLane().valueForm(LogEntry.form());
        metaPart.openLane(LogEntry.DEBUG_LOG_URI, (Lane)this.metaDebugLog);
        this.metaInfoLog = metaPart.supplyLane().valueForm(LogEntry.form());
        metaPart.openLane(LogEntry.INFO_LOG_URI, (Lane)this.metaInfoLog);
        this.metaWarnLog = metaPart.supplyLane().valueForm(LogEntry.form());
        metaPart.openLane(LogEntry.WARN_LOG_URI, (Lane)this.metaWarnLog);
        this.metaErrorLog = metaPart.supplyLane().valueForm(LogEntry.form());
        metaPart.openLane(LogEntry.ERROR_LOG_URI, (Lane)this.metaErrorLog);
        this.metaFailLog = metaPart.supplyLane().valueForm(LogEntry.form());
        metaPart.openLane(LogEntry.FAIL_LOG_URI, (Lane)this.metaFailLog);
    }

    @Override
    public HostBinding master() {
        return this.master;
    }

    @Override
    public void setMaster(HostBinding master) {
        this.master = master;
    }

    @Override
    public HashTrieMap<Uri, HostBinding> hosts() {
        return this.hosts;
    }

    @Override
    public HostBinding getHost(Uri hostUri) {
        return (HostBinding)this.hosts.get((Object)hostUri);
    }

    @Override
    public HostBinding openHost(Uri hostUri) {
        HashTrieMap newHosts;
        HashTrieMap oldHosts;
        TierBinding hostBinding = null;
        do {
            HostBinding host;
            if ((host = (HostBinding)(oldHosts = this.hosts).get((Object)hostUri)) != null) {
                if (hostBinding != null) {
                    hostBinding.close();
                }
                hostBinding = host;
                newHosts = oldHosts;
                break;
            }
            if (hostBinding == null) {
                HostAddress hostAddress = this.cellAddress().hostUri(hostUri);
                hostBinding = this.partContext.createHost(hostAddress);
                if (hostBinding != null) {
                    hostBinding = this.partContext.injectHost(hostAddress, (HostBinding)hostBinding);
                    HostContext hostContext = this.createHostContext(hostAddress, (HostBinding)hostBinding);
                    hostBinding.setHostContext(hostContext);
                    hostBinding = hostBinding.hostWrapper();
                    newHosts = oldHosts.updated((Object)hostUri, (Object)hostBinding);
                    continue;
                }
                newHosts = oldHosts;
                break;
            }
            newHosts = oldHosts.updated((Object)hostUri, (Object)hostBinding);
        } while (oldHosts != newHosts && !HOSTS.compareAndSet(this, (HashTrieMap<Uri, HostBinding>)oldHosts, (HashTrieMap<Uri, HostBinding>)newHosts));
        if (oldHosts != newHosts) {
            this.activate(hostBinding);
            this.didOpenHost((HostBinding)hostBinding);
        }
        return hostBinding;
    }

    @Override
    public HostBinding openHost(Uri hostUri, HostBinding host) {
        HashTrieMap newHosts;
        HashTrieMap oldHosts;
        HostBinding hostBinding = null;
        do {
            if ((oldHosts = this.hosts).containsKey((Object)hostUri) && host.hostContext() != null) {
                hostBinding = null;
                newHosts = oldHosts;
                break;
            }
            if (hostBinding != null) continue;
            HostAddress hostAddress = this.cellAddress().hostUri(hostUri);
            hostBinding = this.partContext.injectHost(hostAddress, host);
            HostContext hostContext = this.createHostContext(hostAddress, hostBinding);
            hostBinding.setHostContext(hostContext);
            hostBinding = hostBinding.hostWrapper();
        } while (oldHosts != (newHosts = oldHosts.updated((Object)hostUri, hostBinding)) && !HOSTS.compareAndSet(this, (HashTrieMap<Uri, HostBinding>)oldHosts, (HashTrieMap<Uri, HostBinding>)newHosts));
        if (hostBinding != null) {
            this.activate(hostBinding);
            this.didOpenHost(hostBinding);
        }
        return hostBinding;
    }

    public void closeHost(Uri hostUri) {
        HashTrieMap newHosts;
        HashTrieMap oldHosts;
        HostBinding hostBinding = null;
        do {
            HostBinding host;
            if ((host = (HostBinding)(oldHosts = this.hosts).get((Object)hostUri)) == null) {
                hostBinding = null;
                newHosts = oldHosts;
                break;
            }
            hostBinding = host;
            newHosts = oldHosts.removed((Object)hostUri);
        } while (oldHosts != newHosts && !HOSTS.compareAndSet(this, (HashTrieMap<Uri, HostBinding>)oldHosts, (HashTrieMap<Uri, HostBinding>)newHosts));
        if (hostBinding != null) {
            if (this.master == hostBinding) {
                this.master = null;
            }
            hostBinding.didClose();
            this.didCloseHost(hostBinding);
            if (newHosts.isEmpty()) {
                this.close();
            }
        }
    }

    protected void didOpenHost(HostBinding host) {
        DemandMapLane<Uri, HostInfo> metaHosts = this.metaHosts;
        if (metaHosts != null) {
            metaHosts.cue((Object)host.hostUri());
        }
        HOST_OPEN_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void didCloseHost(HostBinding host) {
        DemandMapLane<Uri, HostInfo> metaHosts = this.metaHosts;
        if (metaHosts != null) {
            metaHosts.remove((Object)host.hostUri());
        }
        HOST_CLOSE_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    public void hostDidConnect(Uri hostUri) {
        this.partContext.hostDidConnect(hostUri);
    }

    public void hostDidDisconnect(Uri hostUri) {
        this.partContext.hostDidDisconnect(hostUri);
    }

    @Override
    public void reopenUplinks() {
        for (LinkBinding uplink : this.uplinks.values()) {
            uplink.reopen();
        }
    }

    @Override
    public void openMetaHost(HostBinding host, NodeBinding metaHost) {
        this.partContext.openMetaHost(host, metaHost);
    }

    @Override
    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        this.partContext.openMetaNode(node, metaNode);
    }

    @Override
    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        this.partContext.openMetaLane(lane, metaLane);
    }

    @Override
    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.partContext.openMetaUplink(uplink, metaUplink);
    }

    @Override
    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.partContext.openMetaDownlink(downlink, metaDownlink);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        LinkBinding link = this.partContext.bindDownlink(downlink);
        link.setCellContext(this);
        return link;
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.partContext.openDownlink(link);
        link.setCellContext(this);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void openUplink(LinkBinding link) {
        Uri hostUri = link.hostUri();
        HostBinding hostBinding = null;
        if (!hostUri.isDefined() || hostUri.equals((Object)link.meshUri())) {
            hostBinding = this.master;
        }
        if (hostBinding == null) {
            hostBinding = this.openHost(hostUri);
        }
        if (hostBinding != null) {
            hostBinding = hostBinding.bottomHost(HostBinding.class);
        }
        if (hostBinding != null) {
            if (link instanceof WarpBinding) {
                hostBinding.openUplink(new PartTableWarpUplink(this, (WarpBinding)link));
            } else if (link instanceof HttpBinding) {
                hostBinding.openUplink(new PartTableHttpUplink(this, (HttpBinding)link));
            } else {
                UplinkError.rejectUnsupported(link);
            }
        } else {
            UplinkError.rejectHostNotFound(link);
        }
    }

    void didOpenUplink(LinkBinding uplink) {
        HashTrieMap newUplinks;
        HashTrieMap<Value, LinkBinding> oldUplinks;
        while ((oldUplinks = this.uplinks) != (newUplinks = oldUplinks.updated((Object)uplink.linkKey(), (Object)uplink)) && !UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Value, LinkBinding>)newUplinks)) {
        }
    }

    void didCloseUplink(LinkBinding uplink) {
        HashTrieMap newUplinks;
        HashTrieMap<Value, LinkBinding> oldUplinks;
        while ((oldUplinks = this.uplinks) != (newUplinks = oldUplinks.removed((Object)uplink.linkKey())) && !UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Value, LinkBinding>)newUplinks)) {
        }
    }

    @Override
    public void pushDown(Push<?> push) {
        this.partContext.pushDown(push);
    }

    @Override
    public void pushUp(Push<?> push) {
        Uri hostUri = push.hostUri();
        HostBinding hostBinding = null;
        if (!hostUri.isDefined() || hostUri.equals((Object)push.meshUri())) {
            hostBinding = this.master;
        }
        if (hostBinding == null) {
            hostBinding = this.openHost(hostUri);
        }
        if (hostBinding != null) {
            hostBinding = hostBinding.bottomHost(HostBinding.class);
        }
        if (hostBinding != null) {
            hostBinding.pushUp(push);
        } else {
            push.trap(new PartException("unknown host: " + hostUri));
        }
    }

    public void trace(Object message) {
        SupplyLane<LogEntry> metaTraceLog = this.metaTraceLog;
        if (metaTraceLog != null) {
            metaTraceLog.push((Object)LogEntry.trace(message));
        }
        this.partContext.trace(message);
    }

    public void debug(Object message) {
        SupplyLane<LogEntry> metaDebugLog = this.metaDebugLog;
        if (metaDebugLog != null) {
            metaDebugLog.push((Object)LogEntry.debug(message));
        }
        this.partContext.debug(message);
    }

    public void info(Object message) {
        SupplyLane<LogEntry> metaInfoLog = this.metaInfoLog;
        if (metaInfoLog != null) {
            metaInfoLog.push((Object)LogEntry.info(message));
        }
        this.partContext.info(message);
    }

    public void warn(Object message) {
        SupplyLane<LogEntry> metaWarnLog = this.metaWarnLog;
        if (metaWarnLog != null) {
            metaWarnLog.push((Object)LogEntry.warn(message));
        }
        this.partContext.warn(message);
    }

    public void error(Object message) {
        SupplyLane<LogEntry> metaErrorLog = this.metaErrorLog;
        if (metaErrorLog != null) {
            metaErrorLog.push((Object)LogEntry.error(message));
        }
        this.partContext.error(message);
    }

    public void fail(Object message) {
        SupplyLane<LogEntry> metaFailLog = this.metaFailLog;
        if (metaFailLog != null) {
            metaFailLog.push((Object)LogEntry.fail(message));
        }
        this.partContext.fail(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
        super.didClose();
        AgentNode metaNode = this.metaNode;
        if (metaNode != null) {
            metaNode.close();
            this.metaNode = null;
            this.metaHosts = null;
            this.metaTraceLog = null;
            this.metaDebugLog = null;
            this.metaInfoLog = null;
            this.metaWarnLog = null;
            this.metaErrorLog = null;
            this.metaFailLog = null;
        }
        this.flushMetrics();
    }

    @Override
    public void didFail(Throwable error) {
        if (Conts.isNonFatal((Throwable)error)) {
            this.fail(error);
        } else {
            error.printStackTrace();
        }
    }

    @Override
    public void reportDown(Metric metric) {
        if (metric instanceof HostProfile) {
            this.accumulateHostProfile((HostProfile)metric);
        } else if (metric instanceof WarpDownlinkProfile) {
            this.accumulateWarpDownlinkProfile((WarpDownlinkProfile)metric);
        } else {
            this.partContext.reportDown(metric);
        }
    }

    protected void accumulateHostProfile(HostProfile profile) {
        NODE_OPEN_DELTA.addAndGet(this, profile.nodeOpenDelta());
        NODE_CLOSE_DELTA.addAndGet(this, profile.nodeCloseDelta());
        AGENT_OPEN_DELTA.addAndGet(this, profile.agentOpenDelta());
        AGENT_CLOSE_DELTA.addAndGet(this, profile.agentCloseDelta());
        AGENT_EXEC_DELTA.addAndGet(this, profile.agentExecDelta());
        AGENT_EXEC_RATE.addAndGet(this, profile.agentExecRate());
        TIMER_EVENT_DELTA.addAndGet(this, profile.timerEventDelta());
        TIMER_EVENT_RATE.addAndGet(this, profile.timerEventRate());
        DOWNLINK_OPEN_DELTA.addAndGet(this, profile.downlinkOpenDelta());
        DOWNLINK_CLOSE_DELTA.addAndGet(this, profile.downlinkCloseDelta());
        DOWNLINK_EVENT_DELTA.addAndGet(this, profile.downlinkEventDelta());
        DOWNLINK_EVENT_RATE.addAndGet(this, profile.downlinkEventRate());
        DOWNLINK_COMMAND_DELTA.addAndGet(this, profile.downlinkCommandDelta());
        DOWNLINK_COMMAND_RATE.addAndGet(this, profile.downlinkCommandRate());
        UPLINK_OPEN_DELTA.addAndGet(this, profile.uplinkOpenDelta());
        UPLINK_CLOSE_DELTA.addAndGet(this, profile.uplinkCloseDelta());
        UPLINK_EVENT_DELTA.addAndGet(this, profile.uplinkEventDelta());
        UPLINK_EVENT_RATE.addAndGet(this, profile.uplinkEventRate());
        UPLINK_COMMAND_DELTA.addAndGet(this, profile.uplinkCommandDelta());
        UPLINK_COMMAND_RATE.addAndGet(this, profile.uplinkCommandRate());
        this.didUpdateMetrics();
    }

    protected void accumulateWarpDownlinkProfile(WarpDownlinkProfile profile) {
        DOWNLINK_OPEN_DELTA.addAndGet(this, profile.openDelta());
        DOWNLINK_CLOSE_DELTA.addAndGet(this, profile.closeDelta());
        DOWNLINK_EVENT_DELTA.addAndGet(this, profile.eventDelta());
        DOWNLINK_EVENT_RATE.addAndGet(this, profile.eventRate());
        DOWNLINK_COMMAND_DELTA.addAndGet(this, profile.commandDelta());
        DOWNLINK_COMMAND_RATE.addAndGet(this, profile.commandRate());
        this.didUpdateMetrics();
    }

    protected void didUpdateMetrics() {
        long oldReportTime;
        long newReportTime;
        long dt;
        while ((dt = (newReportTime = System.currentTimeMillis()) - (oldReportTime = this.lastReportTime)) >= 1000L) {
            if (!LAST_REPORT_TIME.compareAndSet(this, oldReportTime, newReportTime)) continue;
            try {
                this.reportMetrics(dt);
                break;
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break;
                }
                throw error;
            }
        }
    }

    protected void flushMetrics() {
        long newReportTime = System.currentTimeMillis();
        long oldReportTime = LAST_REPORT_TIME.getAndSet(this, newReportTime);
        long dt = newReportTime - oldReportTime;
        try {
            this.reportMetrics(dt);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void reportMetrics(long dt) {
        PartProfile profile = this.collectProfile(dt);
        this.partContext.reportDown(profile);
    }

    protected PartProfile collectProfile(long dt) {
        int hostOpenDelta = HOST_OPEN_DELTA.getAndSet(this, 0);
        long hostOpenCount = HOST_OPEN_COUNT.addAndGet(this, hostOpenDelta);
        int hostCloseDelta = HOST_CLOSE_DELTA.getAndSet(this, 0);
        long hostCloseCount = HOST_CLOSE_COUNT.addAndGet(this, hostCloseDelta);
        int nodeOpenDelta = NODE_OPEN_DELTA.getAndSet(this, 0);
        long nodeOpenCount = NODE_OPEN_COUNT.addAndGet(this, nodeOpenDelta);
        int nodeCloseDelta = NODE_CLOSE_DELTA.getAndSet(this, 0);
        long nodeCloseCount = NODE_CLOSE_COUNT.addAndGet(this, nodeCloseDelta);
        int agentOpenDelta = AGENT_OPEN_DELTA.getAndSet(this, 0);
        long agentOpenCount = AGENT_OPEN_COUNT.addAndGet(this, agentOpenDelta);
        int agentCloseDelta = AGENT_CLOSE_DELTA.getAndSet(this, 0);
        long agentCloseCount = AGENT_CLOSE_COUNT.addAndGet(this, agentCloseDelta);
        long agentExecDelta = AGENT_EXEC_DELTA.getAndSet(this, 0L);
        long agentExecRate = AGENT_EXEC_RATE.getAndSet(this, 0L);
        long agentExecTime = AGENT_EXEC_TIME.addAndGet(this, agentExecDelta);
        int timerEventDelta = TIMER_EVENT_DELTA.getAndSet(this, 0);
        int timerEventRate = TIMER_EVENT_RATE.getAndSet(this, 0);
        long timerEventCount = TIMER_EVENT_COUNT.addAndGet(this, timerEventDelta);
        int downlinkOpenDelta = DOWNLINK_OPEN_DELTA.getAndSet(this, 0);
        long downlinkOpenCount = DOWNLINK_OPEN_COUNT.addAndGet(this, downlinkOpenDelta);
        int downlinkCloseDelta = DOWNLINK_CLOSE_DELTA.getAndSet(this, 0);
        long downlinkCloseCount = DOWNLINK_CLOSE_COUNT.addAndGet(this, downlinkCloseDelta);
        int downlinkEventDelta = DOWNLINK_EVENT_DELTA.getAndSet(this, 0);
        int downlinkEventRate = DOWNLINK_EVENT_RATE.getAndSet(this, 0);
        long downlinkEventCount = DOWNLINK_EVENT_COUNT.addAndGet(this, downlinkEventDelta);
        int downlinkCommandDelta = DOWNLINK_COMMAND_DELTA.getAndSet(this, 0);
        int downlinkCommandRate = DOWNLINK_COMMAND_RATE.getAndSet(this, 0);
        long downlinkCommandCount = DOWNLINK_COMMAND_COUNT.addAndGet(this, downlinkCommandDelta);
        int uplinkOpenDelta = UPLINK_OPEN_DELTA.getAndSet(this, 0);
        long uplinkOpenCount = UPLINK_OPEN_COUNT.addAndGet(this, uplinkOpenDelta);
        int uplinkCloseDelta = UPLINK_CLOSE_DELTA.getAndSet(this, 0);
        long uplinkCloseCount = UPLINK_CLOSE_COUNT.addAndGet(this, uplinkCloseDelta);
        int uplinkEventDelta = UPLINK_EVENT_DELTA.getAndSet(this, 0);
        int uplinkEventRate = UPLINK_EVENT_RATE.getAndSet(this, 0);
        long uplinkEventCount = UPLINK_EVENT_COUNT.addAndGet(this, uplinkEventDelta);
        int uplinkCommandDelta = UPLINK_COMMAND_DELTA.getAndSet(this, 0);
        int uplinkCommandRate = UPLINK_COMMAND_RATE.getAndSet(this, 0);
        long uplinkCommandCount = UPLINK_COMMAND_COUNT.addAndGet(this, uplinkCommandDelta);
        int hostCount = (int)(hostOpenCount - hostCloseCount);
        long nodeCount = nodeOpenCount - nodeCloseCount;
        long agentCount = agentOpenCount - agentCloseCount;
        AgentPulse agentPulse = new AgentPulse(agentCount, agentExecRate, agentExecTime, timerEventRate, timerEventCount);
        long downlinkCount = downlinkOpenCount - downlinkCloseCount;
        WarpDownlinkPulse downlinkPulse = new WarpDownlinkPulse(downlinkCount, downlinkEventRate, downlinkEventCount, downlinkCommandRate, downlinkCommandCount);
        long uplinkCount = uplinkOpenCount - uplinkCloseCount;
        WarpUplinkPulse uplinkPulse = new WarpUplinkPulse(uplinkCount, uplinkEventRate, uplinkEventCount, uplinkCommandRate, uplinkCommandCount);
        this.pulse = new PartPulse(hostCount, nodeCount, agentPulse, downlinkPulse, uplinkPulse);
        DemandLane<PartPulse> metaPulse = this.metaPulse;
        if (metaPulse != null) {
            metaPulse.cue();
        }
        return new PartProfile(this.cellAddress(), hostOpenDelta, hostOpenCount, hostCloseDelta, hostCloseCount, nodeOpenDelta, nodeOpenCount, nodeCloseDelta, nodeCloseCount, agentOpenDelta, agentOpenCount, agentCloseDelta, agentCloseCount, agentExecDelta, agentExecRate, agentExecTime, timerEventDelta, timerEventRate, timerEventCount, downlinkOpenDelta, downlinkOpenCount, downlinkCloseDelta, downlinkCloseCount, downlinkEventDelta, downlinkEventRate, downlinkEventCount, downlinkCommandDelta, downlinkCommandRate, downlinkCommandCount, uplinkOpenDelta, uplinkOpenCount, uplinkCloseDelta, uplinkCloseCount, uplinkEventDelta, uplinkEventRate, uplinkEventCount, uplinkCommandDelta, uplinkCommandRate, uplinkCommandCount);
    }
}

