/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.scope;

import swim.api.downlink.EventDownlink;
import swim.api.downlink.ListDownlink;
import swim.api.downlink.MapDownlink;
import swim.api.downlink.ValueDownlink;
import swim.api.http.HttpDownlink;
import swim.api.ref.LaneRef;
import swim.api.ref.NodeRef;
import swim.api.ws.WsDownlink;
import swim.concurrent.Cont;
import swim.concurrent.Stage;
import swim.runtime.CellContext;
import swim.runtime.Push;
import swim.runtime.downlink.EventDownlinkView;
import swim.runtime.downlink.MapDownlinkView;
import swim.runtime.downlink.ValueDownlinkView;
import swim.runtime.scope.LaneScope;
import swim.runtime.scope.Scope;
import swim.structure.Form;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;

public class NodeScope
extends Scope
implements NodeRef {
    protected final Uri meshUri;
    protected final Uri hostUri;
    protected final Uri nodeUri;

    public NodeScope(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri) {
        super(cellContext, stage);
        this.meshUri = meshUri;
        this.hostUri = hostUri;
        this.nodeUri = nodeUri;
    }

    @Override
    public final Uri meshUri() {
        return this.meshUri;
    }

    public final Uri hostUri() {
        return this.hostUri;
    }

    public final Uri nodeUri() {
        return this.nodeUri;
    }

    public LaneRef laneRef(Uri laneUri) {
        return new LaneScope(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, laneUri);
    }

    public LaneRef laneRef(String laneUri) {
        return this.laneRef(Uri.parse((String)laneUri));
    }

    public EventDownlink<Value> downlink() {
        return new EventDownlinkView<Value>(this, this.stage, this.meshUri, this.hostUri, this.nodeUri, Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public ListDownlink<Value> downlinkList() {
        return null;
    }

    public MapDownlink<Value, Value> downlinkMap() {
        return new MapDownlinkView<Value, Value>((CellContext)this, this.stage, this.meshUri, this.hostUri, this.nodeUri, Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue(), Form.forValue());
    }

    public ValueDownlink<Value> downlinkValue() {
        return new ValueDownlinkView<Value>(this, this.stage, this.meshUri, this.hostUri, this.nodeUri, Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public <V> HttpDownlink<V> downlinkHttp() {
        return null;
    }

    public <I, O> WsDownlink<I, O> downlinkWs() {
        return null;
    }

    public void command(Uri laneUri, float prio, Value body, Cont<CommandMessage> cont) {
        Uri meshUri = this.meshUri;
        Uri hostUri = this.hostUri;
        if (!meshUri.isDefined()) {
            meshUri = hostUri;
        }
        Uri nodeUri = this.nodeUri;
        CommandMessage message = new CommandMessage(nodeUri, laneUri, body);
        this.pushDown(new Push<CommandMessage>(meshUri, hostUri, nodeUri, laneUri, prio, null, message, cont));
    }

    public void command(String laneUri, float prio, Value body, Cont<CommandMessage> cont) {
        this.command(Uri.parse((String)laneUri), prio, body, cont);
    }

    public void command(Uri laneUri, Value body, Cont<CommandMessage> cont) {
        this.command(laneUri, 0.0f, body, cont);
    }

    public void command(String laneUri, Value body, Cont<CommandMessage> cont) {
        this.command(Uri.parse((String)laneUri), body, cont);
    }

    public void command(Uri laneUri, float prio, Value body) {
        this.command(laneUri, prio, body, null);
    }

    public void command(String laneUri, float prio, Value body) {
        this.command(Uri.parse((String)laneUri), prio, body, null);
    }

    public void command(Uri laneUri, Value body) {
        this.command(laneUri, 0.0f, body, null);
    }

    public void command(String laneUri, Value body) {
        this.command(Uri.parse((String)laneUri), body, null);
    }
}

