/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.concurrent.ConcurrentLinkedQueue;
import swim.runtime.Push;
import swim.runtime.warp.ListLinkDelta;
import swim.runtime.warp.WarpDownlinkModel;
import swim.runtime.warp.WarpDownlinkView;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;

public abstract class ListDownlinkModem<View extends WarpDownlinkView>
extends WarpDownlinkModel<View> {
    final ConcurrentLinkedQueue<ListLinkDelta> upQueue = new ConcurrentLinkedQueue();

    public ListDownlinkModem(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    @Override
    protected boolean upQueueIsEmpty() {
        return this.upQueue.isEmpty();
    }

    public void queueUp(ListLinkDelta delta) {
        this.upQueue.add(delta);
    }

    public void pushUp(ListLinkDelta delta) {
        int newStatus;
        int oldStatus;
        this.queueUp(delta);
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0x800)) {
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.linkContext.feedUp();
            break;
        }
    }

    @Override
    protected Push<CommandMessage> nextUpQueue() {
        ListLinkDelta delta = this.upQueue.poll();
        if (delta != null) {
            Uri hostUri = this.hostUri();
            Uri nodeUri = this.nodeUri();
            Uri laneUri = this.laneUri();
            float prio = this.prio();
            Value body = delta.toValue();
            CommandMessage message = new CommandMessage(nodeUri, laneUri, body);
            return new Push<CommandMessage>(Uri.empty(), hostUri, nodeUri, laneUri, prio, null, message, null);
        }
        return null;
    }
}

