/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.concurrent.ConcurrentLinkedQueue;
import swim.runtime.UplinkAddress;
import swim.runtime.WarpBinding;
import swim.runtime.warp.ListLinkDelta;
import swim.runtime.warp.WarpUplinkModem;
import swim.structure.Value;

public abstract class ListUplinkModem
extends WarpUplinkModem {
    final ConcurrentLinkedQueue<ListLinkDelta> downQueue = new ConcurrentLinkedQueue();

    public ListUplinkModem(WarpBinding linkBinding, UplinkAddress uplinkAddress) {
        super(linkBinding, uplinkAddress);
    }

    @Override
    protected boolean downQueueIsEmpty() {
        return this.downQueue.isEmpty();
    }

    public void queueDown(ListLinkDelta delta) {
        this.downQueue.add(delta);
    }

    public void sendDown(ListLinkDelta delta) {
        int newStatus;
        int oldStatus;
        this.queueDown(delta);
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0x20)) {
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.linkBinding.feedDown();
            break;
        }
    }

    @Override
    protected Value nextDownQueue() {
        ListLinkDelta delta = this.downQueue.poll();
        return delta != null ? delta.toValue() : null;
    }
}

