/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.collections.HashTrieSet;
import swim.concurrent.Cont;
import swim.runtime.Push;
import swim.runtime.warp.WarpDownlinkModel;
import swim.runtime.warp.WarpDownlinkView;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;

public abstract class MapDownlinkModem<View extends WarpDownlinkView>
extends WarpDownlinkModel<View> {
    static final AtomicReferenceFieldUpdater<MapDownlinkModem<?>, HashTrieSet<Value>> KEY_QUEUE = AtomicReferenceFieldUpdater.newUpdater(MapDownlinkModem.class, HashTrieSet.class, "keyQueue");
    final ConcurrentLinkedQueue<Push<CommandMessage>> upQueue = new ConcurrentLinkedQueue();
    volatile HashTrieSet<Value> keyQueue = HashTrieSet.empty();
    volatile Value lastKey;

    public MapDownlinkModem(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    @Override
    protected boolean upQueueIsEmpty() {
        return this.upQueue.isEmpty();
    }

    @Override
    protected void queueUp(Value body, Cont<CommandMessage> cont) {
        Uri hostUri = this.hostUri();
        Uri nodeUri = this.nodeUri();
        Uri laneUri = this.laneUri();
        float prio = this.prio();
        CommandMessage message = new CommandMessage(nodeUri, laneUri, body);
        this.upQueue.add(new Push<CommandMessage>(Uri.empty(), hostUri, nodeUri, laneUri, prio, null, message, cont));
    }

    public void cueUpKey(Value key) {
        HashTrieSet newKeyQueue;
        HashTrieSet<Value> oldKeyQueue;
        while ((oldKeyQueue = this.keyQueue) != (newKeyQueue = oldKeyQueue.added((Object)key))) {
            if (!KEY_QUEUE.compareAndSet(this, oldKeyQueue, (HashTrieSet<Value>)newKeyQueue)) continue;
            this.cueUp();
            break;
        }
    }

    protected void cueUpKeys(Collection<? extends Value> keys) {
        if (!keys.isEmpty()) {
            HashTrieSet newKeyQueue;
            HashTrieSet<Value> oldKeyQueue;
            while (!KEY_QUEUE.compareAndSet(this, oldKeyQueue = this.keyQueue, (HashTrieSet<Value>)(newKeyQueue = oldKeyQueue.added(keys)))) {
            }
            this.cueUp();
        }
    }

    protected abstract Value nextUpKey(Value var1);

    @Override
    protected Push<CommandMessage> nextUpQueue() {
        return this.upQueue.poll();
    }

    @Override
    protected Push<CommandMessage> nextUpCue() {
        Value key;
        HashTrieSet newKeyQueue;
        HashTrieSet<Value> oldKeyQueue;
        while ((oldKeyQueue = this.keyQueue) != (newKeyQueue = oldKeyQueue.removed((Object)(key = (Value)oldKeyQueue.next((Object)this.lastKey)))) && !KEY_QUEUE.compareAndSet(this, oldKeyQueue, (HashTrieSet<Value>)newKeyQueue)) {
        }
        if (key != null) {
            this.lastKey = key;
            Uri hostUri = this.hostUri();
            Uri nodeUri = this.nodeUri();
            Uri laneUri = this.laneUri();
            float prio = this.prio();
            Value body = this.nextUpKey(key);
            CommandMessage message = new CommandMessage(nodeUri, laneUri, body);
            return new Push<CommandMessage>(Uri.empty(), hostUri, nodeUri, laneUri, prio, null, message, null);
        }
        return null;
    }

    @Override
    protected void feedUp() {
        if (!this.keyQueue.isEmpty()) {
            this.cueUp();
        }
        super.feedUp();
    }
}

