/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.collections.HashTrieSet;
import swim.runtime.UplinkAddress;
import swim.runtime.WarpBinding;
import swim.runtime.warp.WarpUplinkModem;
import swim.structure.Value;

public abstract class MapUplinkModem
extends WarpUplinkModem {
    static final AtomicReferenceFieldUpdater<MapUplinkModem, HashTrieSet<Value>> KEY_QUEUE = AtomicReferenceFieldUpdater.newUpdater(MapUplinkModem.class, HashTrieSet.class, "keyQueue");
    final ConcurrentLinkedQueue<Value> downQueue = new ConcurrentLinkedQueue();
    volatile Iterator<Value> syncQueue;
    volatile HashTrieSet<Value> keyQueue = HashTrieSet.empty();
    volatile Value lastKey;

    public MapUplinkModem(WarpBinding linkBinding, UplinkAddress uplinkAddress) {
        super(linkBinding, uplinkAddress);
    }

    @Override
    protected boolean downQueueIsEmpty() {
        return this.downQueue.isEmpty() && this.syncQueue == null;
    }

    @Override
    protected void queueDown(Value body) {
        this.downQueue.add(body);
    }

    public void syncDown(Iterator<Value> syncQueue) {
        this.syncQueue = syncQueue;
    }

    public void cueDownKey(Value key) {
        HashTrieSet newKeyQueue;
        HashTrieSet<Value> oldKeyQueue;
        while ((oldKeyQueue = this.keyQueue) != (newKeyQueue = oldKeyQueue.added((Object)key))) {
            if (!KEY_QUEUE.compareAndSet(this, oldKeyQueue, (HashTrieSet<Value>)newKeyQueue)) continue;
            this.cueDown();
            break;
        }
    }

    protected abstract Value nextDownKey(Value var1);

    @Override
    protected Value nextDownQueue() {
        Iterator<Value> syncQueue = this.syncQueue;
        if (syncQueue != null) {
            if (syncQueue.hasNext()) {
                Value key = syncQueue.next();
                return this.nextDownKey(key);
            }
            this.syncQueue = null;
            return null;
        }
        return this.downQueue.poll();
    }

    @Override
    protected Value nextDownCue() {
        Value key;
        HashTrieSet newKeyQueue;
        HashTrieSet<Value> oldKeyQueue;
        while ((oldKeyQueue = this.keyQueue) != (newKeyQueue = oldKeyQueue.removed((Object)(key = (Value)oldKeyQueue.next((Object)this.lastKey)))) && !KEY_QUEUE.compareAndSet(this, oldKeyQueue, (HashTrieSet<Value>)newKeyQueue)) {
        }
        if (key != null) {
            this.lastKey = key;
            if (!newKeyQueue.isEmpty()) {
                int newStatus;
                int oldStatus;
                while ((oldStatus = this.status) != (newStatus = oldStatus | 0x10) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
                }
            }
            return this.nextDownKey(key);
        }
        return null;
    }
}

