/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.runtime.CellContext;
import swim.runtime.DownlinkModel;
import swim.runtime.DownlinkView;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.NodeBinding;
import swim.runtime.Push;
import swim.runtime.WarpBinding;
import swim.runtime.WarpContext;
import swim.runtime.profile.WarpDownlinkProfile;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.Envelope;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class WarpDownlinkModem<View extends DownlinkView>
extends DownlinkModel<View>
implements WarpBinding {
    protected final float prio;
    protected final float rate;
    protected final Value body;
    protected WarpContext linkContext;
    protected CellContext cellContext;
    protected volatile int status;
    volatile long execDelta;
    volatile long execTime;
    volatile int openDelta;
    volatile int openCount;
    volatile int closeDelta;
    volatile int closeCount;
    volatile int eventDelta;
    volatile int commandDelta;
    volatile long eventCount;
    volatile long commandCount;
    volatile long lastReportTime;
    static final int OPENED = 1;
    static final int LINKED = 2;
    static final int LINK = 4;
    static final int LINKING = 8;
    static final int SYNC = 16;
    static final int SYNCING = 32;
    static final int UNLINK = 64;
    static final int UNLINKING = 128;
    static final int FEEDING_DOWN = 256;
    static final int PULLING_DOWN = 512;
    static final int CUED_UP = 1024;
    static final int FEEDING_UP = 2048;
    static final AtomicIntegerFieldUpdater<WarpDownlinkModem<?>> STATUS = AtomicIntegerFieldUpdater.newUpdater(WarpDownlinkModem.class, "status");
    protected static final AtomicLongFieldUpdater<WarpDownlinkModem<?>> EXEC_DELTA = AtomicLongFieldUpdater.newUpdater(WarpDownlinkModem.class, "execDelta");
    protected static final AtomicLongFieldUpdater<WarpDownlinkModem<?>> EXEC_TIME = AtomicLongFieldUpdater.newUpdater(WarpDownlinkModem.class, "execTime");
    static final AtomicIntegerFieldUpdater<WarpDownlinkModem<?>> OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpDownlinkModem.class, "openDelta");
    static final AtomicIntegerFieldUpdater<WarpDownlinkModem<?>> OPEN_COUNT = AtomicIntegerFieldUpdater.newUpdater(WarpDownlinkModem.class, "openCount");
    static final AtomicIntegerFieldUpdater<WarpDownlinkModem<?>> CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpDownlinkModem.class, "closeDelta");
    static final AtomicIntegerFieldUpdater<WarpDownlinkModem<?>> CLOSE_COUNT = AtomicIntegerFieldUpdater.newUpdater(WarpDownlinkModem.class, "closeCount");
    static final AtomicIntegerFieldUpdater<WarpDownlinkModem<?>> EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpDownlinkModem.class, "eventDelta");
    static final AtomicLongFieldUpdater<WarpDownlinkModem<?>> EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(WarpDownlinkModem.class, "eventCount");
    static final AtomicIntegerFieldUpdater<WarpDownlinkModem<?>> COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpDownlinkModem.class, "commandDelta");
    static final AtomicLongFieldUpdater<WarpDownlinkModem<?>> COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(WarpDownlinkModem.class, "commandCount");
    static final AtomicLongFieldUpdater<WarpDownlinkModem<?>> LAST_REPORT_TIME = AtomicLongFieldUpdater.newUpdater(WarpDownlinkModem.class, "lastReportTime");

    public WarpDownlinkModem(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri);
        this.prio = prio;
        this.rate = rate;
        this.body = body;
    }

    @Override
    public final WarpBinding linkWrapper() {
        return this;
    }

    @Override
    public final WarpContext linkContext() {
        return this.linkContext;
    }

    @Override
    public void setLinkContext(LinkContext linkContext) {
        this.linkContext = (WarpContext)linkContext;
    }

    @Override
    public final CellContext cellContext() {
        return this.cellContext;
    }

    @Override
    public void setCellContext(CellContext cellContext) {
        this.cellContext = cellContext;
    }

    @Override
    public final float prio() {
        return this.prio;
    }

    @Override
    public final float rate() {
        return this.rate;
    }

    @Override
    public final Value body() {
        return this.body;
    }

    @Override
    public abstract boolean keepLinked();

    @Override
    public abstract boolean keepSynced();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cueDown() {
        while (true) {
            int newStatus;
            int oldStatus;
            if (((oldStatus = this.status) & 0x100) != 0) {
                newStatus = oldStatus & 0xFFFFFEFF | 0x200;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                this.linkContext.pullDown();
                return;
            }
            newStatus = oldStatus & 0xFFFFFDFF;
            if (oldStatus == newStatus || STATUS.compareAndSet(this, oldStatus, newStatus)) return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void feedDown() {
        while (true) {
            int newStatus;
            int oldStatus;
            if (((oldStatus = this.status) & 0x200) == 0) {
                newStatus = oldStatus & 0xFFFFFEFF | 0x200;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                this.linkContext.pullDown();
                return;
            }
            newStatus = oldStatus | 0x100;
            if (oldStatus == newStatus || STATUS.compareAndSet(this, oldStatus, newStatus)) return;
        }
    }

    @Override
    public void pushDown(Push<?> push) {
        Object message = push.message();
        if (message instanceof EventMessage) {
            this.pushDownEvent(push);
        } else if (message instanceof LinkedResponse) {
            this.pushDownLinked(push);
        } else if (message instanceof SyncedResponse) {
            this.pushDownSynced(push);
        } else if (message instanceof UnlinkedResponse) {
            this.pushDownUnlinked(push);
        } else {
            this.pushDownUnknown(push);
        }
    }

    protected void pushDownEvent(Push<EventMessage> push) {
        try {
            this.onEvent(push.message());
        }
        finally {
            push.bind();
            this.cueDown();
        }
    }

    protected void pushDownLinked(Push<LinkedResponse> push) {
        try {
            this.didLink(push.message());
        }
        finally {
            push.bind();
            this.cueDown();
        }
    }

    protected void pushDownSynced(Push<SyncedResponse> push) {
        try {
            this.didSync(push.message());
        }
        finally {
            push.bind();
            this.cueDown();
        }
    }

    protected void pushDownUnlinked(Push<UnlinkedResponse> push) {
        try {
            this.didUnlink(push.message());
        }
        finally {
            push.bind();
        }
    }

    protected void pushDownUnknown(Push<?> push) {
        push.bind();
    }

    @Override
    public void skipDown() {
        this.cueDown();
    }

    protected boolean upQueueIsEmpty() {
        return true;
    }

    protected void queueUp(Value body, Cont<CommandMessage> cont) {
        throw new UnsupportedOperationException();
    }

    protected Push<CommandMessage> nextUpQueue() {
        return null;
    }

    protected Push<CommandMessage> nextUpCue() {
        return null;
    }

    public void pushUp(Value body) {
        int newStatus;
        int oldStatus;
        this.queueUp(body, null);
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0x800)) {
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.linkContext.feedUp();
            break;
        }
    }

    public void cueUp() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0xC00)) {
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            if ((oldStatus & 0x800) != 0) break;
            this.linkContext.feedUp();
            break;
        }
    }

    protected void feedUp() {
        int newStatus;
        int oldStatus;
        while (!(((oldStatus = this.status) & 0x400) == 0 && this.upQueueIsEmpty() || oldStatus == (newStatus = oldStatus | 0x800))) {
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.linkContext.feedUp();
            break;
        }
    }

    @Override
    public void pullUp() {
        block7: {
            int oldStatus;
            while (true) {
                int newStatus;
                if (((oldStatus = this.status) & 0x40) != 0) {
                    newStatus = oldStatus & 0xFFFFF7BF;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    UnlinkRequest request = this.unlinkRequest();
                    this.pullUpUnlink(request);
                    this.pushUp((Envelope)request);
                    break block7;
                }
                if ((oldStatus & 0x10) != 0) {
                    newStatus = oldStatus & 0xFFFFF7EB;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    SyncRequest request = this.syncRequest();
                    this.pullUpSync(request);
                    this.pushUp((Envelope)request);
                    this.feedUp();
                    break block7;
                }
                if ((oldStatus & 4) != 0) {
                    newStatus = oldStatus & 0xFFFFF7FB;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    LinkRequest request = this.linkRequest();
                    this.pullUpLink(request);
                    this.pushUp((Envelope)request);
                    this.feedUp();
                    break block7;
                }
                newStatus = oldStatus & 0xFFFFF3FF;
                if (oldStatus == newStatus || STATUS.compareAndSet(this, oldStatus, newStatus)) break;
            }
            Push<CommandMessage> push = this.nextUpQueue();
            if (push == null && (oldStatus & 0x400) != 0) {
                push = this.nextUpCue();
            }
            if (push != null) {
                this.pullUpCommand(push.message());
                this.linkContext.pushUp(push);
                this.feedUp();
            } else {
                this.linkContext.skipUp();
            }
        }
    }

    protected void pullUpCommand(CommandMessage message) {
        this.onCommand(message);
    }

    protected void pullUpLink(LinkRequest request) {
        this.willLink(request);
    }

    protected void pullUpSync(SyncRequest request) {
        this.willSync(request);
    }

    protected void pullUpUnlink(UnlinkRequest request) {
        this.willUnlink(request);
    }

    protected void pushUp(Envelope envelope) {
        this.linkContext.pushUp(new Push<Envelope>(Uri.empty(), this.hostUri(), this.nodeUri(), this.laneUri(), this.prio(), null, envelope, null));
    }

    public void link() {
        int oldStatus;
        while (((oldStatus = this.status) & 3) == 1) {
            int newStatus = oldStatus | 0x80E;
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            if ((oldStatus & 0x800) != 0 || this.linkContext == null) break;
            this.linkContext.feedUp();
            break;
        }
    }

    public void sync() {
        int oldStatus;
        while (((oldStatus = this.status) & 3) == 1) {
            int newStatus = oldStatus | 0x83E;
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            if ((oldStatus & 0x800) != 0 || this.linkContext == null) break;
            this.linkContext.feedUp();
            break;
        }
    }

    public void unlink() {
        block3: {
            int oldStatus;
            while (true) {
                int newStatus;
                if (((oldStatus = this.status) & 4) != 0) {
                    newStatus = oldStatus & 0xFFFFF7C1;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    break block3;
                }
                if ((oldStatus & 0x82) != 2) break block3;
                newStatus = oldStatus & 0xFFFFFFC3 | 0x8C0;
                if (STATUS.compareAndSet(this, oldStatus, newStatus)) break;
            }
            if ((oldStatus & 0x800) == 0 && this.linkContext != null) {
                this.linkContext.feedUp();
            }
        }
    }

    public void command(float prio, Value body, Cont<CommandMessage> cont) {
        this.queueUp(body, cont);
    }

    public void command(Value body, Cont<CommandMessage> cont) {
        this.queueUp(body, cont);
    }

    public void command(float prio, Value body) {
        this.queueUp(body, null);
    }

    public void command(Value body) {
        this.queueUp(body, null);
    }

    protected LinkRequest linkRequest() {
        return new LinkRequest(this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    protected SyncRequest syncRequest() {
        return new SyncRequest(this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    protected UnlinkRequest unlinkRequest() {
        return new UnlinkRequest(this.nodeUri, this.laneUri, this.body);
    }

    @Override
    protected void didAddDownlink(View view) {
        super.didAddDownlink(view);
        OPEN_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    @Override
    protected void didRemoveDownlink(View view) {
        super.didRemoveDownlink(view);
        CLOSE_DELTA.incrementAndGet(this);
    }

    @Override
    public void openDown() {
        this.didOpen();
        this.linkContext.didOpenDown();
        if ((this.status & 0x800) != 0) {
            this.linkContext.feedUp();
        }
    }

    protected void didOpen() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus | 1) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (this.keepLinked()) {
            if (this.keepSynced()) {
                this.sync();
            } else {
                this.link();
            }
        }
    }

    @Override
    public void closeDown() {
        CellContext cellContext = this.cellContext;
        if (cellContext != null) {
            cellContext.closeDownlink(this);
        }
        this.didClose();
        this.linkContext.didCloseDown();
    }

    protected void didClose() {
        STATUS.set(this, 0);
        this.removeDownlinks();
        this.flushMetrics();
    }

    protected void onEvent(EventMessage message) {
        EVENT_DELTA.incrementAndGet(this);
        this.didUpdateMetrics();
    }

    protected void onCommand(CommandMessage message) {
        COMMAND_DELTA.incrementAndGet(this);
        this.didUpdateMetrics();
    }

    protected void willLink(LinkRequest request) {
    }

    protected void didLink(LinkedResponse response) {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFF7) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
    }

    protected void willSync(SyncRequest request) {
    }

    protected void didSync(SyncedResponse response) {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFDF) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
    }

    protected void willUnlink(UnlinkRequest request) {
    }

    protected void didUnlink(UnlinkedResponse response) {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFD01) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
    }

    @Override
    public void didConnect() {
        if (this.keepLinked()) {
            if (this.keepSynced()) {
                this.sync();
            } else {
                this.link();
            }
        }
        super.didConnect();
    }

    @Override
    public void didDisconnect() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFF701) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        super.didDisconnect();
    }

    @Override
    public void didCloseUp() {
        this.didClose();
        super.didCloseUp();
    }

    @Override
    public void didFailUp(Throwable error) {
        this.didFail(error);
        if (Conts.isNonFatal((Throwable)error)) {
            this.reopen();
        }
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
        super.didFail(error);
    }

    @Override
    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        CellContext cellContext = this.cellContext;
        if (cellContext != null) {
            cellContext.openMetaDownlink(downlink, metaDownlink);
        }
    }

    @Override
    public void accumulateExecTime(long execDelta) {
        EXEC_DELTA.addAndGet(this, execDelta);
        this.didUpdateMetrics();
    }

    protected void didUpdateMetrics() {
        block4: {
            long dt;
            long newReportTime;
            long oldReportTime;
            do {
                oldReportTime = this.lastReportTime;
                newReportTime = System.currentTimeMillis();
                dt = newReportTime - oldReportTime;
                if (dt < 1000L) break block4;
            } while (!LAST_REPORT_TIME.compareAndSet(this, oldReportTime, newReportTime));
            try {
                this.reportMetrics(dt);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                }
                throw error;
            }
        }
    }

    protected void flushMetrics() {
        long newReportTime = System.currentTimeMillis();
        long oldReportTime = LAST_REPORT_TIME.getAndSet(this, newReportTime);
        long dt = newReportTime - oldReportTime;
        try {
            this.reportMetrics(dt);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void reportMetrics(long dt) {
        CellContext cellContext = this.cellContext;
        if (cellContext != null) {
            WarpDownlinkProfile profile = this.collectProfile(dt);
            cellContext.reportDown(profile);
        }
    }

    protected WarpDownlinkProfile collectProfile(long dt) {
        long execDelta = EXEC_DELTA.getAndSet(this, 0L);
        long execRate = (long)Math.ceil(1000.0 * (double)execDelta / (double)dt);
        long execTime = EXEC_TIME.addAndGet(this, execDelta);
        int openDelta = OPEN_DELTA.getAndSet(this, 0);
        int openCount = OPEN_COUNT.addAndGet(this, openDelta);
        int closeDelta = CLOSE_DELTA.getAndSet(this, 0);
        int closeCount = CLOSE_COUNT.addAndGet(this, closeDelta);
        int eventDelta = EVENT_DELTA.getAndSet(this, 0);
        int eventRate = (int)Math.ceil(1000.0 * (double)eventDelta / (double)dt);
        long eventCount = EVENT_COUNT.addAndGet(this, eventDelta);
        int commandDelta = COMMAND_DELTA.getAndSet(this, 0);
        int commandRate = (int)Math.ceil(1000.0 * (double)commandDelta / (double)dt);
        long commandCount = COMMAND_COUNT.addAndGet(this, commandDelta);
        return new WarpDownlinkProfile(this.cellAddressDown(), execDelta, execRate, execTime, openDelta, openCount, closeDelta, closeCount, eventDelta, eventRate, eventCount, commandDelta, commandRate, commandCount);
    }
}

