/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.api.auth.Identity;
import swim.collections.FingerTrieSeq;
import swim.runtime.CellContext;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;
import swim.warp.CommandMessage;
import swim.warp.Envelope;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class DownlinkModem
implements LinkBinding,
Log {
    protected LinkContext linkContext;
    protected CellContext cellContext;
    protected final Uri meshUri;
    protected final Uri hostUri;
    protected final Uri nodeUri;
    protected final Uri laneUri;
    protected final float prio;
    protected final float rate;
    protected final Value body;
    protected volatile int status;
    static final int OPENED = 1;
    static final int LINKED = 2;
    static final int LINK = 4;
    static final int LINKING = 8;
    static final int SYNC = 16;
    static final int SYNCING = 32;
    static final int UNLINK = 64;
    static final int UNLINKING = 128;
    static final int FEEDING_DOWN = 256;
    static final int PULLING_DOWN = 512;
    static final int CUED_UP = 1024;
    static final int FEEDING_UP = 2048;
    static final AtomicIntegerFieldUpdater<DownlinkModem> STATUS = AtomicIntegerFieldUpdater.newUpdater(DownlinkModem.class, "status");

    public DownlinkModem(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        this.meshUri = meshUri;
        this.hostUri = hostUri;
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
        this.prio = prio;
        this.rate = rate;
        this.body = body;
    }

    @Override
    public final LinkContext linkContext() {
        return this.linkContext;
    }

    @Override
    public void setLinkContext(LinkContext linkContext) {
        this.linkContext = linkContext;
    }

    @Override
    public final CellContext cellContext() {
        return this.cellContext;
    }

    @Override
    public void setCellContext(CellContext cellContext) {
        this.cellContext = cellContext;
    }

    @Override
    public <T> T unwrapLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public final Uri meshUri() {
        return this.meshUri;
    }

    @Override
    public final Uri hostUri() {
        return this.hostUri;
    }

    @Override
    public final Uri nodeUri() {
        return this.nodeUri;
    }

    @Override
    public final Uri laneUri() {
        return this.laneUri;
    }

    @Override
    public final float prio() {
        return this.prio;
    }

    @Override
    public final float rate() {
        return this.rate;
    }

    @Override
    public final Value body() {
        return this.body;
    }

    @Override
    public abstract boolean keepLinked();

    @Override
    public abstract boolean keepSynced();

    @Override
    public boolean isConnectedDown() {
        return true;
    }

    @Override
    public boolean isRemoteDown() {
        return false;
    }

    @Override
    public boolean isSecureDown() {
        return true;
    }

    @Override
    public String securityProtocolDown() {
        return null;
    }

    @Override
    public String cipherSuiteDown() {
        return null;
    }

    @Override
    public InetSocketAddress localAddressDown() {
        return null;
    }

    @Override
    public final Identity localIdentityDown() {
        return null;
    }

    @Override
    public Principal localPrincipalDown() {
        return null;
    }

    @Override
    public Collection<Certificate> localCertificatesDown() {
        return FingerTrieSeq.empty();
    }

    @Override
    public InetSocketAddress remoteAddressDown() {
        return null;
    }

    @Override
    public final Identity remoteIdentityDown() {
        return null;
    }

    @Override
    public Principal remotePrincipalDown() {
        return null;
    }

    @Override
    public Collection<Certificate> remoteCertificatesDown() {
        return FingerTrieSeq.empty();
    }

    public boolean isConnected() {
        return this.linkContext.isConnectedUp();
    }

    public boolean isRemote() {
        return this.linkContext.isRemoteUp();
    }

    public boolean isSecure() {
        return this.linkContext.isSecureUp();
    }

    public String securityProtocol() {
        return this.linkContext.securityProtocolUp();
    }

    public String cipherSuite() {
        return this.linkContext.cipherSuiteUp();
    }

    public InetSocketAddress localAddress() {
        return this.linkContext.localAddressUp();
    }

    public Identity localIdentity() {
        return this.linkContext.localIdentityUp();
    }

    public Principal localPrincipal() {
        return this.linkContext.localPrincipalUp();
    }

    public Collection<Certificate> localCertificates() {
        return this.linkContext.localCertificatesUp();
    }

    public InetSocketAddress remoteAddress() {
        return this.linkContext.remoteAddressUp();
    }

    public Identity remoteIdentity() {
        return this.linkContext.remoteIdentityUp();
    }

    public Principal remotePrincipal() {
        return this.linkContext.remotePrincipalUp();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.linkContext.remoteCertificatesUp();
    }

    public void cueDown() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x100) != 0 ? oldStatus & 0xFFFFFEFF | 0x200 : oldStatus & 0xFFFFFDFF) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x100) != 0) {
            this.linkContext.pullDown();
        }
    }

    @Override
    public void feedDown() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x200) == 0 ? oldStatus & 0xFFFFFEFF | 0x200 : oldStatus | 0x100) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x200) == 0) {
            this.linkContext.pullDown();
        }
    }

    @Override
    public void pushDown(Envelope envelope) {
        if (envelope instanceof EventMessage) {
            this.pushDownEvent((EventMessage)envelope);
        } else if (envelope instanceof LinkedResponse) {
            this.pushDownLinked((LinkedResponse)envelope);
        } else if (envelope instanceof SyncedResponse) {
            this.pushDownSynced((SyncedResponse)envelope);
        } else if (envelope instanceof UnlinkedResponse) {
            this.pushDownUnlinked((UnlinkedResponse)envelope);
        } else {
            this.pushDownEnvelope(envelope);
        }
    }

    protected void pushDownEvent(EventMessage message) {
        try {
            this.onEvent(message);
        }
        finally {
            this.cueDown();
        }
    }

    protected void pushDownLinked(LinkedResponse response) {
        try {
            this.didLink(response);
        }
        finally {
            this.cueDown();
        }
    }

    protected void pushDownSynced(SyncedResponse response) {
        try {
            this.didSync(response);
        }
        finally {
            this.cueDown();
        }
    }

    protected void pushDownUnlinked(UnlinkedResponse response) {
        this.didUnlink(response);
    }

    protected void pushDownEnvelope(Envelope envelope) {
    }

    @Override
    public void skipDown() {
        this.cueDown();
    }

    protected boolean upQueueIsEmpty() {
        return true;
    }

    protected void queueUp(Value body) {
        throw new UnsupportedOperationException();
    }

    protected Value nextUpQueue() {
        return null;
    }

    protected CommandMessage nextUpQueueCommand() {
        Value body = this.nextUpQueue();
        if (body != null) {
            return new CommandMessage(this.nodeUri, this.laneUri, body);
        }
        return null;
    }

    protected Value nextUpCue() {
        return null;
    }

    protected CommandMessage nextUpCueCommand() {
        Value body = this.nextUpCue();
        if (body != null) {
            return new CommandMessage(this.nodeUri, this.laneUri, body);
        }
        return null;
    }

    public void pushUp(Value body) {
        int newStatus;
        int oldStatus;
        this.queueUp(body);
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0x800) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            this.linkContext.feedUp();
        }
    }

    public void cueUp() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0x800 | 0x400) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x800) == 0) {
            this.linkContext.feedUp();
        }
    }

    protected void feedUp() {
        int newStatus;
        int oldStatus;
        do {
            if (((oldStatus = this.status) & 0x400) == 0 && this.upQueueIsEmpty()) {
                newStatus = oldStatus;
                break;
            }
            newStatus = oldStatus | 0x800;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if (oldStatus != newStatus) {
            this.linkContext.feedUp();
        }
    }

    @Override
    public void pullUp() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x40) != 0 ? oldStatus & 0xFFFFF7BF : ((oldStatus & 0x10) != 0 ? oldStatus & 0xFFFFF7EB : ((oldStatus & 4) != 0 ? oldStatus & 0xFFFFF7FB : oldStatus & 0xFFFFF3FF))) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x40) != 0) {
            UnlinkRequest request = this.unlinkRequest();
            this.pullUpUnlink(request);
            this.linkContext.pushUp((Envelope)request);
        } else if ((oldStatus & 0x10) != 0) {
            SyncRequest request = this.syncRequest();
            this.pullUpSync(request);
            this.linkContext.pushUp((Envelope)request);
            this.feedUp();
        } else if ((oldStatus & 4) != 0) {
            LinkRequest request = this.linkRequest();
            this.pullUpLink(request);
            this.linkContext.pushUp((Envelope)request);
            this.feedUp();
        } else {
            CommandMessage message = this.nextUpQueueCommand();
            if (message == null && (oldStatus & 0x400) != 0) {
                message = this.nextUpCueCommand();
            }
            if (message != null) {
                this.pullUpCommand(message);
                this.linkContext.pushUp((Envelope)message);
                this.feedUp();
            } else {
                this.linkContext.skipUp();
            }
        }
    }

    protected void pullUpCommand(CommandMessage message) {
        this.onCommand(message);
    }

    protected void pullUpLink(LinkRequest request) {
        this.willLink(request);
    }

    protected void pullUpSync(SyncRequest request) {
        this.willSync(request);
    }

    protected void pullUpUnlink(UnlinkRequest request) {
        this.willUnlink(request);
    }

    public void link() {
        int newStatus;
        int oldStatus;
        do {
            if (((oldStatus = this.status) & 3) != 1) {
                newStatus = oldStatus;
                break;
            }
            newStatus = oldStatus | 0x800 | 8 | 4 | 2;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if ((oldStatus & 0x800) == 0 && (newStatus & 0x800) != 0 && this.linkContext != null) {
            this.linkContext.feedUp();
        }
    }

    public void sync() {
        int newStatus;
        int oldStatus;
        do {
            if (((oldStatus = this.status) & 3) != 1) {
                newStatus = oldStatus;
                break;
            }
            newStatus = oldStatus | 0x800 | 0x20 | 0x10 | 8 | 4 | 2;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if ((oldStatus & 0x800) == 0 && (newStatus & 0x800) != 0 && this.linkContext != null) {
            this.linkContext.feedUp();
        }
    }

    public void unlink() {
        int newStatus;
        int oldStatus;
        do {
            if (((oldStatus = this.status) & 4) != 0) {
                newStatus = oldStatus & 0xFFFFF7C1;
                continue;
            }
            if ((oldStatus & 0x82) == 2) {
                newStatus = (oldStatus | 0x800 | 0x80 | 0x40) & 0xFFFFFFC3;
                continue;
            }
            newStatus = oldStatus;
            break;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if ((oldStatus & 0x800) == 0 && (newStatus & 0x800) != 0 && this.linkContext != null) {
            this.linkContext.feedUp();
        }
    }

    public void command(float prio, Value body) {
        this.queueUp(body);
    }

    public void command(Value body) {
        this.queueUp(body);
    }

    protected LinkRequest linkRequest() {
        return new LinkRequest(this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    protected SyncRequest syncRequest() {
        return new SyncRequest(this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    protected UnlinkRequest unlinkRequest() {
        return new UnlinkRequest(this.nodeUri, this.laneUri, this.body);
    }

    @Override
    public void reopen() {
    }

    @Override
    public void openDown() {
        this.didOpen();
        this.linkContext.didOpenDown();
        if ((this.status & 0x800) != 0) {
            this.linkContext.feedUp();
        }
    }

    protected void didOpen() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus | 1) & !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (this.keepLinked()) {
            if (this.keepSynced()) {
                this.sync();
            } else {
                this.link();
            }
        }
    }

    @Override
    public void closeDown() {
        CellContext cellContext = this.cellContext;
        if (cellContext != null) {
            cellContext.closeDownlink(this);
        }
        this.didClose();
        this.linkContext.didCloseDown();
    }

    protected void didClose() {
        STATUS.set(this, 0);
    }

    protected void onEvent(EventMessage message) {
    }

    protected void onCommand(CommandMessage message) {
    }

    protected void willLink(LinkRequest request) {
    }

    protected void didLink(LinkedResponse response) {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFF7) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
    }

    protected void willSync(SyncRequest request) {
    }

    protected void didSync(SyncedResponse response) {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFDF) & !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
    }

    protected void willUnlink(UnlinkRequest request) {
    }

    protected void didUnlink(UnlinkedResponse response) {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFD01) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
    }

    @Override
    public void didConnect() {
        if (this.keepLinked()) {
            if (this.keepSynced()) {
                this.sync();
            } else {
                this.link();
            }
        }
    }

    @Override
    public void didDisconnect() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFF701) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
    }

    @Override
    public void didCloseUp() {
        this.didClose();
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    @Override
    public void traceDown(Object message) {
    }

    @Override
    public void debugDown(Object message) {
    }

    @Override
    public void infoDown(Object message) {
    }

    @Override
    public void warnDown(Object message) {
    }

    @Override
    public void errorDown(Object message) {
    }

    public void trace(Object message) {
        this.linkContext.traceUp(message);
    }

    public void debug(Object message) {
        this.linkContext.debugUp(message);
    }

    public void info(Object message) {
        this.linkContext.infoUp(message);
    }

    public void warn(Object message) {
        this.linkContext.warnUp(message);
    }

    public void error(Object message) {
        this.linkContext.errorUp(message);
    }
}

