/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.runtime.lane.JoinValueLaneModel;
import swim.runtime.lane.JoinValueLaneView;
import swim.runtime.lane.LaneRelay;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class JoinValueLaneRelayClear
extends LaneRelay<JoinValueLaneModel, JoinValueLaneView<?, ?>> {
    final Link link;
    final CommandMessage message;

    JoinValueLaneRelayClear(JoinValueLaneModel model, Link link, CommandMessage message) {
        super(model, 4);
        this.link = link;
        this.message = message;
    }

    JoinValueLaneRelayClear(JoinValueLaneModel model, Link link) {
        super(model, 1, 3);
        this.link = link;
        this.message = null;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            ((JoinValueLaneModel)this.model).closeDownlinks();
            ((JoinValueLaneModel)this.model).data.clear();
        }
    }

    @Override
    boolean runPhase(JoinValueLaneView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                view.laneWillClear();
            }
            return view.dispatchWillClear(this.link, preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.laneDidClear();
            }
            return view.dispatchDidClear(this.link, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        ((JoinValueLaneModel)this.model).sendDown((Value)Record.create((int)1).attr("clear"));
    }
}

