/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import swim.collections.BTreeMap;
import swim.runtime.downlink.DownlinkView;
import swim.runtime.downlink.MapDownlinkRelayClear;
import swim.runtime.downlink.MapDownlinkRelayDrop;
import swim.runtime.downlink.MapDownlinkRelayRemove;
import swim.runtime.downlink.MapDownlinkRelayTake;
import swim.runtime.downlink.MapDownlinkRelayUpdate;
import swim.runtime.downlink.MapDownlinkView;
import swim.runtime.downlink.PartialDownlinkModem;
import swim.structure.Attr;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;
import swim.warp.EventMessage;

public class MapDownlinkModel
extends PartialDownlinkModem<MapDownlinkView<?, ?>> {
    protected int flags = 0;
    protected final BTreeMap<Value, Value, Value> state = BTreeMap.empty();
    protected static final int STATEFUL = 1;

    public MapDownlinkModel(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    public final boolean isStateful() {
        return (this.flags & 1) != 0;
    }

    public MapDownlinkModel isStateful(boolean isStateful) {
        this.flags = isStateful ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof DownlinkView) {
            ((MapDownlinkView)views).didSetStateful(isStateful);
        } else if (views instanceof DownlinkView[]) {
            DownlinkView[] viewArray = (DownlinkView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((MapDownlinkView)viewArray[i]).didSetStateful(isStateful);
            }
        }
        return this;
    }

    @Override
    protected void pushDownEvent(EventMessage message) {
        this.onEvent(message);
        Value payload = message.body();
        String tag = payload.tag();
        if ("update".equals(tag)) {
            Value header = payload.header("update");
            Value key = header.get("key");
            Value value = payload.body();
            new MapDownlinkRelayUpdate(this, message, key, value).run();
        } else if ("remove".equals(tag)) {
            Value header = payload.header("remove");
            Value key = header.get("key");
            new MapDownlinkRelayRemove(this, message, key).run();
        } else if ("drop".equals(tag)) {
            Value header = payload.header("drop");
            int lower = header.intValue(0);
            new MapDownlinkRelayDrop(this, message, lower).run();
        } else if ("take".equals(tag)) {
            Value header = payload.header("take");
            int upper = header.intValue(0);
            new MapDownlinkRelayTake(this, message, upper).run();
        } else if ("clear".equals(tag)) {
            new MapDownlinkRelayClear(this, message).run();
        }
    }

    @Override
    protected Value nextUpKey(Value key) {
        Value value = (Value)this.state.get((Object)key);
        if (value != null) {
            return Attr.of((String)"update", (Value)Record.create((int)1).slot("key", key)).concat((Item)value);
        }
        return null;
    }

    @Override
    protected void didAddDownlink(MapDownlinkView<?, ?> view) {
        if (this.views instanceof DownlinkView) {
            this.isStateful(view.isStateful());
        }
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public int size() {
        return this.state.size();
    }

    public boolean containsKey(Object key) {
        if (key != null) {
            return this.state.containsKey(key);
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value != null) {
            return this.state.containsValue(value);
        }
        return false;
    }

    public int indexOf(Object key) {
        return this.state.indexOf(key);
    }

    public Value get(Object key) {
        Value value;
        if (key != null && (value = (Value)this.state.get(key)) != null) {
            return value;
        }
        return Value.absent();
    }

    public Map.Entry<Value, Value> getEntry(Object key) {
        return this.state.getEntry(key);
    }

    public Map.Entry<Value, Value> getIndex(int index) {
        return this.state.getIndex(index);
    }

    public Map.Entry<Value, Value> firstEntry() {
        return this.state.firstEntry();
    }

    public Value firstKey() {
        return (Value)this.state.firstKey();
    }

    public Value firstValue() {
        return (Value)this.state.firstValue();
    }

    public Map.Entry<Value, Value> lastEntry() {
        return this.state.lastEntry();
    }

    public Value lastKey() {
        return (Value)this.state.lastKey();
    }

    public Value lastValue() {
        return (Value)this.state.lastValue();
    }

    public Map.Entry<Value, Value> nextEntry(Value key) {
        return this.state.nextEntry((Object)key);
    }

    public Value nextKey(Value key) {
        return (Value)this.state.nextKey((Object)key);
    }

    public Value nextValue(Value key) {
        return (Value)this.state.nextValue((Object)key);
    }

    public Map.Entry<Value, Value> previousEntry(Value key) {
        return this.state.previousEntry((Object)key);
    }

    public Value previousKey(Value key) {
        return (Value)this.state.previousKey((Object)key);
    }

    public Value previousValue(Value key) {
        return (Value)this.state.previousValue((Object)key);
    }

    public <K, V> V put(MapDownlinkView<K, V> view, K keyObject, V newObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        Value newValue = valueForm.mold(newObject).toValue();
        MapDownlinkRelayUpdate relay = new MapDownlinkRelayUpdate(this, key, newValue);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.stage = view.stage;
        relay.run();
        if (relay.isDone() && relay.valueForm == valueForm) {
            return (V)relay.oldObject;
        }
        return null;
    }

    public <K, V> V remove(MapDownlinkView<K, V> view, K keyObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        MapDownlinkRelayRemove relay = new MapDownlinkRelayRemove(this, key);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.stage = view.stage;
        relay.run();
        if (relay.isDone()) {
            if (relay.valueForm != valueForm && valueForm != null) {
                relay.oldObject = valueForm.cast((Item)relay.oldValue);
                if (relay.oldObject == null) {
                    relay.oldObject = valueForm.unit();
                }
            }
            return (V)relay.oldObject;
        }
        return null;
    }

    public void drop(MapDownlinkView<?, ?> view, int lower) {
        if (lower > 0) {
            this.pushUp((Value)Record.create((int)1).attr("drop", lower));
        }
    }

    public void take(MapDownlinkView<?, ?> view, int upper) {
        if (upper > 0) {
            this.pushUp((Value)Record.create((int)1).attr("take", upper));
        }
    }

    public void clear(MapDownlinkView<?, ?> view) {
        MapDownlinkRelayClear relay = new MapDownlinkRelayClear(this);
        relay.stage = view.stage;
        relay.run();
    }

    public OrderedMap<Value, Value> headMap(Value toKey) {
        return this.state.headMap((Object)toKey);
    }

    public OrderedMap<Value, Value> tailMap(Value fromKey) {
        return this.state.tailMap((Object)fromKey);
    }

    public OrderedMap<Value, Value> subMap(Value fromKey, Value toKey) {
        return this.state.subMap((Object)fromKey, (Object)toKey);
    }

    public Set<Map.Entry<Value, Value>> entrySet() {
        return this.state.entrySet();
    }

    public Set<Value> keySet() {
        return this.state.keySet();
    }

    public Collection<Value> values() {
        return this.state.values();
    }

    public OrderedMapCursor<Value, Value> iterator() {
        return this.state.iterator();
    }

    public Cursor<Value> keyIterator() {
        return this.state.keyIterator();
    }

    public Cursor<Value> valueIterator() {
        return this.state.valueIterator();
    }
}

