/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.runtime.downlink.DownlinkRelay;
import swim.runtime.downlink.MapDownlinkModel;
import swim.runtime.downlink.MapDownlinkView;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.EventMessage;

final class MapDownlinkRelayTake
extends DownlinkRelay<MapDownlinkModel, MapDownlinkView<?, ?>> {
    final EventMessage message;
    final int upper;

    MapDownlinkRelayTake(MapDownlinkModel model, EventMessage message, int upper) {
        super(model, 4);
        this.message = message;
        this.upper = upper;
    }

    MapDownlinkRelayTake(MapDownlinkModel model, int upper) {
        super(model, 1, 3);
        this.message = null;
        this.upper = upper;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2 && ((MapDownlinkModel)this.model).isStateful()) {
            ((MapDownlinkModel)this.model).state.take(this.upper);
        }
    }

    @Override
    boolean runPhase(MapDownlinkView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                view.downlinkWillTake(this.upper);
            }
            return view.dispatchWillTake(this.upper, preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.downlinkDidTake(this.upper);
            }
            return view.dispatchDidTake(this.upper, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.message != null) {
            ((MapDownlinkModel)this.model).cueDown();
        } else {
            ((MapDownlinkModel)this.model).pushUp((Value)Record.create((int)1).attr("take", this.upper));
        }
    }
}

