/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.runtime.lane.LaneRelay;
import swim.runtime.lane.ListLaneModel;
import swim.runtime.lane.ListLaneView;
import swim.runtime.uplink.ListOperation;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class ListLaneRelayRemove
extends LaneRelay<ListLaneModel, ListLaneView<?>> {
    final Link link;
    final CommandMessage message;
    final int index;
    final Object key;
    Form<Object> valueForm;
    Value oldValue;
    Object oldObject;

    ListLaneRelayRemove(ListLaneModel model, Link link, CommandMessage message, int index, Object key) {
        super(model, 4);
        this.link = link;
        this.message = message;
        this.index = index;
        this.key = key;
    }

    ListLaneRelayRemove(ListLaneModel model, Link link, int index, Object key) {
        super(model, 1, 3);
        this.link = link;
        this.message = null;
        this.index = index;
        this.key = key;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            this.oldValue = (Value)((ListLaneModel)this.model).data.remove(this.index, this.key);
            if (this.valueForm != null && this.oldValue != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    boolean runPhase(ListLaneView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneWillRemove(this.index);
            }
            return view.dispatchWillRemove(this.link, this.index, preemptive);
        }
        if (phase == 2) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidRemove(this.index, this.oldObject);
            }
            return view.dispatchDidRemove(this.link, this.index, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        Record header = Record.create((int)2).slot("key", Value.fromObject((Object)this.key)).slot("index", this.index);
        ((ListLaneModel)this.model).cueDownKey((Value)header, ListOperation.REMOVE);
    }
}

