/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import swim.codec.Binary;
import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.security.DerDecoder;

final class DerIntegerDecoder<V>
extends Decoder<V> {
    final DerDecoder<V> der;
    final Decoder<byte[]> data;
    final int remaining;
    final int step;

    DerIntegerDecoder(DerDecoder<V> der, Decoder<byte[]> data, int remaining, int step) {
        this.der = der;
        this.data = data;
        this.remaining = remaining;
        this.step = step;
    }

    static <V> Decoder<V> decode(InputBuffer input, DerDecoder<V> der, Decoder<byte[]> data, int remaining, int step) {
        int b;
        if (step == 1 && input.isCont()) {
            b = input.head();
            input = input.step();
            if (b < 128) {
                remaining = b;
                step = 5;
            } else {
                step = 5 - (b & 0x7F);
                if (step < 2) {
                    return DerIntegerDecoder.error((Throwable)new DecoderException("length overflow"));
                }
                if (step > 4) {
                    return DerIntegerDecoder.error((Throwable)new DecoderException("length underflow"));
                }
            }
        }
        while (step >= 2 && step <= 4 && input.isCont()) {
            b = input.head();
            input = input.step();
            remaining = remaining << 8 | b;
            ++step;
        }
        if (step == 5) {
            int inputStart = input.index();
            int inputLimit = input.limit();
            int inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            boolean inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            data = data == null ? Binary.parseOutput((Output)Binary.byteArrayOutput((int)remaining), (Input)input) : data.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (data.isDone()) {
                return DerIntegerDecoder.done(der.integer((byte[])data.bind()));
            }
            if (data.isError()) {
                return data.asError();
            }
        }
        if (input.isDone()) {
            return DerIntegerDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return DerIntegerDecoder.error((Throwable)input.trap());
        }
        return new DerIntegerDecoder<V>(der, (Decoder<byte[]>)data, remaining, step);
    }

    static <V> Decoder<V> decode(InputBuffer input, DerDecoder<V> der) {
        return DerIntegerDecoder.decode(input, der, null, 0, 1);
    }

    public Decoder<V> feed(InputBuffer input) {
        return DerIntegerDecoder.decode(input, this.der, this.data, this.remaining, this.step);
    }
}

