/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.security.DerDecoder;
import swim.util.Builder;

final class DerSequenceDecoder<V>
extends Decoder<V> {
    final DerDecoder<V> der;
    final Builder<V, V> sequence;
    final Decoder<V> element;
    final int remaining;
    final int step;

    DerSequenceDecoder(DerDecoder<V> der, Builder<V, V> sequence, Decoder<V> element, int remaining, int step) {
        this.der = der;
        this.sequence = sequence;
        this.element = element;
        this.remaining = remaining;
        this.step = step;
    }

    static <V> Decoder<V> decode(InputBuffer input, DerDecoder<V> der, Builder<V, V> sequence, Decoder<V> element, int remaining, int step) {
        int b;
        if (step == 1 && input.isCont()) {
            b = input.head();
            input = input.step();
            if (b < 128) {
                remaining = b;
                step = 5;
            } else {
                step = 5 - (b & 0x7F);
                if (step < 2) {
                    return DerSequenceDecoder.error((Throwable)new DecoderException("length overflow"));
                }
                if (step > 4) {
                    return DerSequenceDecoder.error((Throwable)new DecoderException("length underflow"));
                }
            }
        }
        while (step >= 2 && step <= 4 && input.isCont()) {
            b = input.head();
            input = input.step();
            remaining = remaining << 8 | b;
            ++step;
        }
        while (step == 5 && remaining > 0 && input.isCont()) {
            int inputStart = input.index();
            int inputLimit = input.limit();
            int inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            boolean inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            element = element == null ? der.decodeValue(input) : element.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (element.isDone()) {
                if (sequence == null) {
                    sequence = der.sequenceBuilder();
                }
                sequence.add(element.bind());
                element = null;
                if (remaining != 0) continue;
                step = 6;
                break;
            }
            if (!element.isError()) continue;
            return element.asError();
        }
        if (step == 6 && remaining == 0) {
            return DerSequenceDecoder.done((Object)sequence.bind());
        }
        if (remaining < 0) {
            return DerSequenceDecoder.error((Throwable)new DecoderException("length too short"));
        }
        if (input.isDone()) {
            return DerSequenceDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return DerSequenceDecoder.error((Throwable)input.trap());
        }
        return new DerSequenceDecoder<V>(der, sequence, element, remaining, step);
    }

    static <V> Decoder<V> decode(InputBuffer input, DerDecoder<V> der) {
        return DerSequenceDecoder.decode(input, der, null, null, 0, 1);
    }

    public Decoder<V> feed(InputBuffer input) {
        return DerSequenceDecoder.decode(input, this.der, this.sequence, this.element, this.remaining, this.step);
    }
}

