/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.util.Iterator;
import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.security.DerEncoder;

final class DerSequenceEncoder<V>
extends Encoder<Object, Object> {
    final int tag;
    final int length;
    final Iterator<V> elements;
    final Encoder<?, ?> element;
    final int offset;
    final int step;
    DerEncoder<V> der;

    DerSequenceEncoder(DerEncoder<V> der, int tag, int length, Iterator<V> elements, Encoder<?, ?> element, int offset, int step) {
        this.der = der;
        this.tag = tag;
        this.length = length;
        this.elements = elements;
        this.element = element;
        this.offset = offset;
        this.step = step;
    }

    DerSequenceEncoder(DerEncoder<V> der, int tag, int length, Iterator<V> elements) {
        this(der, tag, length, elements, null, 0, 1);
    }

    static <V> Encoder<Object, Object> encode(OutputBuffer<?> output, DerEncoder<V> der, int tag, int length, Iterator<V> elements, Encoder<?, ?> element, int offset, int step) {
        if (step == 1 && output.isCont()) {
            output = output.write(tag);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            if (length < 128) {
                output = output.write(length);
                step = 7;
            } else if (length < 256) {
                output = output.write(129);
                step = 6;
            } else if (length < 65536) {
                output = output.write(130);
                step = 5;
            } else if (length < 0x1000000) {
                output = output.write(131);
                step = 4;
            } else {
                output = output.write(132);
                step = 3;
            }
        }
        if (step == 3 && output.isCont()) {
            output = output.write(length >> 24);
            step = 4;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(length >> 16);
            step = 5;
        }
        if (step == 5 && output.isCont()) {
            output = output.write(length >> 8);
            step = 6;
        }
        if (step == 6 && output.isCont()) {
            output = output.write(length);
            step = 7;
        }
        while (step == 7) {
            int outputStart = output.index();
            int outputLimit = output.limit();
            int outputRemaining = outputLimit - outputStart;
            int inputRemaining = length - offset;
            boolean outputPart = output.isPart();
            output = output.limit(outputStart + inputRemaining).isPart(inputRemaining > outputRemaining);
            if (element != null) {
                element = element.pull(output);
            } else if (elements.hasNext()) {
                element = der.encode(elements.next(), output);
            }
            output = output.limit(outputLimit).isPart(outputPart);
            offset += output.index() - outputStart;
            if (element.isDone()) {
                if (offset < length) {
                    if (elements.hasNext()) {
                        element = null;
                        continue;
                    }
                    return DerSequenceEncoder.error((Throwable)new EncoderException("buffer underflow"));
                }
                if (offset > length) {
                    return DerSequenceEncoder.error((Throwable)new EncoderException("buffer overflow"));
                }
                return DerSequenceEncoder.done();
            }
            if (!element.isError()) break;
            return element.asError();
        }
        if (output.isDone()) {
            return DerSequenceEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return DerSequenceEncoder.error((Throwable)output.trap());
        }
        return new DerSequenceEncoder<V>(der, tag, length, elements, element, offset, step);
    }

    static <V> Encoder<Object, Object> encode(OutputBuffer<?> output, DerEncoder<V> der, int tag, int length, Iterator<V> elements) {
        return DerSequenceEncoder.encode(output, der, tag, length, elements, null, 0, 1);
    }

    public Encoder<Object, Object> pull(OutputBuffer<?> output) {
        return DerSequenceEncoder.encode(output, this.der, this.tag, this.length, this.elements, this.element, this.offset, this.step);
    }
}

