/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.spec.EllipticCurve;
import swim.security.EcFieldDef;
import swim.security.EcForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class EcDef {
    private static int hashSeed;
    private static Form<EcDef> form;
    protected final String name;
    protected final EcFieldDef field;
    protected final BigInteger a;
    protected final BigInteger b;
    protected final byte[] seed;

    public EcDef(String name, EcFieldDef field, BigInteger a, BigInteger b, byte[] seed) {
        this.name = name;
        this.field = field;
        this.a = a;
        this.b = b;
        this.seed = seed;
    }

    public EcDef(EcFieldDef field, BigInteger a, BigInteger b, byte[] seed) {
        this(null, field, a, b, seed);
    }

    public EcDef(EcFieldDef field, BigInteger a, BigInteger b) {
        this(null, field, a, b, null);
    }

    public static EcDef from(EllipticCurve curve) {
        return new EcDef(EcFieldDef.from(curve.getField()), curve.getA(), curve.getB(), curve.getSeed());
    }

    @Kind
    public static Form<EcDef> form() {
        if (form == null) {
            form = new EcForm();
        }
        return form;
    }

    public final String name() {
        return this.name;
    }

    public final EcFieldDef field() {
        return this.field;
    }

    public final BigInteger a() {
        return this.a;
    }

    public final BigInteger b() {
        return this.b;
    }

    public EllipticCurve toEllipticCurve() {
        return new EllipticCurve(this.field.toECField(), this.a, this.b, this.seed);
    }

    public Value toValue() {
        return EcDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EcDef) {
            EcDef that = (EcDef)other;
            return this.field.equals(that.field) && this.a.equals(that.a) && this.b.equals(that.b);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(EcDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.field.hashCode()), (int)this.a.hashCode()), (int)this.b.hashCode()));
    }
}

