/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import swim.security.EcDef;
import swim.security.EcDomainForm;
import swim.security.EcPointDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Text;
import swim.structure.Value;

public class EcDomainDef {
    private static Form<EcDomainDef> form;
    protected final String name;
    protected final EcDef curve;
    protected final EcPointDef base;
    protected final BigInteger order;
    protected final int cofactor;
    protected ECParameterSpec params;

    EcDomainDef(String name, EcDef curve, EcPointDef base, BigInteger order, int cofactor, ECParameterSpec params) {
        this.name = name;
        this.curve = curve;
        this.base = base;
        this.order = order;
        this.cofactor = cofactor;
        this.params = params;
    }

    public EcDomainDef(String name, EcDef curve, EcPointDef base, BigInteger order, int cofactor) {
        this(name, curve, base, order, cofactor, null);
    }

    public EcDomainDef(EcDef curve, EcPointDef base, BigInteger order, int cofactor) {
        this(null, curve, base, order, cofactor, null);
    }

    public static EcDomainDef from(String name, ECParameterSpec params) {
        return new EcDomainDef(name, EcDef.from(params.getCurve()), EcPointDef.from(params.getGenerator()), params.getOrder(), params.getCofactor(), params);
    }

    public static EcDomainDef from(ECParameterSpec params) {
        return EcDomainDef.from(null, params);
    }

    public static EcDomainDef forName(String name) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            ECGenParameterSpec parameterSpec = new ECGenParameterSpec(name);
            keyPairGenerator.initialize(parameterSpec);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
            return EcDomainDef.from(name, publicKey.getParams());
        }
        catch (GeneralSecurityException cause) {
            return null;
        }
    }

    @Kind
    public static Form<EcDomainDef> form() {
        if (form == null) {
            form = new EcDomainForm();
        }
        return form;
    }

    public final String name() {
        return this.name;
    }

    public final EcDef curve() {
        return this.curve;
    }

    public final EcPointDef base() {
        return this.base;
    }

    public final BigInteger order() {
        return this.order;
    }

    public final int cofactor() {
        return this.cofactor;
    }

    public ECParameterSpec toECParameterSpec() {
        ECParameterSpec params = this.params;
        if (params == null) {
            this.params = params = new ECParameterSpec(this.curve.toEllipticCurve(), this.base.toECPoint(), this.order, this.cofactor);
        }
        return params;
    }

    public Value toValue() {
        if (this.name != null) {
            return Text.from((String)this.name);
        }
        return EcDomainDef.form().mold((Object)this).toValue();
    }
}

