/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import swim.security.EcCharacteristic2FieldDef;
import swim.security.EcFieldForm;
import swim.security.EcPrimeFieldDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;

public abstract class EcFieldDef {
    private static Form<EcFieldDef> form;

    public static EcFieldDef from(ECField field) {
        if (field instanceof ECFieldFp) {
            return EcPrimeFieldDef.from((ECFieldFp)field);
        }
        if (field instanceof ECFieldF2m) {
            return EcCharacteristic2FieldDef.from((ECFieldF2m)field);
        }
        throw new IllegalArgumentException(field.toString());
    }

    @Kind
    public static Form<EcFieldDef> form() {
        if (form == null) {
            form = new EcFieldForm();
        }
        return form;
    }

    public abstract ECField toECField();

    public abstract Value toValue();
}

