/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import swim.security.EcFieldDef;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Murmur3;

public class EcPrimeFieldDef
extends EcFieldDef {
    private static int hashSeed;
    protected final BigInteger prime;

    public EcPrimeFieldDef(BigInteger prime) {
        this.prime = prime;
    }

    public static EcPrimeFieldDef from(ECFieldFp field) {
        return new EcPrimeFieldDef(field.getP());
    }

    public final BigInteger prime() {
        return this.prime;
    }

    @Override
    public ECFieldFp toECField() {
        return new ECFieldFp(this.prime);
    }

    @Override
    public Value toValue() {
        return Record.create((int)2).attr("ECField").slot("prime", (Value)Num.from((BigInteger)this.prime));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EcPrimeFieldDef) {
            EcPrimeFieldDef that = (EcPrimeFieldDef)other;
            return this.prime.equals(that.prime);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(EcPrimeFieldDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.prime.hashCode()));
    }
}

