/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPublicKeySpec;
import swim.security.EcDomainDef;
import swim.security.EcKeyDef;
import swim.security.EcPointDef;
import swim.security.EcPublicKeyForm;
import swim.security.PublicKeyDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class EcPublicKeyDef
extends PublicKeyDef
implements EcKeyDef {
    private static int hashSeed;
    private static Form<EcPublicKeyDef> form;
    protected final EcDomainDef domain;
    protected final EcPointDef point;
    protected ECPublicKey publicKey;

    EcPublicKeyDef(EcDomainDef domain, EcPointDef point, ECPublicKey publicKey) {
        this.domain = domain;
        this.point = point;
        this.publicKey = publicKey;
    }

    public EcPublicKeyDef(EcDomainDef domain, EcPointDef point) {
        this(domain, point, null);
    }

    public static EcPublicKeyDef from(ECPublicKey key) {
        return new EcPublicKeyDef(EcDomainDef.from(key.getParams()), EcPointDef.from(key.getW()), key);
    }

    @Kind
    public static Form<EcPublicKeyDef> form() {
        if (form == null) {
            form = new EcPublicKeyForm();
        }
        return form;
    }

    @Override
    public final EcDomainDef domain() {
        return this.domain;
    }

    public final EcPointDef point() {
        return this.point;
    }

    @Override
    public ECPublicKey publicKey() {
        ECPublicKey publicKey = this.publicKey;
        if (publicKey == null) {
            try {
                ECPublicKeySpec keySpec = new ECPublicKeySpec(this.point.toECPoint(), this.domain.toECParameterSpec());
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                this.publicKey = publicKey = (ECPublicKey)keyFactory.generatePublic(keySpec);
            }
            catch (GeneralSecurityException cause) {
                throw new RuntimeException(cause);
            }
        }
        return publicKey;
    }

    @Override
    public Key key() {
        return this.publicKey();
    }

    @Override
    public Value toValue() {
        return EcPublicKeyDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EcPublicKeyDef) {
            EcPublicKeyDef that = (EcPublicKeyDef)other;
            return this.domain.equals(that.domain) && this.point.equals(that.point);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(EcPublicKeyDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.domain.hashCode()), (int)this.point.hashCode()));
    }
}

