/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import swim.security.PublicKeyDef;
import swim.security.RsaKeyDef;
import swim.security.RsaPublicKeyForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class RsaPublicKeyDef
extends PublicKeyDef
implements RsaKeyDef {
    private static int hashSeed;
    private static Form<RsaPublicKeyDef> form;
    protected final BigInteger modulus;
    protected final BigInteger publicExponent;
    protected RSAPublicKey publicKey;

    RsaPublicKeyDef(BigInteger modulus, BigInteger publicExponent, RSAPublicKey publicKey) {
        this.modulus = modulus;
        this.publicExponent = publicExponent;
        this.publicKey = publicKey;
    }

    public RsaPublicKeyDef(BigInteger modulus, BigInteger publicExponent) {
        this(modulus, publicExponent, null);
    }

    public static RsaPublicKeyDef from(RSAPublicKey key) {
        return new RsaPublicKeyDef(key.getModulus(), key.getPublicExponent(), key);
    }

    @Kind
    public static Form<RsaPublicKeyDef> form() {
        if (form == null) {
            form = new RsaPublicKeyForm();
        }
        return form;
    }

    @Override
    public final BigInteger modulus() {
        return this.modulus;
    }

    public final BigInteger publicExponent() {
        return this.publicExponent;
    }

    @Override
    public RSAPublicKey publicKey() {
        RSAPublicKey publicKey = this.publicKey;
        if (publicKey == null) {
            try {
                RSAPublicKeySpec keySpec = new RSAPublicKeySpec(this.modulus, this.publicExponent);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.publicKey = publicKey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
            }
            catch (GeneralSecurityException cause) {
                throw new RuntimeException(cause);
            }
        }
        return publicKey;
    }

    @Override
    public Key key() {
        return this.publicKey();
    }

    @Override
    public Value toValue() {
        return RsaPublicKeyDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RsaPublicKeyDef) {
            RsaPublicKeyDef that = (RsaPublicKeyDef)other;
            return this.modulus.equals(that.modulus) && this.publicExponent.equals(that.publicExponent);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(RsaPublicKeyDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.modulus.hashCode()), (int)this.publicExponent.hashCode()));
    }
}

