/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import javax.crypto.Mac;
import swim.codec.Base64;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Diagnostic;
import swim.codec.Format;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieSet;
import swim.json.Json;
import swim.security.Der;
import swim.security.JsonWebKey;
import swim.security.JsonWebSignatureParser;
import swim.security.JsonWebSignatureWriter;
import swim.structure.Data;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Murmur3;

public class JsonWebSignature
implements Debug {
    protected final Value unprotectedHeader;
    protected final Value protectedHeader;
    protected final Data signingInput;
    protected final Data payloadData;
    protected final Data signatureData;
    private static int hashSeed;

    public JsonWebSignature(Value unprotectedHeader, Value protectedHeader, Data signingInput, Data payloadData, Data signatureData) {
        this.unprotectedHeader = unprotectedHeader.commit();
        this.protectedHeader = protectedHeader.commit();
        this.signingInput = signingInput;
        this.payloadData = payloadData;
        this.signatureData = signatureData;
    }

    public final Value unprotectedHeader() {
        return this.unprotectedHeader;
    }

    public JsonWebSignature unprotectedHeader(Value unprotectedHeader) {
        return new JsonWebSignature(unprotectedHeader, this.protectedHeader, this.signingInput, this.payloadData, this.signatureData);
    }

    public final Value protectedHeader() {
        return this.protectedHeader;
    }

    public final Data signingInput() {
        return this.signingInput;
    }

    public final Data payloadData() {
        return this.payloadData;
    }

    public final <T> T payload(Decoder<T> decoder) {
        if ((decoder = decoder.feed(this.payloadData.toInputBuffer())).isDone()) {
            return (T)decoder.bind();
        }
        Throwable trap = decoder.trap();
        if (trap instanceof RuntimeException) {
            throw (RuntimeException)trap;
        }
        throw new RuntimeException(trap);
    }

    public final <T> T payload(Form<T> form) {
        return this.payload(Json.formDecoder(form));
    }

    public final Value payload() {
        return (Value)this.payload(Form.forValue());
    }

    public final Data signatureData() {
        return this.signatureData;
    }

    public Value get(String name) {
        Value value = this.protectedHeader.get(name);
        if (!value.isDefined()) {
            value = this.unprotectedHeader.get(name);
        }
        return value;
    }

    public String algorithm() {
        return this.get("alg").stringValue(null);
    }

    public String jsonWebKeySetUrl() {
        return this.get("jku").stringValue(null);
    }

    public JsonWebKey jsonWebKey() {
        return JsonWebKey.from(this.get("jwk"));
    }

    public String keyId() {
        return this.get("kid").stringValue(null);
    }

    public String x509Url() {
        return this.get("x5u").stringValue(null);
    }

    public FingerTrieSeq<String> x509CertificateChain() {
        FingerTrieSeq x509CertificateChain = FingerTrieSeq.empty();
        for (Item member : this.get("x5c")) {
            String x509Certificate = member.stringValue(null);
            if (x509Certificate == null) continue;
            x509CertificateChain = x509CertificateChain.appended((Object)x509Certificate);
        }
        return x509CertificateChain;
    }

    public String x509Sha1Thumbprint() {
        return this.get("x5t").stringValue(null);
    }

    public String x509Sha256Thumbprint() {
        return this.get("x5t#S256").stringValue(null);
    }

    public String type() {
        return this.get("typ").stringValue(null);
    }

    public String contentType() {
        return this.get("cty").stringValue(null);
    }

    public HashTrieSet<String> critical() {
        HashTrieSet critical = HashTrieSet.empty();
        for (Item member : this.get("crit")) {
            String name = member.stringValue(null);
            if (name == null) continue;
            critical = critical.added((Object)name);
        }
        return critical;
    }

    public boolean verifyMac(Key symmetricKey) {
        String algorithm = this.algorithm();
        try {
            if ("HS256".equals(algorithm)) {
                return this.verifyMac(Mac.getInstance("HmacSHA256"), symmetricKey);
            }
            if ("HS384".equals(algorithm)) {
                return this.verifyMac(Mac.getInstance("HmacSHA384"), symmetricKey);
            }
            if ("HS512".equals(algorithm)) {
                return this.verifyMac(Mac.getInstance("HmacSHA512"), symmetricKey);
            }
            return false;
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public boolean verifyMac(Mac mac, Key symmetricKey) {
        try {
            mac.init(symmetricKey);
            mac.update(this.signingInput.asByteBuffer());
            Data signatureData = Data.wrap((byte[])mac.doFinal());
            return JsonWebSignature.compareSignatureData(signatureData, this.signatureData);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public boolean verifySignature(PublicKey publicKey) {
        String algorithm = this.algorithm();
        try {
            if ("ES256".equals(algorithm)) {
                return this.verifyECDSASignature(Signature.getInstance("SHA256withECDSA"), publicKey);
            }
            if ("ES384".equals(algorithm)) {
                return this.verifyECDSASignature(Signature.getInstance("SHA384withECDSA"), publicKey);
            }
            if ("ES512".equals(algorithm)) {
                return this.verifyECDSASignature(Signature.getInstance("SHA512withECDSA"), publicKey);
            }
            if ("RS256".equals(algorithm)) {
                return this.verifyRSASignature(Signature.getInstance("SHA256withRSA"), publicKey);
            }
            if ("RS384".equals(algorithm)) {
                return this.verifyRSASignature(Signature.getInstance("SHA384withRSA"), publicKey);
            }
            if ("RS512".equals(algorithm)) {
                return this.verifyRSASignature(Signature.getInstance("SHA512withRSA"), publicKey);
            }
            return false;
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public boolean verifyRSASignature(Signature signature, PublicKey publicKey) {
        try {
            signature.initVerify(publicKey);
            signature.update(this.signingInput.asByteBuffer());
            return signature.verify(this.signatureData.asByteArray(), 0, this.signatureData.size());
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public boolean verifyECDSASignature(Signature signature, PublicKey publicKey) {
        Data signatureData = JsonWebSignature.derEncodeECDSASignature(this.signatureData);
        try {
            signature.initVerify(publicKey);
            signature.update(this.signingInput.asByteBuffer());
            return signature.verify(signatureData.asByteArray(), 0, signatureData.size());
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public Writer<?, JsonWebSignature> writeJws(Output<?> output) {
        return JsonWebSignatureWriter.write(output, this);
    }

    public String toJws() {
        Output output = Unicode.stringOutput();
        this.writeJws(output);
        return (String)output.bind();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof JsonWebSignature) {
            JsonWebSignature that = (JsonWebSignature)other;
            return this.unprotectedHeader.equals((Object)that.unprotectedHeader) && this.protectedHeader.equals((Object)that.protectedHeader) && this.signingInput.equals((Object)that.signingInput) && this.payloadData.equals((Object)that.payloadData) && this.signatureData.equals((Object)that.signatureData);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(JsonWebSignature.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.unprotectedHeader.hashCode()), (int)this.protectedHeader.hashCode()), (int)this.signingInput.hashCode()), (int)this.payloadData.hashCode()), (int)this.signatureData.hashCode()));
    }

    public void debug(Output<?> output) {
        output.write("JsonWebSignature").write(46).write("from").write(40).debug((Object)this.unprotectedHeader).write(", ").debug((Object)this.protectedHeader).write(", ").debug((Object)this.signingInput).write(", ").debug((Object)this.payloadData).write(", ").debug((Object)this.signatureData).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static JsonWebSignature from(Value unprotectedHeader, Data signingInput, Data protectedHeaderData, Data payloadData, Data signatureData) {
        Value protectedHeader = (Value)Json.modelParser().parseObject(Utf8.decodedInput((Input)protectedHeaderData.toInputBuffer())).bind();
        return new JsonWebSignature(unprotectedHeader, protectedHeader, signingInput, payloadData, signatureData);
    }

    public static JsonWebSignature from(Data signingInput, Data protectedHeaderData, Data payloadData, Data signatureData) {
        return JsonWebSignature.from(Value.absent(), signingInput, protectedHeaderData, payloadData, signatureData);
    }

    public static JsonWebSignature from(Value unprotectedHeader, Data protectedHeaderData, Data payloadData, Data signatureData) {
        Output signingInput = Data.output();
        Base64.urlUnpadded().writeByteBuffer(protectedHeaderData.asByteBuffer(), signingInput);
        signingInput.write(46);
        Base64.urlUnpadded().writeByteBuffer(payloadData.asByteBuffer(), signingInput);
        return JsonWebSignature.from(unprotectedHeader, (Data)signingInput.bind(), protectedHeaderData, payloadData, signatureData);
    }

    public static JsonWebSignature from(Data protectedHeaderData, Data payloadData, Data signatureData) {
        return JsonWebSignature.from(Value.absent(), protectedHeaderData, payloadData, signatureData);
    }

    public static JsonWebSignature hmacSHA(Mac mac, Key symmetricKey, Value unprotectedHeader, Value protectedHeader, Data signingInput, Data payloadData) {
        try {
            mac.init(symmetricKey);
            mac.update(signingInput.asByteBuffer());
            Data signatureData = Data.wrap((byte[])mac.doFinal());
            return new JsonWebSignature(unprotectedHeader, protectedHeader, signingInput, payloadData, signatureData);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static JsonWebSignature hmacSHA(Mac mac, Key symmetricKey, Value unprotectedHeader, Value protectedHeader, Data payloadData) {
        Data protectedHeaderData = Json.toData((Item)protectedHeader);
        Output signingInput = Data.output();
        Base64.urlUnpadded().writeByteBuffer(protectedHeaderData.asByteBuffer(), signingInput);
        signingInput.write(46);
        Base64.urlUnpadded().writeByteBuffer(payloadData.asByteBuffer(), signingInput);
        return JsonWebSignature.hmacSHA(mac, symmetricKey, unprotectedHeader, protectedHeader, (Data)signingInput.bind(), payloadData);
    }

    public static JsonWebSignature hmacSHA(Key symmetricKey, Value unprotectedHeader, Value protectedHeader, Data payloadData) {
        String algorithm = symmetricKey.getAlgorithm();
        try {
            Mac mac;
            if ("HmacSHA256".equals(algorithm)) {
                protectedHeader = protectedHeader.updatedSlot("alg", "HS256");
                mac = Mac.getInstance("HmacSHA256");
            } else if ("HmacSHA384".equals(algorithm)) {
                protectedHeader = protectedHeader.updatedSlot("alg", "HS384");
                mac = Mac.getInstance("HmacSHA384");
            } else if ("HmacSHA512".equals(algorithm)) {
                protectedHeader = protectedHeader.updatedSlot("alg", "HS512");
                mac = Mac.getInstance("HmacSHA512");
            } else {
                throw new IllegalArgumentException("unsupported key size");
            }
            return JsonWebSignature.hmacSHA(mac, symmetricKey, unprotectedHeader, protectedHeader, payloadData);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static JsonWebSignature mac(Key symmetricKey, Value unprotectedHeader, Value protectedHeader, Data payloadData) {
        return JsonWebSignature.hmacSHA(symmetricKey, unprotectedHeader, protectedHeader, payloadData);
    }

    public static JsonWebSignature mac(Key symmetricKey, Value protectedHeader, Data payloadData) {
        return JsonWebSignature.mac(symmetricKey, Value.absent(), protectedHeader, payloadData);
    }

    public static JsonWebSignature mac(Key symmetricKey, Data payloadData) {
        return JsonWebSignature.mac(symmetricKey, Value.absent(), Value.absent(), payloadData);
    }

    public static JsonWebSignature signRSA(Signature signature, PrivateKey privateKey, int keyLength, Value unprotectedHeader, Value protectedHeader, Data signingInput, Data payloadData) {
        try {
            signature.initSign(privateKey);
            signature.update(signingInput.asByteBuffer());
            Data signatureData = Data.wrap((byte[])signature.sign());
            return new JsonWebSignature(unprotectedHeader, protectedHeader, signingInput, payloadData, signatureData);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static JsonWebSignature signRSA(Signature signature, PrivateKey privateKey, int keyLength, Value unprotectedHeader, Value protectedHeader, Data payloadData) {
        Data protectedHeaderData = Json.toData((Item)protectedHeader);
        Output signingInput = Data.output();
        Base64.urlUnpadded().writeByteBuffer(protectedHeaderData.asByteBuffer(), signingInput);
        signingInput.write(46);
        Base64.urlUnpadded().writeByteBuffer(payloadData.asByteBuffer(), signingInput);
        return JsonWebSignature.signRSA(signature, privateKey, keyLength, unprotectedHeader, protectedHeader, (Data)signingInput.bind(), payloadData);
    }

    public static JsonWebSignature signRSA(PrivateKey privateKey, Value unprotectedHeader, Value protectedHeader, Data payloadData) {
        int keyLength = JsonWebSignature.rsaKeyLength(privateKey);
        try {
            Signature signature;
            if (keyLength == 32) {
                protectedHeader = protectedHeader.updatedSlot("alg", "RS256");
                signature = Signature.getInstance("SHA256withRSA");
            } else if (keyLength == 48) {
                protectedHeader = protectedHeader.updatedSlot("alg", "RS384");
                signature = Signature.getInstance("SHA384withRSA");
            } else if (keyLength == 64) {
                protectedHeader = protectedHeader.updatedSlot("alg", "RS512");
                signature = Signature.getInstance("SHA512withRSA");
            } else {
                throw new IllegalArgumentException("unsupported key size");
            }
            return JsonWebSignature.signRSA(signature, privateKey, keyLength, unprotectedHeader, protectedHeader, payloadData);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static JsonWebSignature signECDSA(Signature signature, PrivateKey privateKey, int keyLength, Value unprotectedHeader, Value protectedHeader, Data signingInput, Data payloadData) {
        try {
            signature.initSign(privateKey);
            signature.update(signingInput.asByteBuffer());
            Data signatureData = Data.wrap((byte[])signature.sign());
            signatureData = JsonWebSignature.derDecodeECDSASignature(signatureData, keyLength);
            return new JsonWebSignature(unprotectedHeader, protectedHeader, signingInput, payloadData, signatureData);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static JsonWebSignature signECDSA(Signature signature, PrivateKey privateKey, int keyLength, Value unprotectedHeader, Value protectedHeader, Data payloadData) {
        Data protectedHeaderData = Json.toData((Item)protectedHeader);
        Output signingInput = Data.output();
        Base64.urlUnpadded().writeByteBuffer(protectedHeaderData.asByteBuffer(), signingInput);
        signingInput.write(46);
        Base64.urlUnpadded().writeByteBuffer(payloadData.asByteBuffer(), signingInput);
        return JsonWebSignature.signECDSA(signature, privateKey, keyLength, unprotectedHeader, protectedHeader, (Data)signingInput.bind(), payloadData);
    }

    public static JsonWebSignature signECDSA(PrivateKey privateKey, Value unprotectedHeader, Value protectedHeader, Data payloadData) {
        int keyLength = JsonWebSignature.ecKeyLength(privateKey);
        try {
            Signature signature;
            if (keyLength == 32) {
                protectedHeader = protectedHeader.updatedSlot("alg", "ES256");
                signature = Signature.getInstance("SHA256withECDSA");
            } else if (keyLength == 48) {
                protectedHeader = protectedHeader.updatedSlot("alg", "ES384");
                signature = Signature.getInstance("SHA384withECDSA");
            } else if (keyLength == 66) {
                protectedHeader = protectedHeader.updatedSlot("alg", "ES512");
                signature = Signature.getInstance("SHA512withECDSA");
            } else {
                throw new IllegalArgumentException("unsupported key size");
            }
            return JsonWebSignature.signECDSA(signature, privateKey, keyLength, unprotectedHeader, protectedHeader, payloadData);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static JsonWebSignature sign(PrivateKey privateKey, Value unprotectedHeader, Value protectedHeader, Data payloadData) {
        if (privateKey instanceof ECKey) {
            return JsonWebSignature.signECDSA(privateKey, unprotectedHeader, protectedHeader, payloadData);
        }
        if (privateKey instanceof RSAKey) {
            return JsonWebSignature.signRSA(privateKey, unprotectedHeader, protectedHeader, payloadData);
        }
        throw new IllegalArgumentException("unsupported signing key type");
    }

    public static JsonWebSignature sign(PrivateKey privateKey, Value protectedHeader, Data payloadData) {
        return JsonWebSignature.sign(privateKey, Value.absent(), protectedHeader, payloadData);
    }

    public static JsonWebSignature sign(PrivateKey privateKey, Data payloadData) {
        return JsonWebSignature.sign(privateKey, Value.absent(), Value.absent(), payloadData);
    }

    public static Parser<JsonWebSignature> parser() {
        return new JsonWebSignatureParser();
    }

    public static JsonWebSignature parse(String jws) {
        Input input = Unicode.stringInput((String)jws);
        Parser parser = JsonWebSignatureParser.parse(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (JsonWebSignature)parser.bind();
    }

    static boolean compareSignatureData(Data actual, Data expected) {
        boolean matches = true;
        int n = Math.min(actual.size(), expected.size());
        for (int i = 0; i < n; ++i) {
            matches = actual.getByte(i) == expected.getByte(i) && matches;
        }
        return matches;
    }

    static int ecKeyLength(Key key) {
        int bitLength = ((ECKey)((Object)key)).getParams().getOrder().bitLength();
        if (bitLength <= 256) {
            return 32;
        }
        if (bitLength <= 384) {
            return 48;
        }
        if (bitLength <= 521) {
            return 66;
        }
        throw new IllegalArgumentException("unsupported key size");
    }

    static int rsaKeyLength(Key key) {
        int bitLength = ((RSAKey)((Object)key)).getModulus().bitLength();
        if (bitLength <= 2048) {
            return 32;
        }
        if (bitLength <= 3072) {
            return 48;
        }
        if (bitLength <= 4096) {
            return 64;
        }
        throw new IllegalArgumentException("unsupported key size");
    }

    static Data derDecodeECDSASignature(Data derData, int n) {
        Value sequence = (Value)Der.modelDecoder().decodeValue(derData.toInputBuffer()).bind();
        byte[] r = ((Num)sequence.getItem(0)).integerValue().toByteArray();
        byte[] s = ((Num)sequence.getItem(1)).integerValue().toByteArray();
        byte[] signatureBytes = new byte[n << 1];
        if (r.length <= n) {
            System.arraycopy(r, 0, signatureBytes, n - r.length, r.length);
        } else {
            System.arraycopy(r, r.length - n, signatureBytes, 0, n);
        }
        if (s.length <= n) {
            System.arraycopy(s, 0, signatureBytes, n + (n - s.length), s.length);
        } else {
            System.arraycopy(s, s.length - n, signatureBytes, n, n);
        }
        return Data.wrap((byte[])signatureBytes);
    }

    static Data derEncodeECDSASignature(Data signatureData) {
        int n = signatureData.size() >>> 1;
        byte[] signature = signatureData.asByteArray();
        byte[] magnitude = new byte[n];
        System.arraycopy(signature, 0, magnitude, 0, n);
        Num r = Num.from((BigInteger)new BigInteger(1, magnitude));
        System.arraycopy(signature, n, magnitude, 0, n);
        Num s = Num.from((BigInteger)new BigInteger(1, magnitude));
        Record sequence = Record.of((Object[])new Object[]{r, s});
        byte[] derBytes = new byte[Der.modelEncoder().sizeOf((Value)sequence)];
        Der.modelEncoder().encode((Value)sequence, Binary.outputBuffer((byte[])derBytes));
        return Data.wrap((byte[])derBytes);
    }
}

