/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.security.DerDecoder;

final class DerValueDecoder<V>
extends Decoder<V> {
    final DerDecoder<V> der;

    DerValueDecoder(DerDecoder<V> der) {
        this.der = der;
    }

    public Decoder<V> feed(InputBuffer input) {
        return DerValueDecoder.decode(input, this.der);
    }

    static <V> Decoder<V> decode(InputBuffer input, DerDecoder<V> der) {
        if (input.isCont()) {
            int tag = input.head();
            input = input.step();
            switch (tag) {
                case 2: {
                    return der.decodeInteger(input);
                }
                case 48: {
                    return der.decodeSequence(input);
                }
            }
            return DerValueDecoder.error((Throwable)new DecoderException("Unsupported DER tag: 0x" + Integer.toHexString(tag)));
        }
        if (input.isDone()) {
            return DerValueDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return DerValueDecoder.error((Throwable)input.trap());
        }
        return new DerValueDecoder<V>(der);
    }
}

