/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.spec.ECFieldF2m;
import swim.security.EcFieldDef;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Murmur3;

public class EcCharacteristic2FieldDef
extends EcFieldDef {
    protected final int size;
    protected final BigInteger basis;
    private static int hashSeed;

    public EcCharacteristic2FieldDef(int size, BigInteger basis) {
        this.size = size;
        this.basis = basis;
    }

    public final int size() {
        return this.size;
    }

    public final BigInteger basis() {
        return this.basis;
    }

    @Override
    public ECFieldF2m toECField() {
        if (this.basis != null) {
            return new ECFieldF2m(this.size, this.basis);
        }
        return new ECFieldF2m(this.size);
    }

    @Override
    public Value toValue() {
        return Record.create((int)2).attr("ECField", (Value)Record.create((int)1).slot("size", this.size)).slot("basis", (Value)Num.from((BigInteger)this.basis));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EcCharacteristic2FieldDef) {
            EcCharacteristic2FieldDef that = (EcCharacteristic2FieldDef)other;
            return this.size == that.size && this.basis.equals(that.basis);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(EcCharacteristic2FieldDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.size), (int)this.basis.hashCode()));
    }

    public static EcCharacteristic2FieldDef from(ECFieldF2m field) {
        return new EcCharacteristic2FieldDef(field.getM(), field.getReductionPolynomial());
    }
}

