/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import swim.security.EcPointDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;

final class EcPointForm
extends Form<EcPointDef> {
    EcPointForm() {
    }

    public String tag() {
        return "ECPoint";
    }

    public Class<?> type() {
        return EcPointDef.class;
    }

    public Item mold(EcPointDef pointDef) {
        Record header = Record.create((int)2).slot("x", (Value)Num.from((BigInteger)pointDef.x)).slot("y", (Value)Num.from((BigInteger)pointDef.y));
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    public EcPointDef cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            BigInteger x = header.get("x").integerValue(null);
            BigInteger y = header.get("y").integerValue(null);
            if (x != null && y != null) {
                return new EcPointDef(x, y);
            }
        }
        return null;
    }
}

