/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import swim.json.Json;
import swim.security.JsonWebSignature;
import swim.security.OpenIdToken;
import swim.security.PublicKeyDef;
import swim.structure.Data;
import swim.structure.Value;

public class GoogleIdToken
extends OpenIdToken {
    public GoogleIdToken(Value value) {
        super(value);
    }

    public GoogleIdToken() {
    }

    @Override
    public GoogleIdToken issuer(String issuer) {
        return (GoogleIdToken)super.issuer(issuer);
    }

    @Override
    public GoogleIdToken subject(String subject) {
        return (GoogleIdToken)super.subject(subject);
    }

    @Override
    public GoogleIdToken audience(String audience) {
        return (GoogleIdToken)super.audience(audience);
    }

    @Override
    public GoogleIdToken audiences(String ... audiences) {
        return (GoogleIdToken)super.audiences(audiences);
    }

    @Override
    public GoogleIdToken expiration(long expiration) {
        return (GoogleIdToken)super.expiration(expiration);
    }

    @Override
    public GoogleIdToken notBefore(long notBefore) {
        return (GoogleIdToken)super.notBefore(notBefore);
    }

    @Override
    public GoogleIdToken issuedAt(long issuedAt) {
        return (GoogleIdToken)super.issuedAt(issuedAt);
    }

    @Override
    public GoogleIdToken jwtId(String jwtId) {
        return (GoogleIdToken)super.jwtId(jwtId);
    }

    @Override
    public GoogleIdToken authTime(long authTime) {
        return (GoogleIdToken)super.authTime(authTime);
    }

    @Override
    public GoogleIdToken nonce(String nonce) {
        return (GoogleIdToken)super.nonce(nonce);
    }

    @Override
    public GoogleIdToken accessTokenHash(Data accessTokenHash) {
        return (GoogleIdToken)super.accessTokenHash(accessTokenHash);
    }

    @Override
    public GoogleIdToken authenticationContextClass(String authenticationContextClass) {
        return (GoogleIdToken)super.authenticationContextClass(authenticationContextClass);
    }

    @Override
    public GoogleIdToken authenticationMethods(String ... authenticationMethods) {
        return (GoogleIdToken)super.authenticationMethods(authenticationMethods);
    }

    @Override
    public GoogleIdToken authorizedParty(String authorizedParty) {
        return (GoogleIdToken)super.authorizedParty(authorizedParty);
    }

    public String hostedDomain() {
        return this.value.get("hd").stringValue();
    }

    public GoogleIdToken hostedDomain(String hostedDomain) {
        return this.copy((Value)this.value.updatedSlot("hd", hostedDomain));
    }

    public String email() {
        return this.value.get("email").stringValue();
    }

    public GoogleIdToken email(String email) {
        return this.copy((Value)this.value.updatedSlot("email", email));
    }

    public boolean emailVerified() {
        return this.value.get("email_verified").booleanValue(false);
    }

    public GoogleIdToken emailVerified(boolean emailVerified) {
        return this.copy((Value)this.value.updatedSlot("email_verified", emailVerified));
    }

    public String name() {
        return this.value.get("name").stringValue();
    }

    public GoogleIdToken name(String name) {
        return this.copy((Value)this.value.updatedSlot("name", name));
    }

    public String picture() {
        return this.value.get("picture").stringValue();
    }

    public GoogleIdToken picture(String picture) {
        return this.copy((Value)this.value.updatedSlot("picture", picture));
    }

    public String givenName() {
        return this.value.get("given_name").stringValue();
    }

    public GoogleIdToken givenName(String givenName) {
        return this.copy((Value)this.value.updatedSlot("given_name", givenName));
    }

    public String familyName() {
        return this.value.get("family_name").stringValue();
    }

    public GoogleIdToken familyName(String familyName) {
        return this.copy((Value)this.value.updatedSlot("family_name", familyName));
    }

    public String locale() {
        return this.value.get("locale").stringValue();
    }

    public GoogleIdToken locale(String locale) {
        return this.copy((Value)this.value.updatedSlot("locale", locale));
    }

    @Override
    protected GoogleIdToken copy(Value value) {
        return new GoogleIdToken(value);
    }

    public static GoogleIdToken from(Value value) {
        return new GoogleIdToken(value);
    }

    public static GoogleIdToken parse(String json) {
        return new GoogleIdToken(Json.parse((String)json));
    }

    public static GoogleIdToken verify(JsonWebSignature jws, Iterable<PublicKeyDef> publicKeyDefs) {
        Value payload = jws.payload();
        GoogleIdToken idToken = new GoogleIdToken(payload);
        for (PublicKeyDef publicKeyDef : publicKeyDefs) {
            if (!jws.verifySignature(publicKeyDef.publicKey())) continue;
            return idToken;
        }
        return null;
    }

    public static GoogleIdToken verify(String compactJws, Iterable<PublicKeyDef> publicKeyDefs) {
        JsonWebSignature jws = JsonWebSignature.parse(compactJws);
        if (jws != null) {
            return GoogleIdToken.verify(jws, publicKeyDefs);
        }
        return null;
    }
}

