/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.security.JsonWebSignature;
import swim.structure.Data;

final class JsonWebSignatureParser
extends Parser<JsonWebSignature> {
    final Data signingInput;
    final Data protectedHeaderData;
    final Data payloadData;
    final Data signatureData;
    final int p;
    final int q;
    final int r;
    final int step;

    JsonWebSignatureParser(Data signingInput, Data protectedHeaderData, Data payloadData, Data signatureData, int p, int q, int r, int step) {
        this.signingInput = signingInput;
        this.protectedHeaderData = protectedHeaderData;
        this.payloadData = payloadData;
        this.signatureData = signatureData;
        this.p = p;
        this.q = q;
        this.r = r;
        this.step = step;
    }

    JsonWebSignatureParser() {
        this(null, null, null, null, 0, 0, 0, 1);
    }

    public Parser<JsonWebSignature> feed(Input input) {
        return JsonWebSignatureParser.parse(this.signingInput, this.protectedHeaderData, this.payloadData, this.signatureData, this.p, this.q, this.r, this.step, input);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Parser<JsonWebSignature> parse(Data signingInput, Data protectedHeaderData, Data payloadData, Data signatureData, int p, int q, int r, int step, Input input) {
        block60: {
            int c;
            block58: {
                block59: {
                    block56: {
                        block57: {
                            if (signingInput == null) {
                                signingInput = Data.create();
                            }
                            if (protectedHeaderData == null) {
                                protectedHeaderData = Data.create();
                            }
                            if (payloadData == null) {
                                payloadData = Data.create();
                            }
                            if (signatureData == null) {
                                signatureData = Data.create();
                            }
                            while (true) {
                                block63: {
                                    block64: {
                                        block61: {
                                            block62: {
                                                if (step != 1) break block61;
                                                if (!input.isCont()) break block62;
                                                c = input.head();
                                                if (JsonWebSignatureParser.isBase64Char(c)) {
                                                    input = input.step();
                                                    signingInput.addByte((byte)c);
                                                    p = c;
                                                    step = 2;
                                                    break block61;
                                                } else {
                                                    step = 5;
                                                    break block56;
                                                }
                                            }
                                            if (input.isDone()) {
                                                return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                                            }
                                        }
                                        if (step == 2) {
                                            if (input.isCont()) {
                                                c = input.head();
                                                if (!JsonWebSignatureParser.isBase64Char(c)) {
                                                    return JsonWebSignatureParser.error((Diagnostic)Diagnostic.expected((String)"base64 digit", (Input)input));
                                                }
                                                input = input.step();
                                                signingInput.addByte((byte)c);
                                                q = c;
                                                step = 3;
                                            } else if (input.isDone()) {
                                                return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                                            }
                                        }
                                        if (step != 3) break block63;
                                        if (!input.isCont()) break block64;
                                        c = input.head();
                                        if (JsonWebSignatureParser.isBase64Char(c)) {
                                            input = input.step();
                                            signingInput.addByte((byte)c);
                                            r = c;
                                            step = 4;
                                            break block63;
                                        } else {
                                            JsonWebSignatureParser.decodeBase64Quantum(p, q, 61, 61, protectedHeaderData);
                                            step = 5;
                                            break block56;
                                        }
                                    }
                                    if (input.isDone()) {
                                        return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                                    }
                                }
                                if (step != 4) break block56;
                                if (!input.isCont()) break block57;
                                c = input.head();
                                if (!JsonWebSignatureParser.isBase64Char(c)) break;
                                input = input.step();
                                signingInput.addByte((byte)c);
                                JsonWebSignatureParser.decodeBase64Quantum(p, q, r, c, protectedHeaderData);
                                step = 1;
                            }
                            JsonWebSignatureParser.decodeBase64Quantum(p, q, r, 61, protectedHeaderData);
                            step = 5;
                            break block56;
                        }
                        if (input.isDone()) {
                            return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                        }
                    }
                    if (step == 5) {
                        if (input.isCont()) {
                            c = input.head();
                            if (c != 46) {
                                return JsonWebSignatureParser.error((Diagnostic)Diagnostic.expected((int)46, (Input)input));
                            }
                            input = input.step();
                            signingInput.addByte((byte)c);
                            step = 6;
                        } else if (input.isDone()) {
                            return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                        }
                    }
                    while (true) {
                        block67: {
                            block68: {
                                block65: {
                                    block66: {
                                        if (step != 6) break block65;
                                        if (!input.isCont()) break block66;
                                        c = input.head();
                                        if (JsonWebSignatureParser.isBase64Char(c)) {
                                            input = input.step();
                                            signingInput.addByte((byte)c);
                                            p = c;
                                            step = 7;
                                            break block65;
                                        } else {
                                            step = 10;
                                            break block58;
                                        }
                                    }
                                    if (input.isDone()) {
                                        return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                                    }
                                }
                                if (step == 7) {
                                    if (input.isCont()) {
                                        c = input.head();
                                        if (!JsonWebSignatureParser.isBase64Char(c)) {
                                            return JsonWebSignatureParser.error((Diagnostic)Diagnostic.expected((String)"base64 digit", (Input)input));
                                        }
                                        input = input.step();
                                        signingInput.addByte((byte)c);
                                        q = c;
                                        step = 8;
                                    } else if (input.isDone()) {
                                        return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                                    }
                                }
                                if (step != 8) break block67;
                                if (!input.isCont()) break block68;
                                c = input.head();
                                if (JsonWebSignatureParser.isBase64Char(c)) {
                                    input = input.step();
                                    signingInput.addByte((byte)c);
                                    r = c;
                                    step = 9;
                                    break block67;
                                } else {
                                    JsonWebSignatureParser.decodeBase64Quantum(p, q, 61, 61, payloadData);
                                    step = 10;
                                    break block58;
                                }
                            }
                            if (input.isDone()) {
                                return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                            }
                        }
                        if (step != 9) break block58;
                        if (!input.isCont()) break block59;
                        c = input.head();
                        if (!JsonWebSignatureParser.isBase64Char(c)) break;
                        input = input.step();
                        signingInput.addByte((byte)c);
                        JsonWebSignatureParser.decodeBase64Quantum(p, q, r, c, payloadData);
                        step = 6;
                    }
                    JsonWebSignatureParser.decodeBase64Quantum(p, q, r, 61, payloadData);
                    step = 10;
                    break block58;
                }
                if (input.isDone()) {
                    return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                }
            }
            if (step == 10) {
                if (!input.isCont()) {
                    return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                }
                c = input.head();
                if (c != 46) {
                    return JsonWebSignatureParser.error((Diagnostic)Diagnostic.expected((int)46, (Input)input));
                }
                input = input.step();
                step = 11;
            }
            while (true) {
                if (step == 11) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!JsonWebSignatureParser.isBase64Char(c)) {
                            return JsonWebSignatureParser.done((Object)JsonWebSignature.from(signingInput, protectedHeaderData, payloadData, signatureData));
                        }
                        input = input.step();
                        p = c;
                        step = 12;
                    } else if (input.isDone()) {
                        return JsonWebSignatureParser.done((Object)JsonWebSignature.from(signingInput, protectedHeaderData, payloadData, signatureData));
                    }
                }
                if (step == 12) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!JsonWebSignatureParser.isBase64Char(c)) {
                            return JsonWebSignatureParser.error((Diagnostic)Diagnostic.expected((String)"base64 digit", (Input)input));
                        }
                        input = input.step();
                        q = c;
                        step = 13;
                    } else if (input.isDone()) {
                        return JsonWebSignatureParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step == 13) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!JsonWebSignatureParser.isBase64Char(c)) {
                            JsonWebSignatureParser.decodeBase64Quantum(p, q, 61, 61, signatureData);
                            return JsonWebSignatureParser.done((Object)JsonWebSignature.from(signingInput, protectedHeaderData, payloadData, signatureData));
                        }
                        input = input.step();
                        r = c;
                        step = 14;
                    } else if (input.isDone()) {
                        JsonWebSignatureParser.decodeBase64Quantum(p, q, 61, 61, signatureData);
                        return JsonWebSignatureParser.done((Object)JsonWebSignature.from(signingInput, protectedHeaderData, payloadData, signatureData));
                    }
                }
                if (step != 14) break block60;
                if (!input.isCont()) break;
                c = input.head();
                if (!JsonWebSignatureParser.isBase64Char(c)) {
                    JsonWebSignatureParser.decodeBase64Quantum(p, q, r, 61, signatureData);
                    return JsonWebSignatureParser.done((Object)JsonWebSignature.from(signingInput, protectedHeaderData, payloadData, signatureData));
                }
                input = input.step();
                JsonWebSignatureParser.decodeBase64Quantum(p, q, r, c, signatureData);
                step = 11;
            }
            if (input.isDone()) {
                JsonWebSignatureParser.decodeBase64Quantum(p, q, r, 61, signatureData);
                return JsonWebSignatureParser.done((Object)JsonWebSignature.from(signingInput, protectedHeaderData, payloadData, signatureData));
            }
        }
        return new JsonWebSignatureParser(signingInput, protectedHeaderData, payloadData, signatureData, p, q, r, step);
    }

    static Parser<JsonWebSignature> parse(Input input) {
        return JsonWebSignatureParser.parse(null, null, null, null, 0, 0, 0, 1, input);
    }

    static boolean isBase64Char(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 45 || c == 95;
    }

    static int decodeBase64Digit(int c) {
        if (c >= 65 && c <= 90) {
            return c - 65;
        }
        if (c >= 97 && c <= 122) {
            return c + -71;
        }
        if (c >= 48 && c <= 57) {
            return c + 4;
        }
        if (c == 45) {
            return 62;
        }
        if (c == 95) {
            return 63;
        }
        String message = new StringBuilder("invalid base64 digit: ").appendCodePoint(c).toString();
        throw new IllegalArgumentException(message);
    }

    static void decodeBase64Quantum(int p, int q, int r, int s, Data data) {
        int x = JsonWebSignatureParser.decodeBase64Digit(p);
        int y = JsonWebSignatureParser.decodeBase64Digit(q);
        if (r != 61) {
            int z = JsonWebSignatureParser.decodeBase64Digit(r);
            if (s != 61) {
                int w = JsonWebSignatureParser.decodeBase64Digit(s);
                data.addByte((byte)(x << 2 | y >>> 4));
                data.addByte((byte)(y << 4 | z >>> 2));
                data.addByte((byte)(z << 6 | w));
            } else {
                data.addByte((byte)(x << 2 | y >>> 4));
                data.addByte((byte)(y << 4 | z >>> 2));
            }
        } else {
            if (s != 61) {
                throw new IllegalArgumentException("expected '='");
            }
            data.addByte((byte)(x << 2 | y >>> 4));
        }
    }
}

