/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.security.Key;
import java.security.PrivateKey;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.json.Json;
import swim.security.JsonWebSignature;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.Murmur3;

public class JsonWebToken
implements Debug {
    protected final Value value;
    private static int hashSeed;

    public JsonWebToken(Value value) {
        this.value = value.commit();
    }

    public JsonWebToken() {
        this(Value.absent());
    }

    public Value get(String name) {
        return this.value.get(name);
    }

    public String issuer() {
        return this.value.get("iss").stringValue(null);
    }

    public JsonWebToken issuer(String issuer) {
        return this.copy((Value)this.value.updatedSlot("iss", issuer));
    }

    public String subject() {
        return this.value.get("sub").stringValue(null);
    }

    public JsonWebToken subject(String subject) {
        return this.copy((Value)this.value.updatedSlot("sub", subject));
    }

    public String audience() {
        return this.value.get("aud").stringValue(null);
    }

    public JsonWebToken audience(String audience) {
        return this.copy((Value)this.value.updatedSlot("aud", audience));
    }

    public FingerTrieSeq<String> audiences() {
        Builder builder = FingerTrieSeq.builder();
        for (Item member : this.value.get("aud")) {
            String audience = member.stringValue(null);
            if (audience == null) continue;
            builder.add((Object)audience);
        }
        return (FingerTrieSeq)builder.bind();
    }

    public JsonWebToken audiences(String ... audiences) {
        return this.copy((Value)this.value.updatedSlot("aud", (Value)Record.of((Object[])audiences)));
    }

    public long expiration() {
        return this.value.get("exp").longValue(Long.MAX_VALUE);
    }

    public JsonWebToken expiration(long expiration) {
        return this.copy((Value)this.value.updatedSlot("exp", expiration));
    }

    public long notBefore() {
        return this.value.get("nbf").longValue(0L);
    }

    public JsonWebToken notBefore(long notBefore) {
        return this.copy((Value)this.value.updatedSlot("nbf", notBefore));
    }

    public long issuedAt() {
        return this.value.get("iat").longValue(0L);
    }

    public JsonWebToken issuedAt(long issuedAt) {
        return this.copy((Value)this.value.updatedSlot("iat", issuedAt));
    }

    public String jwtId() {
        return this.value.get("jti").stringValue(null);
    }

    public JsonWebToken jwtId(String jwtId) {
        return this.copy((Value)this.value.updatedSlot("jti", jwtId));
    }

    public Record joseHeader() {
        return Record.of((Object)Slot.of((String)"typ", (String)"JWT"));
    }

    public JsonWebSignature mac(Key symmetricKey) {
        return JsonWebSignature.mac(symmetricKey, (Value)this.joseHeader(), Json.toData((Item)this.value));
    }

    public JsonWebSignature sign(PrivateKey privateKey) {
        return JsonWebSignature.sign(privateKey, (Value)this.joseHeader(), Json.toData((Item)this.value));
    }

    public final Value toValue() {
        return this.value;
    }

    protected JsonWebToken copy(Value value) {
        return new JsonWebToken(value);
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonWebToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof JsonWebToken) {
            JsonWebToken that = (JsonWebToken)other;
            return that.canEqual(this) && this.value.equals((Object)that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(JsonWebToken.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.value.hashCode()));
    }

    public void debug(Output<?> output) {
        output.write(this.getClass().getSimpleName()).write(46).write("from").write(40).debug((Object)this.value).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static JsonWebToken from(Value value) {
        return new JsonWebToken(value);
    }

    public static JsonWebToken parse(String json) {
        return new JsonWebToken(Json.parse((String)json));
    }
}

