/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import swim.security.EcPublicKeyDef;
import swim.security.KeyDef;
import swim.security.PublicKeyForm;
import swim.security.RsaPublicKeyDef;
import swim.structure.Form;
import swim.structure.Kind;

public abstract class PublicKeyDef
extends KeyDef {
    private static Form<PublicKeyDef> publicKeyForm;

    public abstract PublicKey publicKey();

    public static PublicKeyDef from(PublicKey key) {
        if (key instanceof ECPublicKey) {
            return EcPublicKeyDef.from((ECPublicKey)key);
        }
        if (key instanceof RSAPublicKey) {
            return RsaPublicKeyDef.from((RSAPublicKey)key);
        }
        throw new IllegalArgumentException(key.toString());
    }

    @Kind
    public static Form<PublicKeyDef> publicKeyForm() {
        if (publicKeyForm == null) {
            publicKeyForm = new PublicKeyForm();
        }
        return publicKeyForm;
    }
}

