/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import swim.collections.FingerTrieSeq;
import swim.security.PrivateKeyDef;
import swim.security.RsaKeyDef;
import swim.security.RsaPrimeDef;
import swim.security.RsaPrivateKeyForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class RsaPrivateKeyDef
extends PrivateKeyDef
implements RsaKeyDef {
    protected final BigInteger modulus;
    protected final BigInteger publicExponent;
    protected final BigInteger privateExponent;
    protected final FingerTrieSeq<RsaPrimeDef> primeDefs;
    protected RSAPrivateKey privateKey;
    private static int hashSeed;
    private static Form<RsaPrivateKeyDef> form;

    RsaPrivateKeyDef(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, FingerTrieSeq<RsaPrimeDef> primeDefs, RSAPrivateKey privateKey) {
        this.modulus = modulus;
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
        this.primeDefs = primeDefs;
        this.privateKey = privateKey;
    }

    public RsaPrivateKeyDef(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, FingerTrieSeq<RsaPrimeDef> primeDefs) {
        this(modulus, publicExponent, privateExponent, primeDefs, null);
    }

    public RsaPrivateKeyDef(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, RsaPrimeDef ... primeDefs) {
        this(modulus, publicExponent, privateExponent, (FingerTrieSeq<RsaPrimeDef>)FingerTrieSeq.of((Object[])primeDefs));
    }

    RsaPrivateKeyDef(BigInteger modulus, BigInteger privateExponent, RSAPrivateKey privateKey) {
        this(modulus, null, privateExponent, (FingerTrieSeq<RsaPrimeDef>)FingerTrieSeq.empty(), privateKey);
    }

    public RsaPrivateKeyDef(BigInteger modulus, BigInteger privateExponent) {
        this(modulus, null, privateExponent, (FingerTrieSeq<RsaPrimeDef>)FingerTrieSeq.empty());
    }

    @Override
    public final BigInteger modulus() {
        return this.modulus;
    }

    public final BigInteger publicExponent() {
        return this.publicExponent;
    }

    public final BigInteger privateExponent() {
        return this.privateExponent;
    }

    public final FingerTrieSeq<RsaPrimeDef> primeDefs() {
        return this.primeDefs;
    }

    @Override
    public RSAPrivateKey privateKey() {
        RSAPrivateKey privateKey = this.privateKey;
        if (privateKey == null) {
            try {
                RSAPrivateKeySpec keySpec;
                int primeCount = this.primeDefs.size();
                if (primeCount < 2 || this.publicExponent == null) {
                    keySpec = new RSAPrivateKeySpec(this.modulus, this.privateExponent);
                } else {
                    RsaPrimeDef p = (RsaPrimeDef)this.primeDefs.get(0);
                    RsaPrimeDef q = (RsaPrimeDef)this.primeDefs.get(1);
                    if (primeCount == 2) {
                        keySpec = new RSAPrivateCrtKeySpec(this.modulus, this.publicExponent, this.privateExponent, p.factor, q.factor, p.exponent, q.exponent, q.coefficient);
                    } else {
                        RSAOtherPrimeInfo[] otherPrimes = new RSAOtherPrimeInfo[primeCount - 2];
                        for (int i = 2; i < primeCount; ++i) {
                            otherPrimes[i - 2] = ((RsaPrimeDef)this.primeDefs.get(i)).toRSAOtherPrimeInfo();
                        }
                        keySpec = new RSAMultiPrimePrivateCrtKeySpec(this.modulus, this.publicExponent, this.privateExponent, p.factor, q.factor, p.exponent, q.exponent, q.coefficient, otherPrimes);
                    }
                }
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.privateKey = privateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
            }
            catch (GeneralSecurityException cause) {
                throw new RuntimeException(cause);
            }
        }
        return privateKey;
    }

    @Override
    public Key key() {
        return this.privateKey();
    }

    @Override
    public Value toValue() {
        return RsaPrivateKeyDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RsaPrivateKeyDef) {
            RsaPrivateKeyDef that = (RsaPrivateKeyDef)other;
            return this.modulus.equals(that.modulus) && (this.publicExponent == null ? that.publicExponent == null : this.publicExponent.equals(that.publicExponent)) && this.privateExponent.equals(that.privateExponent) && this.primeDefs.equals(that.primeDefs);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(RsaPrivateKeyDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.modulus.hashCode()), (int)this.privateExponent.hashCode()));
    }

    public static RsaPrivateKeyDef from(RSAPrivateKey key) {
        if (key instanceof RSAMultiPrimePrivateCrtKey) {
            return RsaPrivateKeyDef.from((RSAMultiPrimePrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return RsaPrivateKeyDef.from((RSAPrivateCrtKey)key);
        }
        return new RsaPrivateKeyDef(key.getModulus(), key.getPrivateExponent(), key);
    }

    private static RsaPrivateKeyDef from(RSAMultiPrimePrivateCrtKey key) {
        FingerTrieSeq primeDefs = FingerTrieSeq.empty();
        primeDefs = primeDefs.appended((Object)new RsaPrimeDef(key.getPrimeP(), key.getPrimeExponentP()));
        primeDefs = primeDefs.appended((Object)new RsaPrimeDef(key.getPrimeQ(), key.getPrimeExponentQ(), key.getCrtCoefficient()));
        RSAOtherPrimeInfo[] otherPrimes = key.getOtherPrimeInfo();
        int n = otherPrimes.length;
        for (int i = 0; i < n; ++i) {
            primeDefs = primeDefs.appended((Object)RsaPrimeDef.from(otherPrimes[i]));
        }
        return new RsaPrivateKeyDef(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), (FingerTrieSeq<RsaPrimeDef>)primeDefs, key);
    }

    private static RsaPrivateKeyDef from(RSAPrivateCrtKey key) {
        FingerTrieSeq primeDefs = FingerTrieSeq.empty();
        primeDefs = primeDefs.appended((Object)new RsaPrimeDef(key.getPrimeP(), key.getPrimeExponentP()));
        primeDefs = primeDefs.appended((Object)new RsaPrimeDef(key.getPrimeQ(), key.getPrimeExponentQ(), key.getCrtCoefficient()));
        return new RsaPrivateKeyDef(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), (FingerTrieSeq<RsaPrimeDef>)primeDefs, key);
    }

    @Kind
    public static Form<RsaPrivateKeyDef> form() {
        if (form == null) {
            form = new RsaPrivateKeyForm();
        }
        return form;
    }
}

