/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import swim.security.RsaPublicKeyDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;

final class RsaPublicKeyForm
extends Form<RsaPublicKeyDef> {
    RsaPublicKeyForm() {
    }

    public String tag() {
        return "RSAPublicKey";
    }

    public Class<?> type() {
        return RsaPublicKeyDef.class;
    }

    public Item mold(RsaPublicKeyDef keyDef) {
        return Record.create((int)3).attr(this.tag()).slot("modulus", (Value)Num.from((BigInteger)keyDef.modulus)).slot("publicExponent", (Value)Num.from((BigInteger)keyDef.publicExponent));
    }

    public RsaPublicKeyDef cast(Item item) {
        Value value = item.toValue();
        if (value.getAttr(this.tag()).isDefined()) {
            BigInteger modulus = value.get("modulus").integerValue(null);
            BigInteger publicExponent = value.get("publicExponent").integerValue(null);
            if (modulus != null && publicExponent != null) {
                return new RsaPublicKeyDef(modulus, publicExponent);
            }
        }
        return null;
    }
}

