/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.util.Iterator;
import swim.codec.Binary;
import swim.codec.Encoder;
import swim.security.DerEncoder;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;

class DerStructureEncoder
extends DerEncoder<Value> {
    DerStructureEncoder() {
    }

    @Override
    public boolean isSequence(Value value) {
        if (value instanceof Record) {
            Record record = (Record)value;
            return record.isArray();
        }
        return false;
    }

    @Override
    public Iterator<Value> iterator(Value value) {
        Record record;
        if (value instanceof Record && (record = (Record)value).isArray()) {
            return record.iterator();
        }
        return null;
    }

    @Override
    public int tagOf(Value value) {
        Record record;
        if (value instanceof Num) {
            return 2;
        }
        if (value instanceof Record && (record = (Record)value).isArray()) {
            return 48;
        }
        throw new IllegalArgumentException(value.toString());
    }

    @Override
    public int sizeOfPrimitive(Value value) {
        if (value instanceof Num) {
            BigInteger integer = value.integerValue();
            return (int)Math.ceil((double)(integer.bitLength() + 1) / 8.0);
        }
        throw new IllegalArgumentException(value.toString());
    }

    @Override
    public Encoder<?, ?> primitiveEncoder(int length, Value value) {
        if (value instanceof Num) {
            BigInteger integer = value.integerValue();
            return Binary.byteArrayWriter((byte[])integer.toByteArray());
        }
        throw new IllegalArgumentException(value.toString());
    }
}

