/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.util.Iterator;
import swim.codec.Encoder;
import swim.codec.OutputBuffer;
import swim.security.DerSequenceEncoder;
import swim.security.DerValueEncoder;

abstract class DerEncoder<V> {
    DerEncoder() {
    }

    public abstract boolean isSequence(V var1);

    public abstract Iterator<V> iterator(V var1);

    public abstract int tagOf(V var1);

    public abstract int sizeOfPrimitive(V var1);

    public abstract Encoder<?, ?> primitiveEncoder(int var1, V var2);

    public int sizeOf(V value) {
        int length = this.isSequence(value) ? this.sizeOfSequence(this.iterator(value)) : this.sizeOfPrimitive(value);
        return this.sizeOfValue(length);
    }

    public Encoder<?, ?> encoder(V value) {
        int tag = this.tagOf(value);
        if (this.isSequence(value)) {
            int length = this.sizeOfSequence(this.iterator(value));
            return this.sequenceEncoder(tag, length, this.iterator(value));
        }
        int length = this.sizeOfPrimitive(value);
        Encoder<?, ?> data = this.primitiveEncoder(length, value);
        return this.valueEncoder(tag, length, data);
    }

    public Encoder<?, ?> encode(OutputBuffer<?> output, V value) {
        int tag = this.tagOf(value);
        if (this.isSequence(value)) {
            int length = this.sizeOfSequence(this.iterator(value));
            return this.encodeSequence(output, tag, length, this.iterator(value));
        }
        int length = this.sizeOfPrimitive(value);
        Encoder<?, ?> data = this.primitiveEncoder(length, value);
        return this.encodeValue(output, tag, length, data);
    }

    public int sizeOfValue(int length) {
        return 1 + DerEncoder.sizeOfLength(length) + length;
    }

    public Encoder<?, ?> valueEncoder(int tag, int length, Encoder<?, ?> data) {
        return new DerValueEncoder(this, tag, length, data);
    }

    public Encoder<?, ?> encodeValue(OutputBuffer<?> output, int tag, int length, Encoder<?, ?> data) {
        return DerValueEncoder.encode(output, this, tag, length, data);
    }

    public int sizeOfSequence(Iterator<V> elements) {
        int size = 0;
        while (elements.hasNext()) {
            size += this.sizeOf(elements.next());
        }
        return size;
    }

    public Encoder<?, ?> sequenceEncoder(int tag, int length, Iterator<V> elements) {
        return new DerSequenceEncoder<V>(this, tag, length, elements);
    }

    public Encoder<?, ?> encodeSequence(OutputBuffer<?> output, int tag, int length, Iterator<V> elements) {
        return DerSequenceEncoder.encode(output, this, tag, length, elements);
    }

    static int sizeOfLength(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 256) {
            return 2;
        }
        if (length < 65536) {
            return 3;
        }
        if (length < 0x1000000) {
            return 4;
        }
        return 5;
    }
}

