/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.security.DerEncoder;

final class DerValueEncoder<V>
extends Encoder<Object, Object> {
    DerEncoder<V> der;
    final int tag;
    final int length;
    final Encoder<?, ?> data;
    final int offset;
    final int step;

    DerValueEncoder(DerEncoder<V> der, int tag, int length, Encoder<?, ?> data, int offset, int step) {
        this.der = der;
        this.tag = tag;
        this.length = length;
        this.data = data;
        this.offset = offset;
        this.step = step;
    }

    DerValueEncoder(DerEncoder<V> der, int tag, int length, Encoder<?, ?> data) {
        this(der, tag, length, data, 0, 1);
    }

    public Encoder<Object, Object> pull(OutputBuffer<?> output) {
        return DerValueEncoder.encode(output, this.der, this.tag, this.length, this.data, this.offset, this.step);
    }

    static <V> Encoder<Object, Object> encode(OutputBuffer<?> output, DerEncoder<V> der, int tag, int length, Encoder<?, ?> data, int offset, int step) {
        if (step == 1 && output.isCont()) {
            output = output.write(tag);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            if (length < 128) {
                output = output.write(length);
                step = 7;
            } else if (length < 256) {
                output = output.write(129);
                step = 6;
            } else if (length < 65536) {
                output = output.write(130);
                step = 5;
            } else if (length < 0x1000000) {
                output = output.write(131);
                step = 4;
            } else {
                output = output.write(132);
                step = 3;
            }
        }
        if (step == 3 && output.isCont()) {
            output = output.write(length >> 24);
            step = 4;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(length >> 16);
            step = 5;
        }
        if (step == 5 && output.isCont()) {
            output = output.write(length >> 8);
            step = 6;
        }
        if (step == 6 && output.isCont()) {
            output = output.write(length);
            step = 7;
        }
        if (step == 7) {
            int outputStart = output.index();
            int outputLimit = output.limit();
            int outputRemaining = outputLimit - outputStart;
            int inputRemaining = length - offset;
            boolean outputPart = output.isPart();
            if (inputRemaining <= outputRemaining) {
                output = output.limit(outputStart + inputRemaining).isPart(false);
                data = data.pull(output);
                output = output.limit(outputLimit);
            } else {
                output = output.isPart(true);
                data = data.pull(output);
            }
            output = output.isPart(outputPart);
            offset += output.index() - outputStart;
            if (data.isDone()) {
                if (offset < length) {
                    return Encoder.error((Throwable)new EncoderException("buffer underflow"));
                }
                if (offset > length) {
                    return Encoder.error((Throwable)new EncoderException("buffer overflow"));
                }
                return Encoder.done();
            }
            if (data.isError()) {
                return data.asError();
            }
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new DerValueEncoder<V>(der, tag, length, data, offset, step);
    }

    static <V> Encoder<Object, Object> encode(OutputBuffer<?> output, DerEncoder<V> der, int tag, int length, Encoder<?, ?> data) {
        return DerValueEncoder.encode(output, der, tag, length, data, 0, 1);
    }
}

