/*
 * Decompiled with CFR 0.152.
 */
package swim.service.web;

import java.io.File;
import java.net.InetAddress;
import java.util.Collection;
import swim.api.policy.PlanePolicy;
import swim.api.policy.PolicyDirective;
import swim.api.service.ServiceException;
import swim.api.space.Space;
import swim.http.HttpBody;
import swim.http.HttpEntity;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.http.HttpStatus;
import swim.io.http.HttpResponder;
import swim.io.http.StaticHttpResponder;
import swim.io.warp.AbstractWarpServer;
import swim.io.warp.WarpSocket;
import swim.kernel.KernelContext;
import swim.remote.RemoteHost;
import swim.runtime.EdgeBinding;
import swim.runtime.EdgeContext;
import swim.runtime.HostBinding;
import swim.runtime.LinkBinding;
import swim.runtime.MeshBinding;
import swim.runtime.PartBinding;
import swim.service.web.HttpLaneResponder;
import swim.service.web.WebServiceDef;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriFragment;
import swim.uri.UriHost;
import swim.uri.UriPath;
import swim.uri.UriPort;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.web.WebRequest;
import swim.web.WebResponse;
import swim.web.WebRoute;
import swim.web.WebServerRequest;
import swim.web.route.DirectoryRoute;
import swim.web.route.ResourceDirectoryRoute;
import swim.ws.WsEngineSettings;
import swim.ws.WsRequest;
import swim.ws.WsResponse;

public class WebServer
extends AbstractWarpServer {
    final KernelContext kernel;
    final WebServiceDef serviceDef;
    WebRoute router;

    public WebServer(KernelContext kernel, WebServiceDef serviceDef, WebRoute router) {
        super(serviceDef.warpSettings);
        this.kernel = kernel;
        this.serviceDef = serviceDef;
        UriPath documentRoot = serviceDef.documentRoot();
        if (documentRoot != null && documentRoot.isRelative()) {
            UriPath cwd = UriPath.parse((String)new File("").getAbsolutePath().replace('\\', '/'));
            documentRoot = cwd.appended((Collection)documentRoot).removeDotSegments();
        }
        UriPath resourceRoot = serviceDef.resourceRoot();
        if (documentRoot != null) {
            router = router.orElse((WebRoute)new DirectoryRoute(documentRoot, "index.html"));
        }
        if (resourceRoot != null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            router = router.orElse((WebRoute)new ResourceDirectoryRoute(classLoader, resourceRoot, "index.html"));
        }
        this.router = router;
    }

    public final KernelContext kernel() {
        return this.kernel;
    }

    public final WebServiceDef serviceDef() {
        return this.serviceDef;
    }

    public HttpResponder<?> doRequest(HttpRequest<?> httpRequest) {
        WsResponse wsResponse;
        PolicyDirective directive;
        Space space = this.kernel.getSpace(this.serviceDef.spaceName);
        PlanePolicy policy = space != null ? space.policy() : null;
        Uri requestUri = httpRequest.uri();
        if (policy != null && (directive = policy.canConnect(requestUri)).isDenied()) {
            return new StaticHttpResponder(HttpResponse.from((HttpStatus)HttpStatus.UNAUTHORIZED).content((HttpEntity)HttpBody.empty()));
        }
        WsRequest wsRequest = WsRequest.from(httpRequest);
        if (wsRequest != null && (wsResponse = wsRequest.accept((WsEngineSettings)this.wsSettings)) != null) {
            return this.warpWebSocketResponder(wsRequest, wsResponse);
        }
        try {
            Uri laneUri = Uri.parse((String)requestUri.query().get((Object)"lane"));
            Uri nodeUri = Uri.from((UriPath)requestUri.path());
            HttpLaneResponder httpBinding = new HttpLaneResponder(Uri.empty(), Uri.empty(), nodeUri, laneUri, httpRequest);
            EdgeBinding edge = ((EdgeContext)space).edgeWrapper();
            edge.openUplink((LinkBinding)httpBinding);
            return httpBinding;
        }
        catch (Exception laneUri) {
            WebServerRequest webRequest = new WebServerRequest(httpRequest);
            WebResponse webResponse = this.router.routeRequest((WebRequest)webRequest);
            if (webResponse.isRejected()) {
                webResponse = this.kernel.routeRequest((WebRequest)webRequest);
            }
            return webResponse.httpResponder();
        }
    }

    protected HttpResponder<?> warpWebSocketResponder(WsRequest wsRequest, WsResponse wsResponse) {
        RemoteHost host = this.openHost(wsRequest.httpRequest().uri());
        return this.upgrade((WarpSocket)host, wsResponse);
    }

    protected RemoteHost openHost(Uri requestUri) {
        Uri baseUri = Uri.from((UriScheme)UriScheme.from((String)"warp"), (UriAuthority)UriAuthority.from((UriHost)UriHost.inetAddress((InetAddress)this.context.localAddress().getAddress()), (UriPort)UriPort.from((int)this.context.localAddress().getPort())), (UriPath)requestUri.path(), (UriQuery)requestUri.query(), (UriFragment)requestUri.fragment());
        Uri remoteUri = Uri.from((UriScheme)UriScheme.from((String)"warp"), (UriAuthority)UriAuthority.from((UriHost)UriHost.inetAddress((InetAddress)this.context.remoteAddress().getAddress()), (UriPort)UriPort.from((int)this.context.remoteAddress().getPort())), (UriPath)UriPath.slash());
        String spaceName = this.serviceDef.spaceName;
        Space space = this.kernel.getSpace(spaceName);
        if (space != null) {
            EdgeBinding edge = ((EdgeContext)space).edgeWrapper();
            MeshBinding mesh = edge.openMesh(remoteUri);
            PartBinding gateway = mesh.openGateway();
            RemoteHost host = new RemoteHost(requestUri, baseUri);
            gateway.openHost(remoteUri, (HostBinding)host);
            return host;
        }
        throw new ServiceException("unknown space: " + spaceName);
    }
}

