/*
 * Decompiled with CFR 0.152.
 */
package swim.service.web;

import swim.api.service.ServiceDef;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.io.warp.WarpSettings;
import swim.uri.UriPath;
import swim.util.Murmur3;

public class WebServiceDef
implements ServiceDef,
Debug {
    private static int hashSeed;
    final String serviceName;
    final String address;
    final int port;
    final boolean isSecure;
    final String spaceName;
    final UriPath documentRoot;
    final UriPath resourceRoot;
    final WarpSettings warpSettings;

    public WebServiceDef(String serviceName, String address, int port, boolean isSecure, String spaceName, UriPath documentRoot, UriPath resourceRoot, WarpSettings warpSettings) {
        this.serviceName = serviceName;
        this.address = address;
        this.port = port;
        this.isSecure = isSecure;
        this.spaceName = spaceName;
        this.documentRoot = documentRoot;
        this.resourceRoot = resourceRoot;
        this.warpSettings = warpSettings;
    }

    public static WebServiceDef standard() {
        return new WebServiceDef("web", "0.0.0.0", 80, false, null, null, null, WarpSettings.standard());
    }

    public static WebServiceDef secure() {
        return new WebServiceDef("web", "0.0.0.0", 443, true, null, null, null, WarpSettings.standard());
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public WebServiceDef serviceName(String serviceName) {
        return this.copy(serviceName, this.address, this.port, this.isSecure, this.spaceName, this.documentRoot, this.resourceRoot, this.warpSettings);
    }

    public final String address() {
        return this.address;
    }

    public WebServiceDef address(String address) {
        return this.copy(this.serviceName, address, this.port, this.isSecure, this.spaceName, this.documentRoot, this.resourceRoot, this.warpSettings);
    }

    public final int port() {
        return this.port;
    }

    public WebServiceDef port(int port) {
        return this.copy(this.serviceName, this.address, port, this.isSecure, this.spaceName, this.documentRoot, this.resourceRoot, this.warpSettings);
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public WebServiceDef spaceName(String spaceName) {
        return this.copy(this.serviceName, this.address, this.port, this.isSecure, spaceName, this.documentRoot, this.resourceRoot, this.warpSettings);
    }

    public final UriPath documentRoot() {
        return this.documentRoot;
    }

    public WebServiceDef documentRoot(UriPath documentRoot) {
        return this.copy(this.serviceName, this.address, this.port, this.isSecure, this.spaceName, documentRoot, this.resourceRoot, this.warpSettings);
    }

    public final UriPath resourceRoot() {
        return this.resourceRoot;
    }

    public WebServiceDef resourceRoot(UriPath resourceRoot) {
        return this.copy(this.serviceName, this.address, this.port, this.isSecure, this.spaceName, this.documentRoot, resourceRoot, this.warpSettings);
    }

    public final WarpSettings warpSettings() {
        return this.warpSettings;
    }

    public WebServiceDef warpSettings(WarpSettings warpSettings) {
        return this.copy(this.serviceName, this.address, this.port, this.isSecure, this.spaceName, this.documentRoot, this.resourceRoot, warpSettings);
    }

    protected WebServiceDef copy(String serviceName, String address, int port, boolean isSecure, String spaceName, UriPath documentRoot, UriPath resourceRoot, WarpSettings warpSettings) {
        return new WebServiceDef(serviceName, address, port, isSecure, spaceName, documentRoot, resourceRoot, warpSettings);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WebServiceDef) {
            WebServiceDef that = (WebServiceDef)other;
            return (this.serviceName == null ? that.serviceName == null : this.serviceName.equals(that.serviceName)) && this.address.equals(that.address) && this.port == that.port && this.isSecure == that.isSecure && (this.spaceName == null ? that.spaceName == null : this.spaceName.equals(that.spaceName)) && (this.documentRoot == null ? that.documentRoot == null : this.documentRoot.equals((Object)that.documentRoot)) && (this.resourceRoot == null ? that.resourceRoot == null : this.resourceRoot.equals((Object)that.resourceRoot)) && this.warpSettings.equals((Object)that.warpSettings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WebServiceDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.serviceName)), (int)this.address.hashCode()), (int)this.port), (int)Murmur3.hash((boolean)this.isSecure)), (int)Murmur3.hash((Object)this.spaceName)), (int)Murmur3.hash((Object)this.documentRoot)), (int)Murmur3.hash((Object)this.resourceRoot)), (int)this.warpSettings.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("WebServiceDef").write(46).write(this.isSecure ? "secure" : "standard").write(40).write(41);
        if (!"web".equals(this.serviceName)) {
            output = output.write(46).write("serviceName").write(40).debug((Object)this.serviceName).write(41);
        }
        if (!"0.0.0.0".equals(this.address)) {
            output = output.write(46).write("address").write(40).debug((Object)this.address).write(41);
        }
        if (this.isSecure && this.port != 443 || !this.isSecure && this.port != 80) {
            output = output.write(46).write("port").write(40).debug((Object)this.port).write(41);
        }
        if (this.spaceName != null) {
            output = output.write(46).write("spaceName").write(40).debug((Object)this.spaceName).write(41);
        }
        if (this.documentRoot != null) {
            output = output.write(46).write("documentRoot").write(40).debug((Object)this.documentRoot).write(41);
        }
        if (this.resourceRoot != null) {
            output = output.write(46).write("resourceRoot").write(40).debug((Object)this.resourceRoot).write(41);
        }
        if (this.warpSettings != WarpSettings.standard()) {
            output = output.write(46).write("warpSettings").write(40).debug((Object)this.warpSettings).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

